/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eventbridge.model.EndpointEventBus;
import software.amazon.awssdk.services.eventbridge.model.EndpointEventBusListCopier;
import software.amazon.awssdk.services.eventbridge.model.EventBridgeRequest;
import software.amazon.awssdk.services.eventbridge.model.ReplicationConfig;
import software.amazon.awssdk.services.eventbridge.model.RoutingConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEndpointRequest
extends EventBridgeRequest
implements ToCopyableBuilder<Builder, UpdateEndpointRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateEndpointRequest.getter(UpdateEndpointRequest::name)).setter(UpdateEndpointRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateEndpointRequest.getter(UpdateEndpointRequest::description)).setter(UpdateEndpointRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<RoutingConfig> ROUTING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RoutingConfig").getter(UpdateEndpointRequest.getter(UpdateEndpointRequest::routingConfig)).setter(UpdateEndpointRequest.setter(Builder::routingConfig)).constructor(RoutingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingConfig").build()}).build();
    private static final SdkField<ReplicationConfig> REPLICATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReplicationConfig").getter(UpdateEndpointRequest.getter(UpdateEndpointRequest::replicationConfig)).setter(UpdateEndpointRequest.setter(Builder::replicationConfig)).constructor(ReplicationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationConfig").build()}).build();
    private static final SdkField<List<EndpointEventBus>> EVENT_BUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventBuses").getter(UpdateEndpointRequest.getter(UpdateEndpointRequest::eventBuses)).setter(UpdateEndpointRequest.setter(Builder::eventBuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EndpointEventBus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(UpdateEndpointRequest.getter(UpdateEndpointRequest::roleArn)).setter(UpdateEndpointRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, ROUTING_CONFIG_FIELD, REPLICATION_CONFIG_FIELD, EVENT_BUSES_FIELD, ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("RoutingConfig", ROUTING_CONFIG_FIELD);
            this.put("ReplicationConfig", REPLICATION_CONFIG_FIELD);
            this.put("EventBuses", EVENT_BUSES_FIELD);
            this.put("RoleArn", ROLE_ARN_FIELD);
        }
    });
    private final String name;
    private final String description;
    private final RoutingConfig routingConfig;
    private final ReplicationConfig replicationConfig;
    private final List<EndpointEventBus> eventBuses;
    private final String roleArn;

    private UpdateEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.routingConfig = builder.routingConfig;
        this.replicationConfig = builder.replicationConfig;
        this.eventBuses = builder.eventBuses;
        this.roleArn = builder.roleArn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final RoutingConfig routingConfig() {
        return this.routingConfig;
    }

    public final ReplicationConfig replicationConfig() {
        return this.replicationConfig;
    }

    public final boolean hasEventBuses() {
        return this.eventBuses != null && !(this.eventBuses instanceof SdkAutoConstructList);
    }

    public final List<EndpointEventBus> eventBuses() {
        return this.eventBuses;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventBuses() ? this.eventBuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEndpointRequest)) {
            return false;
        }
        UpdateEndpointRequest other = (UpdateEndpointRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.routingConfig(), other.routingConfig()) && Objects.equals(this.replicationConfig(), other.replicationConfig()) && this.hasEventBuses() == other.hasEventBuses() && Objects.equals(this.eventBuses(), other.eventBuses()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateEndpointRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("RoutingConfig", (Object)this.routingConfig()).add("ReplicationConfig", (Object)this.replicationConfig()).add("EventBuses", this.hasEventBuses() ? this.eventBuses() : null).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RoutingConfig": {
                return Optional.ofNullable(clazz.cast(this.routingConfig()));
            }
            case "ReplicationConfig": {
                return Optional.ofNullable(clazz.cast(this.replicationConfig()));
            }
            case "EventBuses": {
                return Optional.ofNullable(clazz.cast(this.eventBuses()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEndpointRequest, T> g) {
        return obj -> g.apply((UpdateEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EventBridgeRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private RoutingConfig routingConfig;
        private ReplicationConfig replicationConfig;
        private List<EndpointEventBus> eventBuses = DefaultSdkAutoConstructList.getInstance();
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEndpointRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.routingConfig(model.routingConfig);
            this.replicationConfig(model.replicationConfig);
            this.eventBuses(model.eventBuses);
            this.roleArn(model.roleArn);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final RoutingConfig.Builder getRoutingConfig() {
            return this.routingConfig != null ? this.routingConfig.toBuilder() : null;
        }

        public final void setRoutingConfig(RoutingConfig.BuilderImpl routingConfig) {
            this.routingConfig = routingConfig != null ? routingConfig.build() : null;
        }

        @Override
        public final Builder routingConfig(RoutingConfig routingConfig) {
            this.routingConfig = routingConfig;
            return this;
        }

        public final ReplicationConfig.Builder getReplicationConfig() {
            return this.replicationConfig != null ? this.replicationConfig.toBuilder() : null;
        }

        public final void setReplicationConfig(ReplicationConfig.BuilderImpl replicationConfig) {
            this.replicationConfig = replicationConfig != null ? replicationConfig.build() : null;
        }

        @Override
        public final Builder replicationConfig(ReplicationConfig replicationConfig) {
            this.replicationConfig = replicationConfig;
            return this;
        }

        public final List<EndpointEventBus.Builder> getEventBuses() {
            List<EndpointEventBus.Builder> result = EndpointEventBusListCopier.copyToBuilder(this.eventBuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventBuses(Collection<EndpointEventBus.BuilderImpl> eventBuses) {
            this.eventBuses = EndpointEventBusListCopier.copyFromBuilder(eventBuses);
        }

        @Override
        public final Builder eventBuses(Collection<EndpointEventBus> eventBuses) {
            this.eventBuses = EndpointEventBusListCopier.copy(eventBuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventBuses(EndpointEventBus ... eventBuses) {
            this.eventBuses(Arrays.asList(eventBuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventBuses(Consumer<EndpointEventBus.Builder> ... eventBuses) {
            this.eventBuses(Stream.of(eventBuses).map(c -> (EndpointEventBus)((EndpointEventBus.Builder)EndpointEventBus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEndpointRequest build() {
            return new UpdateEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EventBridgeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEndpointRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder routingConfig(RoutingConfig var1);

        default public Builder routingConfig(Consumer<RoutingConfig.Builder> routingConfig) {
            return this.routingConfig((RoutingConfig)((RoutingConfig.Builder)RoutingConfig.builder().applyMutation(routingConfig)).build());
        }

        public Builder replicationConfig(ReplicationConfig var1);

        default public Builder replicationConfig(Consumer<ReplicationConfig.Builder> replicationConfig) {
            return this.replicationConfig((ReplicationConfig)((ReplicationConfig.Builder)ReplicationConfig.builder().applyMutation(replicationConfig)).build());
        }

        public Builder eventBuses(Collection<EndpointEventBus> var1);

        public Builder eventBuses(EndpointEventBus ... var1);

        public Builder eventBuses(Consumer<EndpointEventBus.Builder> ... var1);

        public Builder roleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

