/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.emrcontainers.model.ConfigurationOverrides;
import software.amazon.awssdk.services.emrcontainers.model.EmrContainersRequest;
import software.amazon.awssdk.services.emrcontainers.model.JobDriver;
import software.amazon.awssdk.services.emrcontainers.model.RetryPolicyConfiguration;
import software.amazon.awssdk.services.emrcontainers.model.TagMapCopier;
import software.amazon.awssdk.services.emrcontainers.model.TemplateParameterInputMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartJobRunRequest
extends EmrContainersRequest
implements ToCopyableBuilder<Builder, StartJobRunRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(StartJobRunRequest.getter(StartJobRunRequest::name)).setter(StartJobRunRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> VIRTUAL_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualClusterId").getter(StartJobRunRequest.getter(StartJobRunRequest::virtualClusterId)).setter(StartJobRunRequest.setter(Builder::virtualClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("virtualClusterId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(StartJobRunRequest.getter(StartJobRunRequest::clientToken)).setter(StartJobRunRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRoleArn").getter(StartJobRunRequest.getter(StartJobRunRequest::executionRoleArn)).setter(StartJobRunRequest.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()}).build();
    private static final SdkField<String> RELEASE_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("releaseLabel").getter(StartJobRunRequest.getter(StartJobRunRequest::releaseLabel)).setter(StartJobRunRequest.setter(Builder::releaseLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseLabel").build()}).build();
    private static final SdkField<JobDriver> JOB_DRIVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobDriver").getter(StartJobRunRequest.getter(StartJobRunRequest::jobDriver)).setter(StartJobRunRequest.setter(Builder::jobDriver)).constructor(JobDriver::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDriver").build()}).build();
    private static final SdkField<ConfigurationOverrides> CONFIGURATION_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configurationOverrides").getter(StartJobRunRequest.getter(StartJobRunRequest::configurationOverrides)).setter(StartJobRunRequest.setter(Builder::configurationOverrides)).constructor(ConfigurationOverrides::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationOverrides").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(StartJobRunRequest.getter(StartJobRunRequest::tags)).setter(StartJobRunRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> JOB_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobTemplateId").getter(StartJobRunRequest.getter(StartJobRunRequest::jobTemplateId)).setter(StartJobRunRequest.setter(Builder::jobTemplateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTemplateId").build()}).build();
    private static final SdkField<Map<String, String>> JOB_TEMPLATE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("jobTemplateParameters").getter(StartJobRunRequest.getter(StartJobRunRequest::jobTemplateParameters)).setter(StartJobRunRequest.setter(Builder::jobTemplateParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTemplateParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<RetryPolicyConfiguration> RETRY_POLICY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("retryPolicyConfiguration").getter(StartJobRunRequest.getter(StartJobRunRequest::retryPolicyConfiguration)).setter(StartJobRunRequest.setter(Builder::retryPolicyConfiguration)).constructor(RetryPolicyConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryPolicyConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VIRTUAL_CLUSTER_ID_FIELD, CLIENT_TOKEN_FIELD, EXECUTION_ROLE_ARN_FIELD, RELEASE_LABEL_FIELD, JOB_DRIVER_FIELD, CONFIGURATION_OVERRIDES_FIELD, TAGS_FIELD, JOB_TEMPLATE_ID_FIELD, JOB_TEMPLATE_PARAMETERS_FIELD, RETRY_POLICY_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("virtualClusterId", VIRTUAL_CLUSTER_ID_FIELD);
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("executionRoleArn", EXECUTION_ROLE_ARN_FIELD);
            this.put("releaseLabel", RELEASE_LABEL_FIELD);
            this.put("jobDriver", JOB_DRIVER_FIELD);
            this.put("configurationOverrides", CONFIGURATION_OVERRIDES_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("jobTemplateId", JOB_TEMPLATE_ID_FIELD);
            this.put("jobTemplateParameters", JOB_TEMPLATE_PARAMETERS_FIELD);
            this.put("retryPolicyConfiguration", RETRY_POLICY_CONFIGURATION_FIELD);
        }
    });
    private final String name;
    private final String virtualClusterId;
    private final String clientToken;
    private final String executionRoleArn;
    private final String releaseLabel;
    private final JobDriver jobDriver;
    private final ConfigurationOverrides configurationOverrides;
    private final Map<String, String> tags;
    private final String jobTemplateId;
    private final Map<String, String> jobTemplateParameters;
    private final RetryPolicyConfiguration retryPolicyConfiguration;

    private StartJobRunRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.virtualClusterId = builder.virtualClusterId;
        this.clientToken = builder.clientToken;
        this.executionRoleArn = builder.executionRoleArn;
        this.releaseLabel = builder.releaseLabel;
        this.jobDriver = builder.jobDriver;
        this.configurationOverrides = builder.configurationOverrides;
        this.tags = builder.tags;
        this.jobTemplateId = builder.jobTemplateId;
        this.jobTemplateParameters = builder.jobTemplateParameters;
        this.retryPolicyConfiguration = builder.retryPolicyConfiguration;
    }

    public final String name() {
        return this.name;
    }

    public final String virtualClusterId() {
        return this.virtualClusterId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final String releaseLabel() {
        return this.releaseLabel;
    }

    public final JobDriver jobDriver() {
        return this.jobDriver;
    }

    public final ConfigurationOverrides configurationOverrides() {
        return this.configurationOverrides;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String jobTemplateId() {
        return this.jobTemplateId;
    }

    public final boolean hasJobTemplateParameters() {
        return this.jobTemplateParameters != null && !(this.jobTemplateParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> jobTemplateParameters() {
        return this.jobTemplateParameters;
    }

    public final RetryPolicyConfiguration retryPolicyConfiguration() {
        return this.retryPolicyConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDriver());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobTemplateParameters() ? this.jobTemplateParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.retryPolicyConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartJobRunRequest)) {
            return false;
        }
        StartJobRunRequest other = (StartJobRunRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.virtualClusterId(), other.virtualClusterId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.releaseLabel(), other.releaseLabel()) && Objects.equals(this.jobDriver(), other.jobDriver()) && Objects.equals(this.configurationOverrides(), other.configurationOverrides()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.jobTemplateId(), other.jobTemplateId()) && this.hasJobTemplateParameters() == other.hasJobTemplateParameters() && Objects.equals(this.jobTemplateParameters(), other.jobTemplateParameters()) && Objects.equals(this.retryPolicyConfiguration(), other.retryPolicyConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"StartJobRunRequest").add("Name", (Object)this.name()).add("VirtualClusterId", (Object)this.virtualClusterId()).add("ClientToken", (Object)this.clientToken()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("ReleaseLabel", (Object)this.releaseLabel()).add("JobDriver", (Object)this.jobDriver()).add("ConfigurationOverrides", (Object)this.configurationOverrides()).add("Tags", this.hasTags() ? this.tags() : null).add("JobTemplateId", (Object)this.jobTemplateId()).add("JobTemplateParameters", this.hasJobTemplateParameters() ? this.jobTemplateParameters() : null).add("RetryPolicyConfiguration", (Object)this.retryPolicyConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "virtualClusterId": {
                return Optional.ofNullable(clazz.cast(this.virtualClusterId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "executionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "releaseLabel": {
                return Optional.ofNullable(clazz.cast(this.releaseLabel()));
            }
            case "jobDriver": {
                return Optional.ofNullable(clazz.cast(this.jobDriver()));
            }
            case "configurationOverrides": {
                return Optional.ofNullable(clazz.cast(this.configurationOverrides()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "jobTemplateId": {
                return Optional.ofNullable(clazz.cast(this.jobTemplateId()));
            }
            case "jobTemplateParameters": {
                return Optional.ofNullable(clazz.cast(this.jobTemplateParameters()));
            }
            case "retryPolicyConfiguration": {
                return Optional.ofNullable(clazz.cast(this.retryPolicyConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartJobRunRequest, T> g) {
        return obj -> g.apply((StartJobRunRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrContainersRequest.BuilderImpl
    implements Builder {
        private String name;
        private String virtualClusterId;
        private String clientToken;
        private String executionRoleArn;
        private String releaseLabel;
        private JobDriver jobDriver;
        private ConfigurationOverrides configurationOverrides;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String jobTemplateId;
        private Map<String, String> jobTemplateParameters = DefaultSdkAutoConstructMap.getInstance();
        private RetryPolicyConfiguration retryPolicyConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(StartJobRunRequest model) {
            super(model);
            this.name(model.name);
            this.virtualClusterId(model.virtualClusterId);
            this.clientToken(model.clientToken);
            this.executionRoleArn(model.executionRoleArn);
            this.releaseLabel(model.releaseLabel);
            this.jobDriver(model.jobDriver);
            this.configurationOverrides(model.configurationOverrides);
            this.tags(model.tags);
            this.jobTemplateId(model.jobTemplateId);
            this.jobTemplateParameters(model.jobTemplateParameters);
            this.retryPolicyConfiguration(model.retryPolicyConfiguration);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVirtualClusterId() {
            return this.virtualClusterId;
        }

        public final void setVirtualClusterId(String virtualClusterId) {
            this.virtualClusterId = virtualClusterId;
        }

        @Override
        public final Builder virtualClusterId(String virtualClusterId) {
            this.virtualClusterId = virtualClusterId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getReleaseLabel() {
            return this.releaseLabel;
        }

        public final void setReleaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
        }

        @Override
        public final Builder releaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        public final JobDriver.Builder getJobDriver() {
            return this.jobDriver != null ? this.jobDriver.toBuilder() : null;
        }

        public final void setJobDriver(JobDriver.BuilderImpl jobDriver) {
            this.jobDriver = jobDriver != null ? jobDriver.build() : null;
        }

        @Override
        public final Builder jobDriver(JobDriver jobDriver) {
            this.jobDriver = jobDriver;
            return this;
        }

        public final ConfigurationOverrides.Builder getConfigurationOverrides() {
            return this.configurationOverrides != null ? this.configurationOverrides.toBuilder() : null;
        }

        public final void setConfigurationOverrides(ConfigurationOverrides.BuilderImpl configurationOverrides) {
            this.configurationOverrides = configurationOverrides != null ? configurationOverrides.build() : null;
        }

        @Override
        public final Builder configurationOverrides(ConfigurationOverrides configurationOverrides) {
            this.configurationOverrides = configurationOverrides;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getJobTemplateId() {
            return this.jobTemplateId;
        }

        public final void setJobTemplateId(String jobTemplateId) {
            this.jobTemplateId = jobTemplateId;
        }

        @Override
        public final Builder jobTemplateId(String jobTemplateId) {
            this.jobTemplateId = jobTemplateId;
            return this;
        }

        public final Map<String, String> getJobTemplateParameters() {
            if (this.jobTemplateParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.jobTemplateParameters;
        }

        public final void setJobTemplateParameters(Map<String, String> jobTemplateParameters) {
            this.jobTemplateParameters = TemplateParameterInputMapCopier.copy(jobTemplateParameters);
        }

        @Override
        public final Builder jobTemplateParameters(Map<String, String> jobTemplateParameters) {
            this.jobTemplateParameters = TemplateParameterInputMapCopier.copy(jobTemplateParameters);
            return this;
        }

        public final RetryPolicyConfiguration.Builder getRetryPolicyConfiguration() {
            return this.retryPolicyConfiguration != null ? this.retryPolicyConfiguration.toBuilder() : null;
        }

        public final void setRetryPolicyConfiguration(RetryPolicyConfiguration.BuilderImpl retryPolicyConfiguration) {
            this.retryPolicyConfiguration = retryPolicyConfiguration != null ? retryPolicyConfiguration.build() : null;
        }

        @Override
        public final Builder retryPolicyConfiguration(RetryPolicyConfiguration retryPolicyConfiguration) {
            this.retryPolicyConfiguration = retryPolicyConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartJobRunRequest build() {
            return new StartJobRunRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EmrContainersRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartJobRunRequest> {
        public Builder name(String var1);

        public Builder virtualClusterId(String var1);

        public Builder clientToken(String var1);

        public Builder executionRoleArn(String var1);

        public Builder releaseLabel(String var1);

        public Builder jobDriver(JobDriver var1);

        default public Builder jobDriver(Consumer<JobDriver.Builder> jobDriver) {
            return this.jobDriver((JobDriver)((JobDriver.Builder)JobDriver.builder().applyMutation(jobDriver)).build());
        }

        public Builder configurationOverrides(ConfigurationOverrides var1);

        default public Builder configurationOverrides(Consumer<ConfigurationOverrides.Builder> configurationOverrides) {
            return this.configurationOverrides((ConfigurationOverrides)((ConfigurationOverrides.Builder)ConfigurationOverrides.builder().applyMutation(configurationOverrides)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder jobTemplateId(String var1);

        public Builder jobTemplateParameters(Map<String, String> var1);

        public Builder retryPolicyConfiguration(RetryPolicyConfiguration var1);

        default public Builder retryPolicyConfiguration(Consumer<RetryPolicyConfiguration.Builder> retryPolicyConfiguration) {
            return this.retryPolicyConfiguration((RetryPolicyConfiguration)((RetryPolicyConfiguration.Builder)RetryPolicyConfiguration.builder().applyMutation(retryPolicyConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

