/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elastictranscoder.model.ElasticTranscoderResponse;
import software.amazon.awssdk.services.elastictranscoder.model.Pipeline;
import software.amazon.awssdk.services.elastictranscoder.model.PipelinesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPipelinesResponse
extends ElasticTranscoderResponse
implements ToCopyableBuilder<Builder, ListPipelinesResponse> {
    private static final SdkField<List<Pipeline>> PIPELINES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Pipelines").getter(ListPipelinesResponse.getter(ListPipelinesResponse::pipelines)).setter(ListPipelinesResponse.setter(Builder::pipelines)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pipelines").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Pipeline::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(ListPipelinesResponse.getter(ListPipelinesResponse::nextPageToken)).setter(ListPipelinesResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINES_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Pipelines", PIPELINES_FIELD);
            this.put("NextPageToken", NEXT_PAGE_TOKEN_FIELD);
        }
    });
    private final List<Pipeline> pipelines;
    private final String nextPageToken;

    private ListPipelinesResponse(BuilderImpl builder) {
        super(builder);
        this.pipelines = builder.pipelines;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasPipelines() {
        return this.pipelines != null && !(this.pipelines instanceof SdkAutoConstructList);
    }

    public final List<Pipeline> pipelines() {
        return this.pipelines;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPipelines() ? this.pipelines() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipelinesResponse)) {
            return false;
        }
        ListPipelinesResponse other = (ListPipelinesResponse)((Object)obj);
        return this.hasPipelines() == other.hasPipelines() && Objects.equals(this.pipelines(), other.pipelines()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPipelinesResponse").add("Pipelines", this.hasPipelines() ? this.pipelines() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Pipelines": {
                return Optional.ofNullable(clazz.cast(this.pipelines()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListPipelinesResponse, T> g) {
        return obj -> g.apply((ListPipelinesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticTranscoderResponse.BuilderImpl
    implements Builder {
        private List<Pipeline> pipelines = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPipelinesResponse model) {
            super(model);
            this.pipelines(model.pipelines);
            this.nextPageToken(model.nextPageToken);
        }

        public final List<Pipeline.Builder> getPipelines() {
            List<Pipeline.Builder> result = PipelinesCopier.copyToBuilder(this.pipelines);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPipelines(Collection<Pipeline.BuilderImpl> pipelines) {
            this.pipelines = PipelinesCopier.copyFromBuilder(pipelines);
        }

        @Override
        public final Builder pipelines(Collection<Pipeline> pipelines) {
            this.pipelines = PipelinesCopier.copy(pipelines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelines(Pipeline ... pipelines) {
            this.pipelines(Arrays.asList(pipelines));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelines(Consumer<Pipeline.Builder> ... pipelines) {
            this.pipelines(Stream.of(pipelines).map(c -> (Pipeline)((Pipeline.Builder)Pipeline.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public ListPipelinesResponse build() {
            return new ListPipelinesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElasticTranscoderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPipelinesResponse> {
        public Builder pipelines(Collection<Pipeline> var1);

        public Builder pipelines(Pipeline ... var1);

        public Builder pipelines(Consumer<Pipeline.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

