/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.SolutionStackFileTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SolutionStackDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SolutionStackDescription> {
    private static final SdkField<String> SOLUTION_STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SolutionStackName").getter(SolutionStackDescription.getter(SolutionStackDescription::solutionStackName)).setter(SolutionStackDescription.setter(Builder::solutionStackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SolutionStackName").build()}).build();
    private static final SdkField<List<String>> PERMITTED_FILE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PermittedFileTypes").getter(SolutionStackDescription.getter(SolutionStackDescription::permittedFileTypes)).setter(SolutionStackDescription.setter(Builder::permittedFileTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermittedFileTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOLUTION_STACK_NAME_FIELD, PERMITTED_FILE_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SolutionStackName", SOLUTION_STACK_NAME_FIELD);
            this.put("PermittedFileTypes", PERMITTED_FILE_TYPES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String solutionStackName;
    private final List<String> permittedFileTypes;

    private SolutionStackDescription(BuilderImpl builder) {
        this.solutionStackName = builder.solutionStackName;
        this.permittedFileTypes = builder.permittedFileTypes;
    }

    public final String solutionStackName() {
        return this.solutionStackName;
    }

    public final boolean hasPermittedFileTypes() {
        return this.permittedFileTypes != null && !(this.permittedFileTypes instanceof SdkAutoConstructList);
    }

    public final List<String> permittedFileTypes() {
        return this.permittedFileTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionStackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermittedFileTypes() ? this.permittedFileTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SolutionStackDescription)) {
            return false;
        }
        SolutionStackDescription other = (SolutionStackDescription)obj;
        return Objects.equals(this.solutionStackName(), other.solutionStackName()) && this.hasPermittedFileTypes() == other.hasPermittedFileTypes() && Objects.equals(this.permittedFileTypes(), other.permittedFileTypes());
    }

    public final String toString() {
        return ToString.builder((String)"SolutionStackDescription").add("SolutionStackName", (Object)this.solutionStackName()).add("PermittedFileTypes", this.hasPermittedFileTypes() ? this.permittedFileTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SolutionStackName": {
                return Optional.ofNullable(clazz.cast(this.solutionStackName()));
            }
            case "PermittedFileTypes": {
                return Optional.ofNullable(clazz.cast(this.permittedFileTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SolutionStackDescription, T> g) {
        return obj -> g.apply((SolutionStackDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String solutionStackName;
        private List<String> permittedFileTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SolutionStackDescription model) {
            this.solutionStackName(model.solutionStackName);
            this.permittedFileTypes(model.permittedFileTypes);
        }

        public final String getSolutionStackName() {
            return this.solutionStackName;
        }

        public final void setSolutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
        }

        @Override
        public final Builder solutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        public final Collection<String> getPermittedFileTypes() {
            if (this.permittedFileTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.permittedFileTypes;
        }

        public final void setPermittedFileTypes(Collection<String> permittedFileTypes) {
            this.permittedFileTypes = SolutionStackFileTypeListCopier.copy(permittedFileTypes);
        }

        @Override
        public final Builder permittedFileTypes(Collection<String> permittedFileTypes) {
            this.permittedFileTypes = SolutionStackFileTypeListCopier.copy(permittedFileTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permittedFileTypes(String ... permittedFileTypes) {
            this.permittedFileTypes(Arrays.asList(permittedFileTypes));
            return this;
        }

        public SolutionStackDescription build() {
            return new SolutionStackDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SolutionStackDescription> {
        public Builder solutionStackName(String var1);

        public Builder permittedFileTypes(Collection<String> var1);

        public Builder permittedFileTypes(String ... var1);
    }
}

