/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TransitEncryptionMode {
    PREFERRED("preferred"),
    REQUIRED("required"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TransitEncryptionMode> VALUE_MAP;
    private final String value;

    private TransitEncryptionMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TransitEncryptionMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TransitEncryptionMode> knownValues() {
        EnumSet<TransitEncryptionMode> knownValues = EnumSet.allOf(TransitEncryptionMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TransitEncryptionMode.class, TransitEncryptionMode::toString);
    }
}

