/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticache.model.CloudWatchLogsDestinationDetails;
import software.amazon.awssdk.services.elasticache.model.KinesisFirehoseDestinationDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DestinationDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DestinationDetails> {
    private static final SdkField<CloudWatchLogsDestinationDetails> CLOUD_WATCH_LOGS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudWatchLogsDetails").getter(DestinationDetails.getter(DestinationDetails::cloudWatchLogsDetails)).setter(DestinationDetails.setter(Builder::cloudWatchLogsDetails)).constructor(CloudWatchLogsDestinationDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogsDetails").build()}).build();
    private static final SdkField<KinesisFirehoseDestinationDetails> KINESIS_FIREHOSE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KinesisFirehoseDetails").getter(DestinationDetails.getter(DestinationDetails::kinesisFirehoseDetails)).setter(DestinationDetails.setter(Builder::kinesisFirehoseDetails)).constructor(KinesisFirehoseDestinationDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisFirehoseDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_LOGS_DETAILS_FIELD, KINESIS_FIREHOSE_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CloudWatchLogsDetails", CLOUD_WATCH_LOGS_DETAILS_FIELD);
            this.put("KinesisFirehoseDetails", KINESIS_FIREHOSE_DETAILS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final CloudWatchLogsDestinationDetails cloudWatchLogsDetails;
    private final KinesisFirehoseDestinationDetails kinesisFirehoseDetails;

    private DestinationDetails(BuilderImpl builder) {
        this.cloudWatchLogsDetails = builder.cloudWatchLogsDetails;
        this.kinesisFirehoseDetails = builder.kinesisFirehoseDetails;
    }

    public final CloudWatchLogsDestinationDetails cloudWatchLogsDetails() {
        return this.cloudWatchLogsDetails;
    }

    public final KinesisFirehoseDestinationDetails kinesisFirehoseDetails() {
        return this.kinesisFirehoseDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogsDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisFirehoseDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationDetails)) {
            return false;
        }
        DestinationDetails other = (DestinationDetails)obj;
        return Objects.equals(this.cloudWatchLogsDetails(), other.cloudWatchLogsDetails()) && Objects.equals(this.kinesisFirehoseDetails(), other.kinesisFirehoseDetails());
    }

    public final String toString() {
        return ToString.builder((String)"DestinationDetails").add("CloudWatchLogsDetails", (Object)this.cloudWatchLogsDetails()).add("KinesisFirehoseDetails", (Object)this.kinesisFirehoseDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudWatchLogsDetails": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogsDetails()));
            }
            case "KinesisFirehoseDetails": {
                return Optional.ofNullable(clazz.cast(this.kinesisFirehoseDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DestinationDetails, T> g) {
        return obj -> g.apply((DestinationDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CloudWatchLogsDestinationDetails cloudWatchLogsDetails;
        private KinesisFirehoseDestinationDetails kinesisFirehoseDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationDetails model) {
            this.cloudWatchLogsDetails(model.cloudWatchLogsDetails);
            this.kinesisFirehoseDetails(model.kinesisFirehoseDetails);
        }

        public final CloudWatchLogsDestinationDetails.Builder getCloudWatchLogsDetails() {
            return this.cloudWatchLogsDetails != null ? this.cloudWatchLogsDetails.toBuilder() : null;
        }

        public final void setCloudWatchLogsDetails(CloudWatchLogsDestinationDetails.BuilderImpl cloudWatchLogsDetails) {
            this.cloudWatchLogsDetails = cloudWatchLogsDetails != null ? cloudWatchLogsDetails.build() : null;
        }

        @Override
        public final Builder cloudWatchLogsDetails(CloudWatchLogsDestinationDetails cloudWatchLogsDetails) {
            this.cloudWatchLogsDetails = cloudWatchLogsDetails;
            return this;
        }

        public final KinesisFirehoseDestinationDetails.Builder getKinesisFirehoseDetails() {
            return this.kinesisFirehoseDetails != null ? this.kinesisFirehoseDetails.toBuilder() : null;
        }

        public final void setKinesisFirehoseDetails(KinesisFirehoseDestinationDetails.BuilderImpl kinesisFirehoseDetails) {
            this.kinesisFirehoseDetails = kinesisFirehoseDetails != null ? kinesisFirehoseDetails.build() : null;
        }

        @Override
        public final Builder kinesisFirehoseDetails(KinesisFirehoseDestinationDetails kinesisFirehoseDetails) {
            this.kinesisFirehoseDetails = kinesisFirehoseDetails;
            return this;
        }

        public DestinationDetails build() {
            return new DestinationDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DestinationDetails> {
        public Builder cloudWatchLogsDetails(CloudWatchLogsDestinationDetails var1);

        default public Builder cloudWatchLogsDetails(Consumer<CloudWatchLogsDestinationDetails.Builder> cloudWatchLogsDetails) {
            return this.cloudWatchLogsDetails((CloudWatchLogsDestinationDetails)((CloudWatchLogsDestinationDetails.Builder)CloudWatchLogsDestinationDetails.builder().applyMutation(cloudWatchLogsDetails)).build());
        }

        public Builder kinesisFirehoseDetails(KinesisFirehoseDestinationDetails var1);

        default public Builder kinesisFirehoseDetails(Consumer<KinesisFirehoseDestinationDetails.Builder> kinesisFirehoseDetails) {
            return this.kinesisFirehoseDetails((KinesisFirehoseDestinationDetails)((KinesisFirehoseDestinationDetails.Builder)KinesisFirehoseDestinationDetails.builder().applyMutation(kinesisFirehoseDetails)).build());
        }
    }
}

