/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.Scale;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTaskSetRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, UpdateTaskSetRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cluster").getter(UpdateTaskSetRequest.getter(UpdateTaskSetRequest::cluster)).setter(UpdateTaskSetRequest.setter(Builder::cluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()}).build();
    private static final SdkField<String> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("service").getter(UpdateTaskSetRequest.getter(UpdateTaskSetRequest::service)).setter(UpdateTaskSetRequest.setter(Builder::service)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()}).build();
    private static final SdkField<String> TASK_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskSet").getter(UpdateTaskSetRequest.getter(UpdateTaskSetRequest::taskSet)).setter(UpdateTaskSetRequest.setter(Builder::taskSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskSet").build()}).build();
    private static final SdkField<Scale> SCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scale").getter(UpdateTaskSetRequest.getter(UpdateTaskSetRequest::scale)).setter(UpdateTaskSetRequest.setter(Builder::scale)).constructor(Scale::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scale").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, SERVICE_FIELD, TASK_SET_FIELD, SCALE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("cluster", CLUSTER_FIELD);
            this.put("service", SERVICE_FIELD);
            this.put("taskSet", TASK_SET_FIELD);
            this.put("scale", SCALE_FIELD);
        }
    });
    private final String cluster;
    private final String service;
    private final String taskSet;
    private final Scale scale;

    private UpdateTaskSetRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.service = builder.service;
        this.taskSet = builder.taskSet;
        this.scale = builder.scale;
    }

    public final String cluster() {
        return this.cluster;
    }

    public final String service() {
        return this.service;
    }

    public final String taskSet() {
        return this.taskSet;
    }

    public final Scale scale() {
        return this.scale;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.service());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.scale());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTaskSetRequest)) {
            return false;
        }
        UpdateTaskSetRequest other = (UpdateTaskSetRequest)((Object)obj);
        return Objects.equals(this.cluster(), other.cluster()) && Objects.equals(this.service(), other.service()) && Objects.equals(this.taskSet(), other.taskSet()) && Objects.equals(this.scale(), other.scale());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTaskSetRequest").add("Cluster", (Object)this.cluster()).add("Service", (Object)this.service()).add("TaskSet", (Object)this.taskSet()).add("Scale", (Object)this.scale()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cluster": {
                return Optional.ofNullable(clazz.cast(this.cluster()));
            }
            case "service": {
                return Optional.ofNullable(clazz.cast(this.service()));
            }
            case "taskSet": {
                return Optional.ofNullable(clazz.cast(this.taskSet()));
            }
            case "scale": {
                return Optional.ofNullable(clazz.cast(this.scale()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTaskSetRequest, T> g) {
        return obj -> g.apply((UpdateTaskSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String cluster;
        private String service;
        private String taskSet;
        private Scale scale;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTaskSetRequest model) {
            super(model);
            this.cluster(model.cluster);
            this.service(model.service);
            this.taskSet(model.taskSet);
            this.scale(model.scale);
        }

        public final String getCluster() {
            return this.cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final String getService() {
            return this.service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final String getTaskSet() {
            return this.taskSet;
        }

        public final void setTaskSet(String taskSet) {
            this.taskSet = taskSet;
        }

        @Override
        public final Builder taskSet(String taskSet) {
            this.taskSet = taskSet;
            return this;
        }

        public final Scale.Builder getScale() {
            return this.scale != null ? this.scale.toBuilder() : null;
        }

        public final void setScale(Scale.BuilderImpl scale) {
            this.scale = scale != null ? scale.build() : null;
        }

        @Override
        public final Builder scale(Scale scale) {
            this.scale = scale;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTaskSetRequest build() {
            return new UpdateTaskSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTaskSetRequest> {
        public Builder cluster(String var1);

        public Builder service(String var1);

        public Builder taskSet(String var1);

        public Builder scale(Scale var1);

        default public Builder scale(Consumer<Scale.Builder> scale) {
            return this.scale((Scale)((Scale.Builder)Scale.builder().applyMutation(scale)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

