/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeStoreImageTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeStoreImageTasksResponse;
import software.amazon.awssdk.services.ec2.model.StoreImageTaskResult;

public class DescribeStoreImageTasksIterable
implements SdkIterable<DescribeStoreImageTasksResponse> {
    private final Ec2Client client;
    private final DescribeStoreImageTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeStoreImageTasksIterable(Ec2Client client, DescribeStoreImageTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeStoreImageTasksResponseFetcher();
    }

    public Iterator<DescribeStoreImageTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StoreImageTaskResult> storeImageTaskResults() {
        Function<DescribeStoreImageTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.storeImageTaskResults() != null) {
                return response.storeImageTaskResults().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeStoreImageTasksResponseFetcher
    implements SyncPageFetcher<DescribeStoreImageTasksResponse> {
        private DescribeStoreImageTasksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeStoreImageTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeStoreImageTasksResponse nextPage(DescribeStoreImageTasksResponse previousPage) {
            if (previousPage == null) {
                return DescribeStoreImageTasksIterable.this.client.describeStoreImageTasks(DescribeStoreImageTasksIterable.this.firstRequest);
            }
            return DescribeStoreImageTasksIterable.this.client.describeStoreImageTasks((DescribeStoreImageTasksRequest)((Object)DescribeStoreImageTasksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

