/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.TunnelInsideIpVersion;
import software.amazon.awssdk.services.ec2.model.TunnelOption;
import software.amazon.awssdk.services.ec2.model.TunnelOptionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpnConnectionOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpnConnectionOptions> {
    private static final SdkField<Boolean> ENABLE_ACCELERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableAcceleration").getter(VpnConnectionOptions.getter(VpnConnectionOptions::enableAcceleration)).setter(VpnConnectionOptions.setter(Builder::enableAcceleration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableAcceleration").unmarshallLocationName("enableAcceleration").build()}).build();
    private static final SdkField<Boolean> STATIC_ROUTES_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("StaticRoutesOnly").getter(VpnConnectionOptions.getter(VpnConnectionOptions::staticRoutesOnly)).setter(VpnConnectionOptions.setter(Builder::staticRoutesOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticRoutesOnly").unmarshallLocationName("staticRoutesOnly").build()}).build();
    private static final SdkField<String> LOCAL_IPV4_NETWORK_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalIpv4NetworkCidr").getter(VpnConnectionOptions.getter(VpnConnectionOptions::localIpv4NetworkCidr)).setter(VpnConnectionOptions.setter(Builder::localIpv4NetworkCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalIpv4NetworkCidr").unmarshallLocationName("localIpv4NetworkCidr").build()}).build();
    private static final SdkField<String> REMOTE_IPV4_NETWORK_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RemoteIpv4NetworkCidr").getter(VpnConnectionOptions.getter(VpnConnectionOptions::remoteIpv4NetworkCidr)).setter(VpnConnectionOptions.setter(Builder::remoteIpv4NetworkCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteIpv4NetworkCidr").unmarshallLocationName("remoteIpv4NetworkCidr").build()}).build();
    private static final SdkField<String> LOCAL_IPV6_NETWORK_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalIpv6NetworkCidr").getter(VpnConnectionOptions.getter(VpnConnectionOptions::localIpv6NetworkCidr)).setter(VpnConnectionOptions.setter(Builder::localIpv6NetworkCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalIpv6NetworkCidr").unmarshallLocationName("localIpv6NetworkCidr").build()}).build();
    private static final SdkField<String> REMOTE_IPV6_NETWORK_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RemoteIpv6NetworkCidr").getter(VpnConnectionOptions.getter(VpnConnectionOptions::remoteIpv6NetworkCidr)).setter(VpnConnectionOptions.setter(Builder::remoteIpv6NetworkCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteIpv6NetworkCidr").unmarshallLocationName("remoteIpv6NetworkCidr").build()}).build();
    private static final SdkField<String> OUTSIDE_IP_ADDRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutsideIpAddressType").getter(VpnConnectionOptions.getter(VpnConnectionOptions::outsideIpAddressType)).setter(VpnConnectionOptions.setter(Builder::outsideIpAddressType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutsideIpAddressType").unmarshallLocationName("outsideIpAddressType").build()}).build();
    private static final SdkField<String> TRANSPORT_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransportTransitGatewayAttachmentId").getter(VpnConnectionOptions.getter(VpnConnectionOptions::transportTransitGatewayAttachmentId)).setter(VpnConnectionOptions.setter(Builder::transportTransitGatewayAttachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransportTransitGatewayAttachmentId").unmarshallLocationName("transportTransitGatewayAttachmentId").build()}).build();
    private static final SdkField<String> TUNNEL_INSIDE_IP_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TunnelInsideIpVersion").getter(VpnConnectionOptions.getter(VpnConnectionOptions::tunnelInsideIpVersionAsString)).setter(VpnConnectionOptions.setter(Builder::tunnelInsideIpVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TunnelInsideIpVersion").unmarshallLocationName("tunnelInsideIpVersion").build()}).build();
    private static final SdkField<List<TunnelOption>> TUNNEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TunnelOptions").getter(VpnConnectionOptions.getter(VpnConnectionOptions::tunnelOptions)).setter(VpnConnectionOptions.setter(Builder::tunnelOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TunnelOptionSet").unmarshallLocationName("tunnelOptionSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TunnelOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_ACCELERATION_FIELD, STATIC_ROUTES_ONLY_FIELD, LOCAL_IPV4_NETWORK_CIDR_FIELD, REMOTE_IPV4_NETWORK_CIDR_FIELD, LOCAL_IPV6_NETWORK_CIDR_FIELD, REMOTE_IPV6_NETWORK_CIDR_FIELD, OUTSIDE_IP_ADDRESS_TYPE_FIELD, TRANSPORT_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, TUNNEL_INSIDE_IP_VERSION_FIELD, TUNNEL_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EnableAcceleration", ENABLE_ACCELERATION_FIELD);
            this.put("StaticRoutesOnly", STATIC_ROUTES_ONLY_FIELD);
            this.put("LocalIpv4NetworkCidr", LOCAL_IPV4_NETWORK_CIDR_FIELD);
            this.put("RemoteIpv4NetworkCidr", REMOTE_IPV4_NETWORK_CIDR_FIELD);
            this.put("LocalIpv6NetworkCidr", LOCAL_IPV6_NETWORK_CIDR_FIELD);
            this.put("RemoteIpv6NetworkCidr", REMOTE_IPV6_NETWORK_CIDR_FIELD);
            this.put("OutsideIpAddressType", OUTSIDE_IP_ADDRESS_TYPE_FIELD);
            this.put("TransportTransitGatewayAttachmentId", TRANSPORT_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD);
            this.put("TunnelInsideIpVersion", TUNNEL_INSIDE_IP_VERSION_FIELD);
            this.put("TunnelOptionSet", TUNNEL_OPTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Boolean enableAcceleration;
    private final Boolean staticRoutesOnly;
    private final String localIpv4NetworkCidr;
    private final String remoteIpv4NetworkCidr;
    private final String localIpv6NetworkCidr;
    private final String remoteIpv6NetworkCidr;
    private final String outsideIpAddressType;
    private final String transportTransitGatewayAttachmentId;
    private final String tunnelInsideIpVersion;
    private final List<TunnelOption> tunnelOptions;

    private VpnConnectionOptions(BuilderImpl builder) {
        this.enableAcceleration = builder.enableAcceleration;
        this.staticRoutesOnly = builder.staticRoutesOnly;
        this.localIpv4NetworkCidr = builder.localIpv4NetworkCidr;
        this.remoteIpv4NetworkCidr = builder.remoteIpv4NetworkCidr;
        this.localIpv6NetworkCidr = builder.localIpv6NetworkCidr;
        this.remoteIpv6NetworkCidr = builder.remoteIpv6NetworkCidr;
        this.outsideIpAddressType = builder.outsideIpAddressType;
        this.transportTransitGatewayAttachmentId = builder.transportTransitGatewayAttachmentId;
        this.tunnelInsideIpVersion = builder.tunnelInsideIpVersion;
        this.tunnelOptions = builder.tunnelOptions;
    }

    public final Boolean enableAcceleration() {
        return this.enableAcceleration;
    }

    public final Boolean staticRoutesOnly() {
        return this.staticRoutesOnly;
    }

    public final String localIpv4NetworkCidr() {
        return this.localIpv4NetworkCidr;
    }

    public final String remoteIpv4NetworkCidr() {
        return this.remoteIpv4NetworkCidr;
    }

    public final String localIpv6NetworkCidr() {
        return this.localIpv6NetworkCidr;
    }

    public final String remoteIpv6NetworkCidr() {
        return this.remoteIpv6NetworkCidr;
    }

    public final String outsideIpAddressType() {
        return this.outsideIpAddressType;
    }

    public final String transportTransitGatewayAttachmentId() {
        return this.transportTransitGatewayAttachmentId;
    }

    public final TunnelInsideIpVersion tunnelInsideIpVersion() {
        return TunnelInsideIpVersion.fromValue(this.tunnelInsideIpVersion);
    }

    public final String tunnelInsideIpVersionAsString() {
        return this.tunnelInsideIpVersion;
    }

    public final boolean hasTunnelOptions() {
        return this.tunnelOptions != null && !(this.tunnelOptions instanceof SdkAutoConstructList);
    }

    public final List<TunnelOption> tunnelOptions() {
        return this.tunnelOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enableAcceleration());
        hashCode = 31 * hashCode + Objects.hashCode(this.staticRoutesOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.localIpv4NetworkCidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteIpv4NetworkCidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.localIpv6NetworkCidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteIpv6NetworkCidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.outsideIpAddressType());
        hashCode = 31 * hashCode + Objects.hashCode(this.transportTransitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tunnelInsideIpVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTunnelOptions() ? this.tunnelOptions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpnConnectionOptions)) {
            return false;
        }
        VpnConnectionOptions other = (VpnConnectionOptions)obj;
        return Objects.equals(this.enableAcceleration(), other.enableAcceleration()) && Objects.equals(this.staticRoutesOnly(), other.staticRoutesOnly()) && Objects.equals(this.localIpv4NetworkCidr(), other.localIpv4NetworkCidr()) && Objects.equals(this.remoteIpv4NetworkCidr(), other.remoteIpv4NetworkCidr()) && Objects.equals(this.localIpv6NetworkCidr(), other.localIpv6NetworkCidr()) && Objects.equals(this.remoteIpv6NetworkCidr(), other.remoteIpv6NetworkCidr()) && Objects.equals(this.outsideIpAddressType(), other.outsideIpAddressType()) && Objects.equals(this.transportTransitGatewayAttachmentId(), other.transportTransitGatewayAttachmentId()) && Objects.equals(this.tunnelInsideIpVersionAsString(), other.tunnelInsideIpVersionAsString()) && this.hasTunnelOptions() == other.hasTunnelOptions() && Objects.equals(this.tunnelOptions(), other.tunnelOptions());
    }

    public final String toString() {
        return ToString.builder((String)"VpnConnectionOptions").add("EnableAcceleration", (Object)this.enableAcceleration()).add("StaticRoutesOnly", (Object)this.staticRoutesOnly()).add("LocalIpv4NetworkCidr", (Object)this.localIpv4NetworkCidr()).add("RemoteIpv4NetworkCidr", (Object)this.remoteIpv4NetworkCidr()).add("LocalIpv6NetworkCidr", (Object)this.localIpv6NetworkCidr()).add("RemoteIpv6NetworkCidr", (Object)this.remoteIpv6NetworkCidr()).add("OutsideIpAddressType", (Object)this.outsideIpAddressType()).add("TransportTransitGatewayAttachmentId", (Object)this.transportTransitGatewayAttachmentId()).add("TunnelInsideIpVersion", (Object)this.tunnelInsideIpVersionAsString()).add("TunnelOptions", this.hasTunnelOptions() ? this.tunnelOptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnableAcceleration": {
                return Optional.ofNullable(clazz.cast(this.enableAcceleration()));
            }
            case "StaticRoutesOnly": {
                return Optional.ofNullable(clazz.cast(this.staticRoutesOnly()));
            }
            case "LocalIpv4NetworkCidr": {
                return Optional.ofNullable(clazz.cast(this.localIpv4NetworkCidr()));
            }
            case "RemoteIpv4NetworkCidr": {
                return Optional.ofNullable(clazz.cast(this.remoteIpv4NetworkCidr()));
            }
            case "LocalIpv6NetworkCidr": {
                return Optional.ofNullable(clazz.cast(this.localIpv6NetworkCidr()));
            }
            case "RemoteIpv6NetworkCidr": {
                return Optional.ofNullable(clazz.cast(this.remoteIpv6NetworkCidr()));
            }
            case "OutsideIpAddressType": {
                return Optional.ofNullable(clazz.cast(this.outsideIpAddressType()));
            }
            case "TransportTransitGatewayAttachmentId": {
                return Optional.ofNullable(clazz.cast(this.transportTransitGatewayAttachmentId()));
            }
            case "TunnelInsideIpVersion": {
                return Optional.ofNullable(clazz.cast(this.tunnelInsideIpVersionAsString()));
            }
            case "TunnelOptions": {
                return Optional.ofNullable(clazz.cast(this.tunnelOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VpnConnectionOptions, T> g) {
        return obj -> g.apply((VpnConnectionOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enableAcceleration;
        private Boolean staticRoutesOnly;
        private String localIpv4NetworkCidr;
        private String remoteIpv4NetworkCidr;
        private String localIpv6NetworkCidr;
        private String remoteIpv6NetworkCidr;
        private String outsideIpAddressType;
        private String transportTransitGatewayAttachmentId;
        private String tunnelInsideIpVersion;
        private List<TunnelOption> tunnelOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VpnConnectionOptions model) {
            this.enableAcceleration(model.enableAcceleration);
            this.staticRoutesOnly(model.staticRoutesOnly);
            this.localIpv4NetworkCidr(model.localIpv4NetworkCidr);
            this.remoteIpv4NetworkCidr(model.remoteIpv4NetworkCidr);
            this.localIpv6NetworkCidr(model.localIpv6NetworkCidr);
            this.remoteIpv6NetworkCidr(model.remoteIpv6NetworkCidr);
            this.outsideIpAddressType(model.outsideIpAddressType);
            this.transportTransitGatewayAttachmentId(model.transportTransitGatewayAttachmentId);
            this.tunnelInsideIpVersion(model.tunnelInsideIpVersion);
            this.tunnelOptions(model.tunnelOptions);
        }

        public final Boolean getEnableAcceleration() {
            return this.enableAcceleration;
        }

        public final void setEnableAcceleration(Boolean enableAcceleration) {
            this.enableAcceleration = enableAcceleration;
        }

        @Override
        public final Builder enableAcceleration(Boolean enableAcceleration) {
            this.enableAcceleration = enableAcceleration;
            return this;
        }

        public final Boolean getStaticRoutesOnly() {
            return this.staticRoutesOnly;
        }

        public final void setStaticRoutesOnly(Boolean staticRoutesOnly) {
            this.staticRoutesOnly = staticRoutesOnly;
        }

        @Override
        public final Builder staticRoutesOnly(Boolean staticRoutesOnly) {
            this.staticRoutesOnly = staticRoutesOnly;
            return this;
        }

        public final String getLocalIpv4NetworkCidr() {
            return this.localIpv4NetworkCidr;
        }

        public final void setLocalIpv4NetworkCidr(String localIpv4NetworkCidr) {
            this.localIpv4NetworkCidr = localIpv4NetworkCidr;
        }

        @Override
        public final Builder localIpv4NetworkCidr(String localIpv4NetworkCidr) {
            this.localIpv4NetworkCidr = localIpv4NetworkCidr;
            return this;
        }

        public final String getRemoteIpv4NetworkCidr() {
            return this.remoteIpv4NetworkCidr;
        }

        public final void setRemoteIpv4NetworkCidr(String remoteIpv4NetworkCidr) {
            this.remoteIpv4NetworkCidr = remoteIpv4NetworkCidr;
        }

        @Override
        public final Builder remoteIpv4NetworkCidr(String remoteIpv4NetworkCidr) {
            this.remoteIpv4NetworkCidr = remoteIpv4NetworkCidr;
            return this;
        }

        public final String getLocalIpv6NetworkCidr() {
            return this.localIpv6NetworkCidr;
        }

        public final void setLocalIpv6NetworkCidr(String localIpv6NetworkCidr) {
            this.localIpv6NetworkCidr = localIpv6NetworkCidr;
        }

        @Override
        public final Builder localIpv6NetworkCidr(String localIpv6NetworkCidr) {
            this.localIpv6NetworkCidr = localIpv6NetworkCidr;
            return this;
        }

        public final String getRemoteIpv6NetworkCidr() {
            return this.remoteIpv6NetworkCidr;
        }

        public final void setRemoteIpv6NetworkCidr(String remoteIpv6NetworkCidr) {
            this.remoteIpv6NetworkCidr = remoteIpv6NetworkCidr;
        }

        @Override
        public final Builder remoteIpv6NetworkCidr(String remoteIpv6NetworkCidr) {
            this.remoteIpv6NetworkCidr = remoteIpv6NetworkCidr;
            return this;
        }

        public final String getOutsideIpAddressType() {
            return this.outsideIpAddressType;
        }

        public final void setOutsideIpAddressType(String outsideIpAddressType) {
            this.outsideIpAddressType = outsideIpAddressType;
        }

        @Override
        public final Builder outsideIpAddressType(String outsideIpAddressType) {
            this.outsideIpAddressType = outsideIpAddressType;
            return this;
        }

        public final String getTransportTransitGatewayAttachmentId() {
            return this.transportTransitGatewayAttachmentId;
        }

        public final void setTransportTransitGatewayAttachmentId(String transportTransitGatewayAttachmentId) {
            this.transportTransitGatewayAttachmentId = transportTransitGatewayAttachmentId;
        }

        @Override
        public final Builder transportTransitGatewayAttachmentId(String transportTransitGatewayAttachmentId) {
            this.transportTransitGatewayAttachmentId = transportTransitGatewayAttachmentId;
            return this;
        }

        public final String getTunnelInsideIpVersion() {
            return this.tunnelInsideIpVersion;
        }

        public final void setTunnelInsideIpVersion(String tunnelInsideIpVersion) {
            this.tunnelInsideIpVersion = tunnelInsideIpVersion;
        }

        @Override
        public final Builder tunnelInsideIpVersion(String tunnelInsideIpVersion) {
            this.tunnelInsideIpVersion = tunnelInsideIpVersion;
            return this;
        }

        @Override
        public final Builder tunnelInsideIpVersion(TunnelInsideIpVersion tunnelInsideIpVersion) {
            this.tunnelInsideIpVersion(tunnelInsideIpVersion == null ? null : tunnelInsideIpVersion.toString());
            return this;
        }

        public final List<TunnelOption.Builder> getTunnelOptions() {
            List<TunnelOption.Builder> result = TunnelOptionsListCopier.copyToBuilder(this.tunnelOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTunnelOptions(Collection<TunnelOption.BuilderImpl> tunnelOptions) {
            this.tunnelOptions = TunnelOptionsListCopier.copyFromBuilder(tunnelOptions);
        }

        @Override
        public final Builder tunnelOptions(Collection<TunnelOption> tunnelOptions) {
            this.tunnelOptions = TunnelOptionsListCopier.copy(tunnelOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tunnelOptions(TunnelOption ... tunnelOptions) {
            this.tunnelOptions(Arrays.asList(tunnelOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tunnelOptions(Consumer<TunnelOption.Builder> ... tunnelOptions) {
            this.tunnelOptions(Stream.of(tunnelOptions).map(c -> (TunnelOption)((TunnelOption.Builder)TunnelOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public VpnConnectionOptions build() {
            return new VpnConnectionOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpnConnectionOptions> {
        public Builder enableAcceleration(Boolean var1);

        public Builder staticRoutesOnly(Boolean var1);

        public Builder localIpv4NetworkCidr(String var1);

        public Builder remoteIpv4NetworkCidr(String var1);

        public Builder localIpv6NetworkCidr(String var1);

        public Builder remoteIpv6NetworkCidr(String var1);

        public Builder outsideIpAddressType(String var1);

        public Builder transportTransitGatewayAttachmentId(String var1);

        public Builder tunnelInsideIpVersion(String var1);

        public Builder tunnelInsideIpVersion(TunnelInsideIpVersion var1);

        public Builder tunnelOptions(Collection<TunnelOption> var1);

        public Builder tunnelOptions(TunnelOption ... var1);

        public Builder tunnelOptions(Consumer<TunnelOption.Builder> ... var1);
    }
}

