/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.IpPermission;
import software.amazon.awssdk.services.ec2.model.IpPermissionListCopier;
import software.amazon.awssdk.services.ec2.model.SecurityGroupRuleDescription;
import software.amazon.awssdk.services.ec2.model.SecurityGroupRuleDescriptionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSecurityGroupRuleDescriptionsEgressRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, UpdateSecurityGroupRuleDescriptionsEgressRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(UpdateSecurityGroupRuleDescriptionsEgressRequest.getter(UpdateSecurityGroupRuleDescriptionsEgressRequest::dryRun)).setter(UpdateSecurityGroupRuleDescriptionsEgressRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupId").getter(UpdateSecurityGroupRuleDescriptionsEgressRequest.getter(UpdateSecurityGroupRuleDescriptionsEgressRequest::groupId)).setter(UpdateSecurityGroupRuleDescriptionsEgressRequest.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").unmarshallLocationName("GroupId").build()}).build();
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupName").getter(UpdateSecurityGroupRuleDescriptionsEgressRequest.getter(UpdateSecurityGroupRuleDescriptionsEgressRequest::groupName)).setter(UpdateSecurityGroupRuleDescriptionsEgressRequest.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").unmarshallLocationName("GroupName").build()}).build();
    private static final SdkField<List<IpPermission>> IP_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpPermissions").getter(UpdateSecurityGroupRuleDescriptionsEgressRequest.getter(UpdateSecurityGroupRuleDescriptionsEgressRequest::ipPermissions)).setter(UpdateSecurityGroupRuleDescriptionsEgressRequest.setter(Builder::ipPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpPermissions").unmarshallLocationName("IpPermissions").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpPermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<SecurityGroupRuleDescription>> SECURITY_GROUP_RULE_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupRuleDescriptions").getter(UpdateSecurityGroupRuleDescriptionsEgressRequest.getter(UpdateSecurityGroupRuleDescriptionsEgressRequest::securityGroupRuleDescriptions)).setter(UpdateSecurityGroupRuleDescriptionsEgressRequest.setter(Builder::securityGroupRuleDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupRuleDescription").unmarshallLocationName("SecurityGroupRuleDescription").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecurityGroupRuleDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, GROUP_ID_FIELD, GROUP_NAME_FIELD, IP_PERMISSIONS_FIELD, SECURITY_GROUP_RULE_DESCRIPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DryRun", DRY_RUN_FIELD);
            this.put("GroupId", GROUP_ID_FIELD);
            this.put("GroupName", GROUP_NAME_FIELD);
            this.put("IpPermissions", IP_PERMISSIONS_FIELD);
            this.put("SecurityGroupRuleDescription", SECURITY_GROUP_RULE_DESCRIPTIONS_FIELD);
        }
    });
    private final Boolean dryRun;
    private final String groupId;
    private final String groupName;
    private final List<IpPermission> ipPermissions;
    private final List<SecurityGroupRuleDescription> securityGroupRuleDescriptions;

    private UpdateSecurityGroupRuleDescriptionsEgressRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.groupId = builder.groupId;
        this.groupName = builder.groupName;
        this.ipPermissions = builder.ipPermissions;
        this.securityGroupRuleDescriptions = builder.securityGroupRuleDescriptions;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String groupId() {
        return this.groupId;
    }

    public final String groupName() {
        return this.groupName;
    }

    public final boolean hasIpPermissions() {
        return this.ipPermissions != null && !(this.ipPermissions instanceof SdkAutoConstructList);
    }

    public final List<IpPermission> ipPermissions() {
        return this.ipPermissions;
    }

    public final boolean hasSecurityGroupRuleDescriptions() {
        return this.securityGroupRuleDescriptions != null && !(this.securityGroupRuleDescriptions instanceof SdkAutoConstructList);
    }

    public final List<SecurityGroupRuleDescription> securityGroupRuleDescriptions() {
        return this.securityGroupRuleDescriptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpPermissions() ? this.ipPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupRuleDescriptions() ? this.securityGroupRuleDescriptions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecurityGroupRuleDescriptionsEgressRequest)) {
            return false;
        }
        UpdateSecurityGroupRuleDescriptionsEgressRequest other = (UpdateSecurityGroupRuleDescriptionsEgressRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.groupName(), other.groupName()) && this.hasIpPermissions() == other.hasIpPermissions() && Objects.equals(this.ipPermissions(), other.ipPermissions()) && this.hasSecurityGroupRuleDescriptions() == other.hasSecurityGroupRuleDescriptions() && Objects.equals(this.securityGroupRuleDescriptions(), other.securityGroupRuleDescriptions());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSecurityGroupRuleDescriptionsEgressRequest").add("DryRun", (Object)this.dryRun()).add("GroupId", (Object)this.groupId()).add("GroupName", (Object)this.groupName()).add("IpPermissions", this.hasIpPermissions() ? this.ipPermissions() : null).add("SecurityGroupRuleDescriptions", this.hasSecurityGroupRuleDescriptions() ? this.securityGroupRuleDescriptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "IpPermissions": {
                return Optional.ofNullable(clazz.cast(this.ipPermissions()));
            }
            case "SecurityGroupRuleDescriptions": {
                return Optional.ofNullable(clazz.cast(this.securityGroupRuleDescriptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSecurityGroupRuleDescriptionsEgressRequest, T> g) {
        return obj -> g.apply((UpdateSecurityGroupRuleDescriptionsEgressRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String groupId;
        private String groupName;
        private List<IpPermission> ipPermissions = DefaultSdkAutoConstructList.getInstance();
        private List<SecurityGroupRuleDescription> securityGroupRuleDescriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSecurityGroupRuleDescriptionsEgressRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.groupId(model.groupId);
            this.groupName(model.groupName);
            this.ipPermissions(model.ipPermissions);
            this.securityGroupRuleDescriptions(model.securityGroupRuleDescriptions);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final List<IpPermission.Builder> getIpPermissions() {
            List<IpPermission.Builder> result = IpPermissionListCopier.copyToBuilder(this.ipPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpPermissions(Collection<IpPermission.BuilderImpl> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copyFromBuilder(ipPermissions);
        }

        @Override
        public final Builder ipPermissions(Collection<IpPermission> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copy(ipPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissions(IpPermission ... ipPermissions) {
            this.ipPermissions(Arrays.asList(ipPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissions(Consumer<IpPermission.Builder> ... ipPermissions) {
            this.ipPermissions(Stream.of(ipPermissions).map(c -> (IpPermission)((IpPermission.Builder)IpPermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SecurityGroupRuleDescription.Builder> getSecurityGroupRuleDescriptions() {
            List<SecurityGroupRuleDescription.Builder> result = SecurityGroupRuleDescriptionListCopier.copyToBuilder(this.securityGroupRuleDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityGroupRuleDescriptions(Collection<SecurityGroupRuleDescription.BuilderImpl> securityGroupRuleDescriptions) {
            this.securityGroupRuleDescriptions = SecurityGroupRuleDescriptionListCopier.copyFromBuilder(securityGroupRuleDescriptions);
        }

        @Override
        public final Builder securityGroupRuleDescriptions(Collection<SecurityGroupRuleDescription> securityGroupRuleDescriptions) {
            this.securityGroupRuleDescriptions = SecurityGroupRuleDescriptionListCopier.copy(securityGroupRuleDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupRuleDescriptions(SecurityGroupRuleDescription ... securityGroupRuleDescriptions) {
            this.securityGroupRuleDescriptions(Arrays.asList(securityGroupRuleDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupRuleDescriptions(Consumer<SecurityGroupRuleDescription.Builder> ... securityGroupRuleDescriptions) {
            this.securityGroupRuleDescriptions(Stream.of(securityGroupRuleDescriptions).map(c -> (SecurityGroupRuleDescription)((SecurityGroupRuleDescription.Builder)SecurityGroupRuleDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSecurityGroupRuleDescriptionsEgressRequest build() {
            return new UpdateSecurityGroupRuleDescriptionsEgressRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSecurityGroupRuleDescriptionsEgressRequest> {
        public Builder dryRun(Boolean var1);

        public Builder groupId(String var1);

        public Builder groupName(String var1);

        public Builder ipPermissions(Collection<IpPermission> var1);

        public Builder ipPermissions(IpPermission ... var1);

        public Builder ipPermissions(Consumer<IpPermission.Builder> ... var1);

        public Builder securityGroupRuleDescriptions(Collection<SecurityGroupRuleDescription> var1);

        public Builder securityGroupRuleDescriptions(SecurityGroupRuleDescription ... var1);

        public Builder securityGroupRuleDescriptions(Consumer<SecurityGroupRuleDescription.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

