/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.PeeringAttachmentStatus;
import software.amazon.awssdk.services.ec2.model.PeeringTgwInfo;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState;
import software.amazon.awssdk.services.ec2.model.TransitGatewayPeeringAttachmentOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransitGatewayPeeringAttachment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransitGatewayPeeringAttachment> {
    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayAttachmentId").getter(TransitGatewayPeeringAttachment.getter(TransitGatewayPeeringAttachment::transitGatewayAttachmentId)).setter(TransitGatewayPeeringAttachment.setter(Builder::transitGatewayAttachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentId").unmarshallLocationName("transitGatewayAttachmentId").build()}).build();
    private static final SdkField<String> ACCEPTER_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccepterTransitGatewayAttachmentId").getter(TransitGatewayPeeringAttachment.getter(TransitGatewayPeeringAttachment::accepterTransitGatewayAttachmentId)).setter(TransitGatewayPeeringAttachment.setter(Builder::accepterTransitGatewayAttachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccepterTransitGatewayAttachmentId").unmarshallLocationName("accepterTransitGatewayAttachmentId").build()}).build();
    private static final SdkField<PeeringTgwInfo> REQUESTER_TGW_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RequesterTgwInfo").getter(TransitGatewayPeeringAttachment.getter(TransitGatewayPeeringAttachment::requesterTgwInfo)).setter(TransitGatewayPeeringAttachment.setter(Builder::requesterTgwInfo)).constructor(PeeringTgwInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterTgwInfo").unmarshallLocationName("requesterTgwInfo").build()}).build();
    private static final SdkField<PeeringTgwInfo> ACCEPTER_TGW_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccepterTgwInfo").getter(TransitGatewayPeeringAttachment.getter(TransitGatewayPeeringAttachment::accepterTgwInfo)).setter(TransitGatewayPeeringAttachment.setter(Builder::accepterTgwInfo)).constructor(PeeringTgwInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccepterTgwInfo").unmarshallLocationName("accepterTgwInfo").build()}).build();
    private static final SdkField<TransitGatewayPeeringAttachmentOptions> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Options").getter(TransitGatewayPeeringAttachment.getter(TransitGatewayPeeringAttachment::options)).setter(TransitGatewayPeeringAttachment.setter(Builder::options)).constructor(TransitGatewayPeeringAttachmentOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").unmarshallLocationName("options").build()}).build();
    private static final SdkField<PeeringAttachmentStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(TransitGatewayPeeringAttachment.getter(TransitGatewayPeeringAttachment::status)).setter(TransitGatewayPeeringAttachment.setter(Builder::status)).constructor(PeeringAttachmentStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(TransitGatewayPeeringAttachment.getter(TransitGatewayPeeringAttachment::stateAsString)).setter(TransitGatewayPeeringAttachment.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(TransitGatewayPeeringAttachment.getter(TransitGatewayPeeringAttachment::creationTime)).setter(TransitGatewayPeeringAttachment.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").unmarshallLocationName("creationTime").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(TransitGatewayPeeringAttachment.getter(TransitGatewayPeeringAttachment::tags)).setter(TransitGatewayPeeringAttachment.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, ACCEPTER_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, REQUESTER_TGW_INFO_FIELD, ACCEPTER_TGW_INFO_FIELD, OPTIONS_FIELD, STATUS_FIELD, STATE_FIELD, CREATION_TIME_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TransitGatewayAttachmentId", TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD);
            this.put("AccepterTransitGatewayAttachmentId", ACCEPTER_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD);
            this.put("RequesterTgwInfo", REQUESTER_TGW_INFO_FIELD);
            this.put("AccepterTgwInfo", ACCEPTER_TGW_INFO_FIELD);
            this.put("Options", OPTIONS_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("State", STATE_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("TagSet", TAGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String transitGatewayAttachmentId;
    private final String accepterTransitGatewayAttachmentId;
    private final PeeringTgwInfo requesterTgwInfo;
    private final PeeringTgwInfo accepterTgwInfo;
    private final TransitGatewayPeeringAttachmentOptions options;
    private final PeeringAttachmentStatus status;
    private final String state;
    private final Instant creationTime;
    private final List<Tag> tags;

    private TransitGatewayPeeringAttachment(BuilderImpl builder) {
        this.transitGatewayAttachmentId = builder.transitGatewayAttachmentId;
        this.accepterTransitGatewayAttachmentId = builder.accepterTransitGatewayAttachmentId;
        this.requesterTgwInfo = builder.requesterTgwInfo;
        this.accepterTgwInfo = builder.accepterTgwInfo;
        this.options = builder.options;
        this.status = builder.status;
        this.state = builder.state;
        this.creationTime = builder.creationTime;
        this.tags = builder.tags;
    }

    public final String transitGatewayAttachmentId() {
        return this.transitGatewayAttachmentId;
    }

    public final String accepterTransitGatewayAttachmentId() {
        return this.accepterTransitGatewayAttachmentId;
    }

    public final PeeringTgwInfo requesterTgwInfo() {
        return this.requesterTgwInfo;
    }

    public final PeeringTgwInfo accepterTgwInfo() {
        return this.accepterTgwInfo;
    }

    public final TransitGatewayPeeringAttachmentOptions options() {
        return this.options;
    }

    public final PeeringAttachmentStatus status() {
        return this.status;
    }

    public final TransitGatewayAttachmentState state() {
        return TransitGatewayAttachmentState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accepterTransitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterTgwInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.accepterTgwInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayPeeringAttachment)) {
            return false;
        }
        TransitGatewayPeeringAttachment other = (TransitGatewayPeeringAttachment)obj;
        return Objects.equals(this.transitGatewayAttachmentId(), other.transitGatewayAttachmentId()) && Objects.equals(this.accepterTransitGatewayAttachmentId(), other.accepterTransitGatewayAttachmentId()) && Objects.equals(this.requesterTgwInfo(), other.requesterTgwInfo()) && Objects.equals(this.accepterTgwInfo(), other.accepterTgwInfo()) && Objects.equals(this.options(), other.options()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"TransitGatewayPeeringAttachment").add("TransitGatewayAttachmentId", (Object)this.transitGatewayAttachmentId()).add("AccepterTransitGatewayAttachmentId", (Object)this.accepterTransitGatewayAttachmentId()).add("RequesterTgwInfo", (Object)this.requesterTgwInfo()).add("AccepterTgwInfo", (Object)this.accepterTgwInfo()).add("Options", (Object)this.options()).add("Status", (Object)this.status()).add("State", (Object)this.stateAsString()).add("CreationTime", (Object)this.creationTime()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayAttachmentId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayAttachmentId()));
            }
            case "AccepterTransitGatewayAttachmentId": {
                return Optional.ofNullable(clazz.cast(this.accepterTransitGatewayAttachmentId()));
            }
            case "RequesterTgwInfo": {
                return Optional.ofNullable(clazz.cast(this.requesterTgwInfo()));
            }
            case "AccepterTgwInfo": {
                return Optional.ofNullable(clazz.cast(this.accepterTgwInfo()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayPeeringAttachment, T> g) {
        return obj -> g.apply((TransitGatewayPeeringAttachment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transitGatewayAttachmentId;
        private String accepterTransitGatewayAttachmentId;
        private PeeringTgwInfo requesterTgwInfo;
        private PeeringTgwInfo accepterTgwInfo;
        private TransitGatewayPeeringAttachmentOptions options;
        private PeeringAttachmentStatus status;
        private String state;
        private Instant creationTime;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayPeeringAttachment model) {
            this.transitGatewayAttachmentId(model.transitGatewayAttachmentId);
            this.accepterTransitGatewayAttachmentId(model.accepterTransitGatewayAttachmentId);
            this.requesterTgwInfo(model.requesterTgwInfo);
            this.accepterTgwInfo(model.accepterTgwInfo);
            this.options(model.options);
            this.status(model.status);
            this.state(model.state);
            this.creationTime(model.creationTime);
            this.tags(model.tags);
        }

        public final String getTransitGatewayAttachmentId() {
            return this.transitGatewayAttachmentId;
        }

        public final void setTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
        }

        @Override
        public final Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        public final String getAccepterTransitGatewayAttachmentId() {
            return this.accepterTransitGatewayAttachmentId;
        }

        public final void setAccepterTransitGatewayAttachmentId(String accepterTransitGatewayAttachmentId) {
            this.accepterTransitGatewayAttachmentId = accepterTransitGatewayAttachmentId;
        }

        @Override
        public final Builder accepterTransitGatewayAttachmentId(String accepterTransitGatewayAttachmentId) {
            this.accepterTransitGatewayAttachmentId = accepterTransitGatewayAttachmentId;
            return this;
        }

        public final PeeringTgwInfo.Builder getRequesterTgwInfo() {
            return this.requesterTgwInfo != null ? this.requesterTgwInfo.toBuilder() : null;
        }

        public final void setRequesterTgwInfo(PeeringTgwInfo.BuilderImpl requesterTgwInfo) {
            this.requesterTgwInfo = requesterTgwInfo != null ? requesterTgwInfo.build() : null;
        }

        @Override
        public final Builder requesterTgwInfo(PeeringTgwInfo requesterTgwInfo) {
            this.requesterTgwInfo = requesterTgwInfo;
            return this;
        }

        public final PeeringTgwInfo.Builder getAccepterTgwInfo() {
            return this.accepterTgwInfo != null ? this.accepterTgwInfo.toBuilder() : null;
        }

        public final void setAccepterTgwInfo(PeeringTgwInfo.BuilderImpl accepterTgwInfo) {
            this.accepterTgwInfo = accepterTgwInfo != null ? accepterTgwInfo.build() : null;
        }

        @Override
        public final Builder accepterTgwInfo(PeeringTgwInfo accepterTgwInfo) {
            this.accepterTgwInfo = accepterTgwInfo;
            return this;
        }

        public final TransitGatewayPeeringAttachmentOptions.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        public final void setOptions(TransitGatewayPeeringAttachmentOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public final Builder options(TransitGatewayPeeringAttachmentOptions options) {
            this.options = options;
            return this;
        }

        public final PeeringAttachmentStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(PeeringAttachmentStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(PeeringAttachmentStatus status) {
            this.status = status;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TransitGatewayAttachmentState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TransitGatewayPeeringAttachment build() {
            return new TransitGatewayPeeringAttachment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransitGatewayPeeringAttachment> {
        public Builder transitGatewayAttachmentId(String var1);

        public Builder accepterTransitGatewayAttachmentId(String var1);

        public Builder requesterTgwInfo(PeeringTgwInfo var1);

        default public Builder requesterTgwInfo(Consumer<PeeringTgwInfo.Builder> requesterTgwInfo) {
            return this.requesterTgwInfo((PeeringTgwInfo)((PeeringTgwInfo.Builder)PeeringTgwInfo.builder().applyMutation(requesterTgwInfo)).build());
        }

        public Builder accepterTgwInfo(PeeringTgwInfo var1);

        default public Builder accepterTgwInfo(Consumer<PeeringTgwInfo.Builder> accepterTgwInfo) {
            return this.accepterTgwInfo((PeeringTgwInfo)((PeeringTgwInfo.Builder)PeeringTgwInfo.builder().applyMutation(accepterTgwInfo)).build());
        }

        public Builder options(TransitGatewayPeeringAttachmentOptions var1);

        default public Builder options(Consumer<TransitGatewayPeeringAttachmentOptions.Builder> options) {
            return this.options((TransitGatewayPeeringAttachmentOptions)((TransitGatewayPeeringAttachmentOptions.Builder)TransitGatewayPeeringAttachmentOptions.builder().applyMutation(options)).build());
        }

        public Builder status(PeeringAttachmentStatus var1);

        default public Builder status(Consumer<PeeringAttachmentStatus.Builder> status) {
            return this.status((PeeringAttachmentStatus)((PeeringAttachmentStatus.Builder)PeeringAttachmentStatus.builder().applyMutation(status)).build());
        }

        public Builder state(String var1);

        public Builder state(TransitGatewayAttachmentState var1);

        public Builder creationTime(Instant var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

