/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ImageRecycleBinInfo;
import software.amazon.awssdk.services.ec2.model.ImageRecycleBinInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListImagesInRecycleBinResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, ListImagesInRecycleBinResponse> {
    private static final SdkField<List<ImageRecycleBinInfo>> IMAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Images").getter(ListImagesInRecycleBinResponse.getter(ListImagesInRecycleBinResponse::images)).setter(ListImagesInRecycleBinResponse.setter(Builder::images)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageSet").unmarshallLocationName("imageSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImageRecycleBinInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListImagesInRecycleBinResponse.getter(ListImagesInRecycleBinResponse::nextToken)).setter(ListImagesInRecycleBinResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ImageSet", IMAGES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ImageRecycleBinInfo> images;
    private final String nextToken;

    private ListImagesInRecycleBinResponse(BuilderImpl builder) {
        super(builder);
        this.images = builder.images;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasImages() {
        return this.images != null && !(this.images instanceof SdkAutoConstructList);
    }

    public final List<ImageRecycleBinInfo> images() {
        return this.images;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImages() ? this.images() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImagesInRecycleBinResponse)) {
            return false;
        }
        ListImagesInRecycleBinResponse other = (ListImagesInRecycleBinResponse)((Object)obj);
        return this.hasImages() == other.hasImages() && Objects.equals(this.images(), other.images()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListImagesInRecycleBinResponse").add("Images", this.hasImages() ? this.images() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Images": {
                return Optional.ofNullable(clazz.cast(this.images()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListImagesInRecycleBinResponse, T> g) {
        return obj -> g.apply((ListImagesInRecycleBinResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<ImageRecycleBinInfo> images = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImagesInRecycleBinResponse model) {
            super(model);
            this.images(model.images);
            this.nextToken(model.nextToken);
        }

        public final List<ImageRecycleBinInfo.Builder> getImages() {
            List<ImageRecycleBinInfo.Builder> result = ImageRecycleBinInfoListCopier.copyToBuilder(this.images);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImages(Collection<ImageRecycleBinInfo.BuilderImpl> images) {
            this.images = ImageRecycleBinInfoListCopier.copyFromBuilder(images);
        }

        @Override
        public final Builder images(Collection<ImageRecycleBinInfo> images) {
            this.images = ImageRecycleBinInfoListCopier.copy(images);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(ImageRecycleBinInfo ... images) {
            this.images(Arrays.asList(images));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(Consumer<ImageRecycleBinInfo.Builder> ... images) {
            this.images(Stream.of(images).map(c -> (ImageRecycleBinInfo)((ImageRecycleBinInfo.Builder)ImageRecycleBinInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListImagesInRecycleBinResponse build() {
            return new ListImagesInRecycleBinResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListImagesInRecycleBinResponse> {
        public Builder images(Collection<ImageRecycleBinInfo> var1);

        public Builder images(ImageRecycleBinInfo ... var1);

        public Builder images(Consumer<ImageRecycleBinInfo.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

