/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateSpotMarketOptionsRequest;
import software.amazon.awssdk.services.ec2.model.MarketType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchTemplateInstanceMarketOptionsRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchTemplateInstanceMarketOptionsRequest> {
    private static final SdkField<String> MARKET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MarketType").getter(LaunchTemplateInstanceMarketOptionsRequest.getter(LaunchTemplateInstanceMarketOptionsRequest::marketTypeAsString)).setter(LaunchTemplateInstanceMarketOptionsRequest.setter(Builder::marketType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MarketType").unmarshallLocationName("MarketType").build()}).build();
    private static final SdkField<LaunchTemplateSpotMarketOptionsRequest> SPOT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SpotOptions").getter(LaunchTemplateInstanceMarketOptionsRequest.getter(LaunchTemplateInstanceMarketOptionsRequest::spotOptions)).setter(LaunchTemplateInstanceMarketOptionsRequest.setter(Builder::spotOptions)).constructor(LaunchTemplateSpotMarketOptionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotOptions").unmarshallLocationName("SpotOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKET_TYPE_FIELD, SPOT_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MarketType", MARKET_TYPE_FIELD);
            this.put("SpotOptions", SPOT_OPTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String marketType;
    private final LaunchTemplateSpotMarketOptionsRequest spotOptions;

    private LaunchTemplateInstanceMarketOptionsRequest(BuilderImpl builder) {
        this.marketType = builder.marketType;
        this.spotOptions = builder.spotOptions;
    }

    public final MarketType marketType() {
        return MarketType.fromValue(this.marketType);
    }

    public final String marketTypeAsString() {
        return this.marketType;
    }

    public final LaunchTemplateSpotMarketOptionsRequest spotOptions() {
        return this.spotOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marketTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateInstanceMarketOptionsRequest)) {
            return false;
        }
        LaunchTemplateInstanceMarketOptionsRequest other = (LaunchTemplateInstanceMarketOptionsRequest)obj;
        return Objects.equals(this.marketTypeAsString(), other.marketTypeAsString()) && Objects.equals(this.spotOptions(), other.spotOptions());
    }

    public final String toString() {
        return ToString.builder((String)"LaunchTemplateInstanceMarketOptionsRequest").add("MarketType", (Object)this.marketTypeAsString()).add("SpotOptions", (Object)this.spotOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MarketType": {
                return Optional.ofNullable(clazz.cast(this.marketTypeAsString()));
            }
            case "SpotOptions": {
                return Optional.ofNullable(clazz.cast(this.spotOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplateInstanceMarketOptionsRequest, T> g) {
        return obj -> g.apply((LaunchTemplateInstanceMarketOptionsRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String marketType;
        private LaunchTemplateSpotMarketOptionsRequest spotOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateInstanceMarketOptionsRequest model) {
            this.marketType(model.marketType);
            this.spotOptions(model.spotOptions);
        }

        public final String getMarketType() {
            return this.marketType;
        }

        public final void setMarketType(String marketType) {
            this.marketType = marketType;
        }

        @Override
        public final Builder marketType(String marketType) {
            this.marketType = marketType;
            return this;
        }

        @Override
        public final Builder marketType(MarketType marketType) {
            this.marketType(marketType == null ? null : marketType.toString());
            return this;
        }

        public final LaunchTemplateSpotMarketOptionsRequest.Builder getSpotOptions() {
            return this.spotOptions != null ? this.spotOptions.toBuilder() : null;
        }

        public final void setSpotOptions(LaunchTemplateSpotMarketOptionsRequest.BuilderImpl spotOptions) {
            this.spotOptions = spotOptions != null ? spotOptions.build() : null;
        }

        @Override
        public final Builder spotOptions(LaunchTemplateSpotMarketOptionsRequest spotOptions) {
            this.spotOptions = spotOptions;
            return this;
        }

        public LaunchTemplateInstanceMarketOptionsRequest build() {
            return new LaunchTemplateInstanceMarketOptionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchTemplateInstanceMarketOptionsRequest> {
        public Builder marketType(String var1);

        public Builder marketType(MarketType var1);

        public Builder spotOptions(LaunchTemplateSpotMarketOptionsRequest var1);

        default public Builder spotOptions(Consumer<LaunchTemplateSpotMarketOptionsRequest.Builder> spotOptions) {
            return this.spotOptions((LaunchTemplateSpotMarketOptionsRequest)((LaunchTemplateSpotMarketOptionsRequest.Builder)LaunchTemplateSpotMarketOptionsRequest.builder().applyMutation(spotOptions)).build());
        }
    }
}

