/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.DiskImageDetail;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.VolumeDetail;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportVolumeRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ImportVolumeRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ImportVolumeRequest.getter(ImportVolumeRequest::dryRun)).setter(ImportVolumeRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("dryRun").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(ImportVolumeRequest.getter(ImportVolumeRequest::availabilityZone)).setter(ImportVolumeRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<DiskImageDetail> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Image").getter(ImportVolumeRequest.getter(ImportVolumeRequest::image)).setter(ImportVolumeRequest.setter(Builder::image)).constructor(DiskImageDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image").unmarshallLocationName("image").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ImportVolumeRequest.getter(ImportVolumeRequest::description)).setter(ImportVolumeRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<VolumeDetail> VOLUME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Volume").getter(ImportVolumeRequest.getter(ImportVolumeRequest::volume)).setter(ImportVolumeRequest.setter(Builder::volume)).constructor(VolumeDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Volume").unmarshallLocationName("volume").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, AVAILABILITY_ZONE_FIELD, IMAGE_FIELD, DESCRIPTION_FIELD, VOLUME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DryRun", DRY_RUN_FIELD);
            this.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
            this.put("Image", IMAGE_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Volume", VOLUME_FIELD);
        }
    });
    private final Boolean dryRun;
    private final String availabilityZone;
    private final DiskImageDetail image;
    private final String description;
    private final VolumeDetail volume;

    private ImportVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.availabilityZone = builder.availabilityZone;
        this.image = builder.image;
        this.description = builder.description;
        this.volume = builder.volume;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final DiskImageDetail image() {
        return this.image;
    }

    public final String description() {
        return this.description;
    }

    public final VolumeDetail volume() {
        return this.volume;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.volume());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportVolumeRequest)) {
            return false;
        }
        ImportVolumeRequest other = (ImportVolumeRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.volume(), other.volume());
    }

    public final String toString() {
        return ToString.builder((String)"ImportVolumeRequest").add("DryRun", (Object)this.dryRun()).add("AvailabilityZone", (Object)this.availabilityZone()).add("Image", (Object)this.image()).add("Description", (Object)this.description()).add("Volume", (Object)this.volume()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "Image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Volume": {
                return Optional.ofNullable(clazz.cast(this.volume()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ImportVolumeRequest, T> g) {
        return obj -> g.apply((ImportVolumeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String availabilityZone;
        private DiskImageDetail image;
        private String description;
        private VolumeDetail volume;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportVolumeRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.availabilityZone(model.availabilityZone);
            this.image(model.image);
            this.description(model.description);
            this.volume(model.volume);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final DiskImageDetail.Builder getImage() {
            return this.image != null ? this.image.toBuilder() : null;
        }

        public final void setImage(DiskImageDetail.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        @Override
        public final Builder image(DiskImageDetail image) {
            this.image = image;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final VolumeDetail.Builder getVolume() {
            return this.volume != null ? this.volume.toBuilder() : null;
        }

        public final void setVolume(VolumeDetail.BuilderImpl volume) {
            this.volume = volume != null ? volume.build() : null;
        }

        @Override
        public final Builder volume(VolumeDetail volume) {
            this.volume = volume;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportVolumeRequest build() {
            return new ImportVolumeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportVolumeRequest> {
        public Builder dryRun(Boolean var1);

        public Builder availabilityZone(String var1);

        public Builder image(DiskImageDetail var1);

        default public Builder image(Consumer<DiskImageDetail.Builder> image) {
            return this.image((DiskImageDetail)((DiskImageDetail.Builder)DiskImageDetail.builder().applyMutation(image)).build());
        }

        public Builder description(String var1);

        public Builder volume(VolumeDetail var1);

        default public Builder volume(Consumer<VolumeDetail.Builder> volume) {
            return this.volume((VolumeDetail)((VolumeDetail.Builder)VolumeDetail.builder().applyMutation(volume)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

