/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRule;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRuleSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTrafficMirrorFilterRulesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeTrafficMirrorFilterRulesResponse> {
    private static final SdkField<List<TrafficMirrorFilterRule>> TRAFFIC_MIRROR_FILTER_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TrafficMirrorFilterRules").getter(DescribeTrafficMirrorFilterRulesResponse.getter(DescribeTrafficMirrorFilterRulesResponse::trafficMirrorFilterRules)).setter(DescribeTrafficMirrorFilterRulesResponse.setter(Builder::trafficMirrorFilterRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorFilterRuleSet").unmarshallLocationName("trafficMirrorFilterRuleSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrafficMirrorFilterRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeTrafficMirrorFilterRulesResponse.getter(DescribeTrafficMirrorFilterRulesResponse::nextToken)).setter(DescribeTrafficMirrorFilterRulesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_MIRROR_FILTER_RULES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TrafficMirrorFilterRuleSet", TRAFFIC_MIRROR_FILTER_RULES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<TrafficMirrorFilterRule> trafficMirrorFilterRules;
    private final String nextToken;

    private DescribeTrafficMirrorFilterRulesResponse(BuilderImpl builder) {
        super(builder);
        this.trafficMirrorFilterRules = builder.trafficMirrorFilterRules;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTrafficMirrorFilterRules() {
        return this.trafficMirrorFilterRules != null && !(this.trafficMirrorFilterRules instanceof SdkAutoConstructList);
    }

    public final List<TrafficMirrorFilterRule> trafficMirrorFilterRules() {
        return this.trafficMirrorFilterRules;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrafficMirrorFilterRules() ? this.trafficMirrorFilterRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrafficMirrorFilterRulesResponse)) {
            return false;
        }
        DescribeTrafficMirrorFilterRulesResponse other = (DescribeTrafficMirrorFilterRulesResponse)((Object)obj);
        return this.hasTrafficMirrorFilterRules() == other.hasTrafficMirrorFilterRules() && Objects.equals(this.trafficMirrorFilterRules(), other.trafficMirrorFilterRules()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTrafficMirrorFilterRulesResponse").add("TrafficMirrorFilterRules", this.hasTrafficMirrorFilterRules() ? this.trafficMirrorFilterRules() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrafficMirrorFilterRules": {
                return Optional.ofNullable(clazz.cast(this.trafficMirrorFilterRules()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrafficMirrorFilterRulesResponse, T> g) {
        return obj -> g.apply((DescribeTrafficMirrorFilterRulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<TrafficMirrorFilterRule> trafficMirrorFilterRules = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrafficMirrorFilterRulesResponse model) {
            super(model);
            this.trafficMirrorFilterRules(model.trafficMirrorFilterRules);
            this.nextToken(model.nextToken);
        }

        public final List<TrafficMirrorFilterRule.Builder> getTrafficMirrorFilterRules() {
            List<TrafficMirrorFilterRule.Builder> result = TrafficMirrorFilterRuleSetCopier.copyToBuilder(this.trafficMirrorFilterRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrafficMirrorFilterRules(Collection<TrafficMirrorFilterRule.BuilderImpl> trafficMirrorFilterRules) {
            this.trafficMirrorFilterRules = TrafficMirrorFilterRuleSetCopier.copyFromBuilder(trafficMirrorFilterRules);
        }

        @Override
        public final Builder trafficMirrorFilterRules(Collection<TrafficMirrorFilterRule> trafficMirrorFilterRules) {
            this.trafficMirrorFilterRules = TrafficMirrorFilterRuleSetCopier.copy(trafficMirrorFilterRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficMirrorFilterRules(TrafficMirrorFilterRule ... trafficMirrorFilterRules) {
            this.trafficMirrorFilterRules(Arrays.asList(trafficMirrorFilterRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficMirrorFilterRules(Consumer<TrafficMirrorFilterRule.Builder> ... trafficMirrorFilterRules) {
            this.trafficMirrorFilterRules(Stream.of(trafficMirrorFilterRules).map(c -> (TrafficMirrorFilterRule)((TrafficMirrorFilterRule.Builder)TrafficMirrorFilterRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeTrafficMirrorFilterRulesResponse build() {
            return new DescribeTrafficMirrorFilterRulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTrafficMirrorFilterRulesResponse> {
        public Builder trafficMirrorFilterRules(Collection<TrafficMirrorFilterRule> var1);

        public Builder trafficMirrorFilterRules(TrafficMirrorFilterRule ... var1);

        public Builder trafficMirrorFilterRules(Consumer<TrafficMirrorFilterRule.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

