/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CoipPool
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CoipPool> {
    private static final SdkField<String> POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolId").getter(CoipPool.getter(CoipPool::poolId)).setter(CoipPool.setter(Builder::poolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").unmarshallLocationName("poolId").build()}).build();
    private static final SdkField<List<String>> POOL_CIDRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PoolCidrs").getter(CoipPool.getter(CoipPool::poolCidrs)).setter(CoipPool.setter(Builder::poolCidrs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolCidrSet").unmarshallLocationName("poolCidrSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalGatewayRouteTableId").getter(CoipPool.getter(CoipPool::localGatewayRouteTableId)).setter(CoipPool.setter(Builder::localGatewayRouteTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayRouteTableId").unmarshallLocationName("localGatewayRouteTableId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CoipPool.getter(CoipPool::tags)).setter(CoipPool.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> POOL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolArn").getter(CoipPool.getter(CoipPool::poolArn)).setter(CoipPool.setter(Builder::poolArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolArn").unmarshallLocationName("poolArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_ID_FIELD, POOL_CIDRS_FIELD, LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD, TAGS_FIELD, POOL_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PoolId", POOL_ID_FIELD);
            this.put("PoolCidrSet", POOL_CIDRS_FIELD);
            this.put("LocalGatewayRouteTableId", LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD);
            this.put("TagSet", TAGS_FIELD);
            this.put("PoolArn", POOL_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String poolId;
    private final List<String> poolCidrs;
    private final String localGatewayRouteTableId;
    private final List<Tag> tags;
    private final String poolArn;

    private CoipPool(BuilderImpl builder) {
        this.poolId = builder.poolId;
        this.poolCidrs = builder.poolCidrs;
        this.localGatewayRouteTableId = builder.localGatewayRouteTableId;
        this.tags = builder.tags;
        this.poolArn = builder.poolArn;
    }

    public final String poolId() {
        return this.poolId;
    }

    public final boolean hasPoolCidrs() {
        return this.poolCidrs != null && !(this.poolCidrs instanceof SdkAutoConstructList);
    }

    public final List<String> poolCidrs() {
        return this.poolCidrs;
    }

    public final String localGatewayRouteTableId() {
        return this.localGatewayRouteTableId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String poolArn() {
        return this.poolArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.poolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPoolCidrs() ? this.poolCidrs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.localGatewayRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.poolArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoipPool)) {
            return false;
        }
        CoipPool other = (CoipPool)obj;
        return Objects.equals(this.poolId(), other.poolId()) && this.hasPoolCidrs() == other.hasPoolCidrs() && Objects.equals(this.poolCidrs(), other.poolCidrs()) && Objects.equals(this.localGatewayRouteTableId(), other.localGatewayRouteTableId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.poolArn(), other.poolArn());
    }

    public final String toString() {
        return ToString.builder((String)"CoipPool").add("PoolId", (Object)this.poolId()).add("PoolCidrs", this.hasPoolCidrs() ? this.poolCidrs() : null).add("LocalGatewayRouteTableId", (Object)this.localGatewayRouteTableId()).add("Tags", this.hasTags() ? this.tags() : null).add("PoolArn", (Object)this.poolArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PoolId": {
                return Optional.ofNullable(clazz.cast(this.poolId()));
            }
            case "PoolCidrs": {
                return Optional.ofNullable(clazz.cast(this.poolCidrs()));
            }
            case "LocalGatewayRouteTableId": {
                return Optional.ofNullable(clazz.cast(this.localGatewayRouteTableId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "PoolArn": {
                return Optional.ofNullable(clazz.cast(this.poolArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CoipPool, T> g) {
        return obj -> g.apply((CoipPool)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String poolId;
        private List<String> poolCidrs = DefaultSdkAutoConstructList.getInstance();
        private String localGatewayRouteTableId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String poolArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CoipPool model) {
            this.poolId(model.poolId);
            this.poolCidrs(model.poolCidrs);
            this.localGatewayRouteTableId(model.localGatewayRouteTableId);
            this.tags(model.tags);
            this.poolArn(model.poolArn);
        }

        public final String getPoolId() {
            return this.poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final Collection<String> getPoolCidrs() {
            if (this.poolCidrs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.poolCidrs;
        }

        public final void setPoolCidrs(Collection<String> poolCidrs) {
            this.poolCidrs = ValueStringListCopier.copy(poolCidrs);
        }

        @Override
        public final Builder poolCidrs(Collection<String> poolCidrs) {
            this.poolCidrs = ValueStringListCopier.copy(poolCidrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder poolCidrs(String ... poolCidrs) {
            this.poolCidrs(Arrays.asList(poolCidrs));
            return this;
        }

        public final String getLocalGatewayRouteTableId() {
            return this.localGatewayRouteTableId;
        }

        public final void setLocalGatewayRouteTableId(String localGatewayRouteTableId) {
            this.localGatewayRouteTableId = localGatewayRouteTableId;
        }

        @Override
        public final Builder localGatewayRouteTableId(String localGatewayRouteTableId) {
            this.localGatewayRouteTableId = localGatewayRouteTableId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPoolArn() {
            return this.poolArn;
        }

        public final void setPoolArn(String poolArn) {
            this.poolArn = poolArn;
        }

        @Override
        public final Builder poolArn(String poolArn) {
            this.poolArn = poolArn;
            return this;
        }

        public CoipPool build() {
            return new CoipPool(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CoipPool> {
        public Builder poolId(String var1);

        public Builder poolCidrs(Collection<String> var1);

        public Builder poolCidrs(String ... var1);

        public Builder localGatewayRouteTableId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder poolArn(String var1);
    }
}

