/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.CidrIpsCopier;
import software.amazon.awssdk.services.directory.model.DirectoryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemoveIpRoutesRequest
extends DirectoryRequest
implements ToCopyableBuilder<Builder, RemoveIpRoutesRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(RemoveIpRoutesRequest.getter(RemoveIpRoutesRequest::directoryId)).setter(RemoveIpRoutesRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<List<String>> CIDR_IPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CidrIps").getter(RemoveIpRoutesRequest.getter(RemoveIpRoutesRequest::cidrIps)).setter(RemoveIpRoutesRequest.setter(Builder::cidrIps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrIps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, CIDR_IPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DirectoryId", DIRECTORY_ID_FIELD);
            this.put("CidrIps", CIDR_IPS_FIELD);
        }
    });
    private final String directoryId;
    private final List<String> cidrIps;

    private RemoveIpRoutesRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.cidrIps = builder.cidrIps;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final boolean hasCidrIps() {
        return this.cidrIps != null && !(this.cidrIps instanceof SdkAutoConstructList);
    }

    public final List<String> cidrIps() {
        return this.cidrIps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCidrIps() ? this.cidrIps() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveIpRoutesRequest)) {
            return false;
        }
        RemoveIpRoutesRequest other = (RemoveIpRoutesRequest)((Object)obj);
        return Objects.equals(this.directoryId(), other.directoryId()) && this.hasCidrIps() == other.hasCidrIps() && Objects.equals(this.cidrIps(), other.cidrIps());
    }

    public final String toString() {
        return ToString.builder((String)"RemoveIpRoutesRequest").add("DirectoryId", (Object)this.directoryId()).add("CidrIps", this.hasCidrIps() ? this.cidrIps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "CidrIps": {
                return Optional.ofNullable(clazz.cast(this.cidrIps()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RemoveIpRoutesRequest, T> g) {
        return obj -> g.apply((RemoveIpRoutesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryId;
        private List<String> cidrIps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveIpRoutesRequest model) {
            super(model);
            this.directoryId(model.directoryId);
            this.cidrIps(model.cidrIps);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final Collection<String> getCidrIps() {
            if (this.cidrIps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cidrIps;
        }

        public final void setCidrIps(Collection<String> cidrIps) {
            this.cidrIps = CidrIpsCopier.copy(cidrIps);
        }

        @Override
        public final Builder cidrIps(Collection<String> cidrIps) {
            this.cidrIps = CidrIpsCopier.copy(cidrIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrIps(String ... cidrIps) {
            this.cidrIps(Arrays.asList(cidrIps));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveIpRoutesRequest build() {
            return new RemoveIpRoutesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RemoveIpRoutesRequest> {
        public Builder directoryId(String var1);

        public Builder cidrIps(Collection<String> var1);

        public Builder cidrIps(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

