/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.services.directconnect.model.Tag;
import software.amazon.awssdk.services.directconnect.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLagRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, CreateLagRequest> {
    private static final SdkField<Integer> NUMBER_OF_CONNECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numberOfConnections").getter(CreateLagRequest.getter(CreateLagRequest::numberOfConnections)).setter(CreateLagRequest.setter(Builder::numberOfConnections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfConnections").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("location").getter(CreateLagRequest.getter(CreateLagRequest::location)).setter(CreateLagRequest.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> CONNECTIONS_BANDWIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionsBandwidth").getter(CreateLagRequest.getter(CreateLagRequest::connectionsBandwidth)).setter(CreateLagRequest.setter(Builder::connectionsBandwidth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionsBandwidth").build()}).build();
    private static final SdkField<String> LAG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lagName").getter(CreateLagRequest.getter(CreateLagRequest::lagName)).setter(CreateLagRequest.setter(Builder::lagName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lagName").build()}).build();
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionId").getter(CreateLagRequest.getter(CreateLagRequest::connectionId)).setter(CreateLagRequest.setter(Builder::connectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateLagRequest.getter(CreateLagRequest::tags)).setter(CreateLagRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> CHILD_CONNECTION_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("childConnectionTags").getter(CreateLagRequest.getter(CreateLagRequest::childConnectionTags)).setter(CreateLagRequest.setter(Builder::childConnectionTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childConnectionTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerName").getter(CreateLagRequest.getter(CreateLagRequest::providerName)).setter(CreateLagRequest.setter(Builder::providerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerName").build()}).build();
    private static final SdkField<Boolean> REQUEST_MAC_SEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("requestMACSec").getter(CreateLagRequest.getter(CreateLagRequest::requestMACSec)).setter(CreateLagRequest.setter(Builder::requestMACSec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestMACSec").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_OF_CONNECTIONS_FIELD, LOCATION_FIELD, CONNECTIONS_BANDWIDTH_FIELD, LAG_NAME_FIELD, CONNECTION_ID_FIELD, TAGS_FIELD, CHILD_CONNECTION_TAGS_FIELD, PROVIDER_NAME_FIELD, REQUEST_MAC_SEC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("numberOfConnections", NUMBER_OF_CONNECTIONS_FIELD);
            this.put("location", LOCATION_FIELD);
            this.put("connectionsBandwidth", CONNECTIONS_BANDWIDTH_FIELD);
            this.put("lagName", LAG_NAME_FIELD);
            this.put("connectionId", CONNECTION_ID_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("childConnectionTags", CHILD_CONNECTION_TAGS_FIELD);
            this.put("providerName", PROVIDER_NAME_FIELD);
            this.put("requestMACSec", REQUEST_MAC_SEC_FIELD);
        }
    });
    private final Integer numberOfConnections;
    private final String location;
    private final String connectionsBandwidth;
    private final String lagName;
    private final String connectionId;
    private final List<Tag> tags;
    private final List<Tag> childConnectionTags;
    private final String providerName;
    private final Boolean requestMACSec;

    private CreateLagRequest(BuilderImpl builder) {
        super(builder);
        this.numberOfConnections = builder.numberOfConnections;
        this.location = builder.location;
        this.connectionsBandwidth = builder.connectionsBandwidth;
        this.lagName = builder.lagName;
        this.connectionId = builder.connectionId;
        this.tags = builder.tags;
        this.childConnectionTags = builder.childConnectionTags;
        this.providerName = builder.providerName;
        this.requestMACSec = builder.requestMACSec;
    }

    public final Integer numberOfConnections() {
        return this.numberOfConnections;
    }

    public final String location() {
        return this.location;
    }

    public final String connectionsBandwidth() {
        return this.connectionsBandwidth;
    }

    public final String lagName() {
        return this.lagName;
    }

    public final String connectionId() {
        return this.connectionId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final boolean hasChildConnectionTags() {
        return this.childConnectionTags != null && !(this.childConnectionTags instanceof SdkAutoConstructList);
    }

    public final List<Tag> childConnectionTags() {
        return this.childConnectionTags;
    }

    public final String providerName() {
        return this.providerName;
    }

    public final Boolean requestMACSec() {
        return this.requestMACSec;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfConnections());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionsBandwidth());
        hashCode = 31 * hashCode + Objects.hashCode(this.lagName());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChildConnectionTags() ? this.childConnectionTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.providerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestMACSec());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLagRequest)) {
            return false;
        }
        CreateLagRequest other = (CreateLagRequest)((Object)obj);
        return Objects.equals(this.numberOfConnections(), other.numberOfConnections()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.connectionsBandwidth(), other.connectionsBandwidth()) && Objects.equals(this.lagName(), other.lagName()) && Objects.equals(this.connectionId(), other.connectionId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasChildConnectionTags() == other.hasChildConnectionTags() && Objects.equals(this.childConnectionTags(), other.childConnectionTags()) && Objects.equals(this.providerName(), other.providerName()) && Objects.equals(this.requestMACSec(), other.requestMACSec());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLagRequest").add("NumberOfConnections", (Object)this.numberOfConnections()).add("Location", (Object)this.location()).add("ConnectionsBandwidth", (Object)this.connectionsBandwidth()).add("LagName", (Object)this.lagName()).add("ConnectionId", (Object)this.connectionId()).add("Tags", this.hasTags() ? this.tags() : null).add("ChildConnectionTags", this.hasChildConnectionTags() ? this.childConnectionTags() : null).add("ProviderName", (Object)this.providerName()).add("RequestMACSec", (Object)this.requestMACSec()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "numberOfConnections": {
                return Optional.ofNullable(clazz.cast(this.numberOfConnections()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "connectionsBandwidth": {
                return Optional.ofNullable(clazz.cast(this.connectionsBandwidth()));
            }
            case "lagName": {
                return Optional.ofNullable(clazz.cast(this.lagName()));
            }
            case "connectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "childConnectionTags": {
                return Optional.ofNullable(clazz.cast(this.childConnectionTags()));
            }
            case "providerName": {
                return Optional.ofNullable(clazz.cast(this.providerName()));
            }
            case "requestMACSec": {
                return Optional.ofNullable(clazz.cast(this.requestMACSec()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateLagRequest, T> g) {
        return obj -> g.apply((CreateLagRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private Integer numberOfConnections;
        private String location;
        private String connectionsBandwidth;
        private String lagName;
        private String connectionId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> childConnectionTags = DefaultSdkAutoConstructList.getInstance();
        private String providerName;
        private Boolean requestMACSec;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLagRequest model) {
            super(model);
            this.numberOfConnections(model.numberOfConnections);
            this.location(model.location);
            this.connectionsBandwidth(model.connectionsBandwidth);
            this.lagName(model.lagName);
            this.connectionId(model.connectionId);
            this.tags(model.tags);
            this.childConnectionTags(model.childConnectionTags);
            this.providerName(model.providerName);
            this.requestMACSec(model.requestMACSec);
        }

        public final Integer getNumberOfConnections() {
            return this.numberOfConnections;
        }

        public final void setNumberOfConnections(Integer numberOfConnections) {
            this.numberOfConnections = numberOfConnections;
        }

        @Override
        public final Builder numberOfConnections(Integer numberOfConnections) {
            this.numberOfConnections = numberOfConnections;
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getConnectionsBandwidth() {
            return this.connectionsBandwidth;
        }

        public final void setConnectionsBandwidth(String connectionsBandwidth) {
            this.connectionsBandwidth = connectionsBandwidth;
        }

        @Override
        public final Builder connectionsBandwidth(String connectionsBandwidth) {
            this.connectionsBandwidth = connectionsBandwidth;
            return this;
        }

        public final String getLagName() {
            return this.lagName;
        }

        public final void setLagName(String lagName) {
            this.lagName = lagName;
        }

        @Override
        public final Builder lagName(String lagName) {
            this.lagName = lagName;
            return this;
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getChildConnectionTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.childConnectionTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChildConnectionTags(Collection<Tag.BuilderImpl> childConnectionTags) {
            this.childConnectionTags = TagListCopier.copyFromBuilder(childConnectionTags);
        }

        @Override
        public final Builder childConnectionTags(Collection<Tag> childConnectionTags) {
            this.childConnectionTags = TagListCopier.copy(childConnectionTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder childConnectionTags(Tag ... childConnectionTags) {
            this.childConnectionTags(Arrays.asList(childConnectionTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder childConnectionTags(Consumer<Tag.Builder> ... childConnectionTags) {
            this.childConnectionTags(Stream.of(childConnectionTags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getProviderName() {
            return this.providerName;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final Boolean getRequestMACSec() {
            return this.requestMACSec;
        }

        public final void setRequestMACSec(Boolean requestMACSec) {
            this.requestMACSec = requestMACSec;
        }

        @Override
        public final Builder requestMACSec(Boolean requestMACSec) {
            this.requestMACSec = requestMACSec;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLagRequest build() {
            return new CreateLagRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLagRequest> {
        public Builder numberOfConnections(Integer var1);

        public Builder location(String var1);

        public Builder connectionsBandwidth(String var1);

        public Builder lagName(String var1);

        public Builder connectionId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder childConnectionTags(Collection<Tag> var1);

        public Builder childConnectionTags(Tag ... var1);

        public Builder childConnectionTags(Consumer<Tag.Builder> ... var1);

        public Builder providerName(String var1);

        public Builder requestMACSec(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

