/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruClient;
import software.amazon.awssdk.services.devopsguru.internal.UserAgentUtils;
import software.amazon.awssdk.services.devopsguru.model.AccountHealth;
import software.amazon.awssdk.services.devopsguru.model.CloudFormationHealth;
import software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthResponse;
import software.amazon.awssdk.services.devopsguru.model.ServiceHealth;
import software.amazon.awssdk.services.devopsguru.model.TagHealth;

public class DescribeOrganizationResourceCollectionHealthIterable
implements SdkIterable<DescribeOrganizationResourceCollectionHealthResponse> {
    private final DevOpsGuruClient client;
    private final DescribeOrganizationResourceCollectionHealthRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeOrganizationResourceCollectionHealthIterable(DevOpsGuruClient client, DescribeOrganizationResourceCollectionHealthRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeOrganizationResourceCollectionHealthResponseFetcher();
    }

    public Iterator<DescribeOrganizationResourceCollectionHealthResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CloudFormationHealth> cloudFormation() {
        Function<DescribeOrganizationResourceCollectionHealthResponse, Iterator> getIterator = response -> {
            if (response != null && response.cloudFormation() != null) {
                return response.cloudFormation().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    public final SdkIterable<AccountHealth> account() {
        Function<DescribeOrganizationResourceCollectionHealthResponse, Iterator> getIterator = response -> {
            if (response != null && response.account() != null) {
                return response.account().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    public final SdkIterable<ServiceHealth> service() {
        Function<DescribeOrganizationResourceCollectionHealthResponse, Iterator> getIterator = response -> {
            if (response != null && response.service() != null) {
                return response.service().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    public final SdkIterable<TagHealth> tags() {
        Function<DescribeOrganizationResourceCollectionHealthResponse, Iterator> getIterator = response -> {
            if (response != null && response.tags() != null) {
                return response.tags().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeOrganizationResourceCollectionHealthResponseFetcher
    implements SyncPageFetcher<DescribeOrganizationResourceCollectionHealthResponse> {
        private DescribeOrganizationResourceCollectionHealthResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOrganizationResourceCollectionHealthResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeOrganizationResourceCollectionHealthResponse nextPage(DescribeOrganizationResourceCollectionHealthResponse previousPage) {
            if (previousPage == null) {
                return DescribeOrganizationResourceCollectionHealthIterable.this.client.describeOrganizationResourceCollectionHealth(DescribeOrganizationResourceCollectionHealthIterable.this.firstRequest);
            }
            return DescribeOrganizationResourceCollectionHealthIterable.this.client.describeOrganizationResourceCollectionHealth((DescribeOrganizationResourceCollectionHealthRequest)((Object)DescribeOrganizationResourceCollectionHealthIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

