/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devopsguru.model.NotificationFilterConfig;
import software.amazon.awssdk.services.devopsguru.model.SnsChannelConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotificationChannelConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NotificationChannelConfig> {
    private static final SdkField<SnsChannelConfig> SNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sns").getter(NotificationChannelConfig.getter(NotificationChannelConfig::sns)).setter(NotificationChannelConfig.setter(Builder::sns)).constructor(SnsChannelConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sns").build()}).build();
    private static final SdkField<NotificationFilterConfig> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filters").getter(NotificationChannelConfig.getter(NotificationChannelConfig::filters)).setter(NotificationChannelConfig.setter(Builder::filters)).constructor(NotificationFilterConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNS_FIELD, FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Sns", SNS_FIELD);
            this.put("Filters", FILTERS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final SnsChannelConfig sns;
    private final NotificationFilterConfig filters;

    private NotificationChannelConfig(BuilderImpl builder) {
        this.sns = builder.sns;
        this.filters = builder.filters;
    }

    public final SnsChannelConfig sns() {
        return this.sns;
    }

    public final NotificationFilterConfig filters() {
        return this.filters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sns());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationChannelConfig)) {
            return false;
        }
        NotificationChannelConfig other = (NotificationChannelConfig)obj;
        return Objects.equals(this.sns(), other.sns()) && Objects.equals(this.filters(), other.filters());
    }

    public final String toString() {
        return ToString.builder((String)"NotificationChannelConfig").add("Sns", (Object)this.sns()).add("Filters", (Object)this.filters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Sns": {
                return Optional.ofNullable(clazz.cast(this.sns()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<NotificationChannelConfig, T> g) {
        return obj -> g.apply((NotificationChannelConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SnsChannelConfig sns;
        private NotificationFilterConfig filters;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationChannelConfig model) {
            this.sns(model.sns);
            this.filters(model.filters);
        }

        public final SnsChannelConfig.Builder getSns() {
            return this.sns != null ? this.sns.toBuilder() : null;
        }

        public final void setSns(SnsChannelConfig.BuilderImpl sns) {
            this.sns = sns != null ? sns.build() : null;
        }

        @Override
        public final Builder sns(SnsChannelConfig sns) {
            this.sns = sns;
            return this;
        }

        public final NotificationFilterConfig.Builder getFilters() {
            return this.filters != null ? this.filters.toBuilder() : null;
        }

        public final void setFilters(NotificationFilterConfig.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(NotificationFilterConfig filters) {
            this.filters = filters;
            return this;
        }

        public NotificationChannelConfig build() {
            return new NotificationChannelConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NotificationChannelConfig> {
        public Builder sns(SnsChannelConfig var1);

        default public Builder sns(Consumer<SnsChannelConfig.Builder> sns) {
            return this.sns((SnsChannelConfig)((SnsChannelConfig.Builder)SnsChannelConfig.builder().applyMutation(sns)).build());
        }

        public Builder filters(NotificationFilterConfig var1);

        default public Builder filters(Consumer<NotificationFilterConfig.Builder> filters) {
            return this.filters((NotificationFilterConfig)((NotificationFilterConfig.Builder)NotificationFilterConfig.builder().applyMutation(filters)).build());
        }
    }
}

