/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devopsguru.model.DevOpsGuruResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOrganizationOverviewResponse
extends DevOpsGuruResponse
implements ToCopyableBuilder<Builder, DescribeOrganizationOverviewResponse> {
    private static final SdkField<Integer> REACTIVE_INSIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ReactiveInsights").getter(DescribeOrganizationOverviewResponse.getter(DescribeOrganizationOverviewResponse::reactiveInsights)).setter(DescribeOrganizationOverviewResponse.setter(Builder::reactiveInsights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReactiveInsights").build()}).build();
    private static final SdkField<Integer> PROACTIVE_INSIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ProactiveInsights").getter(DescribeOrganizationOverviewResponse.getter(DescribeOrganizationOverviewResponse::proactiveInsights)).setter(DescribeOrganizationOverviewResponse.setter(Builder::proactiveInsights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProactiveInsights").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REACTIVE_INSIGHTS_FIELD, PROACTIVE_INSIGHTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ReactiveInsights", REACTIVE_INSIGHTS_FIELD);
            this.put("ProactiveInsights", PROACTIVE_INSIGHTS_FIELD);
        }
    });
    private final Integer reactiveInsights;
    private final Integer proactiveInsights;

    private DescribeOrganizationOverviewResponse(BuilderImpl builder) {
        super(builder);
        this.reactiveInsights = builder.reactiveInsights;
        this.proactiveInsights = builder.proactiveInsights;
    }

    public final Integer reactiveInsights() {
        return this.reactiveInsights;
    }

    public final Integer proactiveInsights() {
        return this.proactiveInsights;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reactiveInsights());
        hashCode = 31 * hashCode + Objects.hashCode(this.proactiveInsights());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationOverviewResponse)) {
            return false;
        }
        DescribeOrganizationOverviewResponse other = (DescribeOrganizationOverviewResponse)((Object)obj);
        return Objects.equals(this.reactiveInsights(), other.reactiveInsights()) && Objects.equals(this.proactiveInsights(), other.proactiveInsights());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeOrganizationOverviewResponse").add("ReactiveInsights", (Object)this.reactiveInsights()).add("ProactiveInsights", (Object)this.proactiveInsights()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReactiveInsights": {
                return Optional.ofNullable(clazz.cast(this.reactiveInsights()));
            }
            case "ProactiveInsights": {
                return Optional.ofNullable(clazz.cast(this.proactiveInsights()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationOverviewResponse, T> g) {
        return obj -> g.apply((DescribeOrganizationOverviewResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DevOpsGuruResponse.BuilderImpl
    implements Builder {
        private Integer reactiveInsights;
        private Integer proactiveInsights;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationOverviewResponse model) {
            super(model);
            this.reactiveInsights(model.reactiveInsights);
            this.proactiveInsights(model.proactiveInsights);
        }

        public final Integer getReactiveInsights() {
            return this.reactiveInsights;
        }

        public final void setReactiveInsights(Integer reactiveInsights) {
            this.reactiveInsights = reactiveInsights;
        }

        @Override
        public final Builder reactiveInsights(Integer reactiveInsights) {
            this.reactiveInsights = reactiveInsights;
            return this;
        }

        public final Integer getProactiveInsights() {
            return this.proactiveInsights;
        }

        public final void setProactiveInsights(Integer proactiveInsights) {
            this.proactiveInsights = proactiveInsights;
        }

        @Override
        public final Builder proactiveInsights(Integer proactiveInsights) {
            this.proactiveInsights = proactiveInsights;
            return this;
        }

        @Override
        public DescribeOrganizationOverviewResponse build() {
            return new DescribeOrganizationOverviewResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DevOpsGuruResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeOrganizationOverviewResponse> {
        public Builder reactiveInsights(Integer var1);

        public Builder proactiveInsights(Integer var1);
    }
}

