/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devopsguru.model.LogAnomalyShowcase;
import software.amazon.awssdk.services.devopsguru.model.LogAnomalyShowcasesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnomalousLogGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnomalousLogGroup> {
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogGroupName").getter(AnomalousLogGroup.getter(AnomalousLogGroup::logGroupName)).setter(AnomalousLogGroup.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupName").build()}).build();
    private static final SdkField<Instant> IMPACT_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ImpactStartTime").getter(AnomalousLogGroup.getter(AnomalousLogGroup::impactStartTime)).setter(AnomalousLogGroup.setter(Builder::impactStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImpactStartTime").build()}).build();
    private static final SdkField<Instant> IMPACT_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ImpactEndTime").getter(AnomalousLogGroup.getter(AnomalousLogGroup::impactEndTime)).setter(AnomalousLogGroup.setter(Builder::impactEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImpactEndTime").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_LOG_LINES_SCANNED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfLogLinesScanned").getter(AnomalousLogGroup.getter(AnomalousLogGroup::numberOfLogLinesScanned)).setter(AnomalousLogGroup.setter(Builder::numberOfLogLinesScanned)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfLogLinesScanned").build()}).build();
    private static final SdkField<List<LogAnomalyShowcase>> LOG_ANOMALY_SHOWCASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LogAnomalyShowcases").getter(AnomalousLogGroup.getter(AnomalousLogGroup::logAnomalyShowcases)).setter(AnomalousLogGroup.setter(Builder::logAnomalyShowcases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogAnomalyShowcases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LogAnomalyShowcase::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_FIELD, IMPACT_START_TIME_FIELD, IMPACT_END_TIME_FIELD, NUMBER_OF_LOG_LINES_SCANNED_FIELD, LOG_ANOMALY_SHOWCASES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LogGroupName", LOG_GROUP_NAME_FIELD);
            this.put("ImpactStartTime", IMPACT_START_TIME_FIELD);
            this.put("ImpactEndTime", IMPACT_END_TIME_FIELD);
            this.put("NumberOfLogLinesScanned", NUMBER_OF_LOG_LINES_SCANNED_FIELD);
            this.put("LogAnomalyShowcases", LOG_ANOMALY_SHOWCASES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String logGroupName;
    private final Instant impactStartTime;
    private final Instant impactEndTime;
    private final Integer numberOfLogLinesScanned;
    private final List<LogAnomalyShowcase> logAnomalyShowcases;

    private AnomalousLogGroup(BuilderImpl builder) {
        this.logGroupName = builder.logGroupName;
        this.impactStartTime = builder.impactStartTime;
        this.impactEndTime = builder.impactEndTime;
        this.numberOfLogLinesScanned = builder.numberOfLogLinesScanned;
        this.logAnomalyShowcases = builder.logAnomalyShowcases;
    }

    public final String logGroupName() {
        return this.logGroupName;
    }

    public final Instant impactStartTime() {
        return this.impactStartTime;
    }

    public final Instant impactEndTime() {
        return this.impactEndTime;
    }

    public final Integer numberOfLogLinesScanned() {
        return this.numberOfLogLinesScanned;
    }

    public final boolean hasLogAnomalyShowcases() {
        return this.logAnomalyShowcases != null && !(this.logAnomalyShowcases instanceof SdkAutoConstructList);
    }

    public final List<LogAnomalyShowcase> logAnomalyShowcases() {
        return this.logAnomalyShowcases;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.impactStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.impactEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfLogLinesScanned());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogAnomalyShowcases() ? this.logAnomalyShowcases() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalousLogGroup)) {
            return false;
        }
        AnomalousLogGroup other = (AnomalousLogGroup)obj;
        return Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.impactStartTime(), other.impactStartTime()) && Objects.equals(this.impactEndTime(), other.impactEndTime()) && Objects.equals(this.numberOfLogLinesScanned(), other.numberOfLogLinesScanned()) && this.hasLogAnomalyShowcases() == other.hasLogAnomalyShowcases() && Objects.equals(this.logAnomalyShowcases(), other.logAnomalyShowcases());
    }

    public final String toString() {
        return ToString.builder((String)"AnomalousLogGroup").add("LogGroupName", (Object)this.logGroupName()).add("ImpactStartTime", (Object)this.impactStartTime()).add("ImpactEndTime", (Object)this.impactEndTime()).add("NumberOfLogLinesScanned", (Object)this.numberOfLogLinesScanned()).add("LogAnomalyShowcases", this.hasLogAnomalyShowcases() ? this.logAnomalyShowcases() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "ImpactStartTime": {
                return Optional.ofNullable(clazz.cast(this.impactStartTime()));
            }
            case "ImpactEndTime": {
                return Optional.ofNullable(clazz.cast(this.impactEndTime()));
            }
            case "NumberOfLogLinesScanned": {
                return Optional.ofNullable(clazz.cast(this.numberOfLogLinesScanned()));
            }
            case "LogAnomalyShowcases": {
                return Optional.ofNullable(clazz.cast(this.logAnomalyShowcases()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AnomalousLogGroup, T> g) {
        return obj -> g.apply((AnomalousLogGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logGroupName;
        private Instant impactStartTime;
        private Instant impactEndTime;
        private Integer numberOfLogLinesScanned;
        private List<LogAnomalyShowcase> logAnomalyShowcases = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalousLogGroup model) {
            this.logGroupName(model.logGroupName);
            this.impactStartTime(model.impactStartTime);
            this.impactEndTime(model.impactEndTime);
            this.numberOfLogLinesScanned(model.numberOfLogLinesScanned);
            this.logAnomalyShowcases(model.logAnomalyShowcases);
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final Instant getImpactStartTime() {
            return this.impactStartTime;
        }

        public final void setImpactStartTime(Instant impactStartTime) {
            this.impactStartTime = impactStartTime;
        }

        @Override
        public final Builder impactStartTime(Instant impactStartTime) {
            this.impactStartTime = impactStartTime;
            return this;
        }

        public final Instant getImpactEndTime() {
            return this.impactEndTime;
        }

        public final void setImpactEndTime(Instant impactEndTime) {
            this.impactEndTime = impactEndTime;
        }

        @Override
        public final Builder impactEndTime(Instant impactEndTime) {
            this.impactEndTime = impactEndTime;
            return this;
        }

        public final Integer getNumberOfLogLinesScanned() {
            return this.numberOfLogLinesScanned;
        }

        public final void setNumberOfLogLinesScanned(Integer numberOfLogLinesScanned) {
            this.numberOfLogLinesScanned = numberOfLogLinesScanned;
        }

        @Override
        public final Builder numberOfLogLinesScanned(Integer numberOfLogLinesScanned) {
            this.numberOfLogLinesScanned = numberOfLogLinesScanned;
            return this;
        }

        public final List<LogAnomalyShowcase.Builder> getLogAnomalyShowcases() {
            List<LogAnomalyShowcase.Builder> result = LogAnomalyShowcasesCopier.copyToBuilder(this.logAnomalyShowcases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogAnomalyShowcases(Collection<LogAnomalyShowcase.BuilderImpl> logAnomalyShowcases) {
            this.logAnomalyShowcases = LogAnomalyShowcasesCopier.copyFromBuilder(logAnomalyShowcases);
        }

        @Override
        public final Builder logAnomalyShowcases(Collection<LogAnomalyShowcase> logAnomalyShowcases) {
            this.logAnomalyShowcases = LogAnomalyShowcasesCopier.copy(logAnomalyShowcases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logAnomalyShowcases(LogAnomalyShowcase ... logAnomalyShowcases) {
            this.logAnomalyShowcases(Arrays.asList(logAnomalyShowcases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logAnomalyShowcases(Consumer<LogAnomalyShowcase.Builder> ... logAnomalyShowcases) {
            this.logAnomalyShowcases(Stream.of(logAnomalyShowcases).map(c -> (LogAnomalyShowcase)((LogAnomalyShowcase.Builder)LogAnomalyShowcase.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AnomalousLogGroup build() {
            return new AnomalousLogGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnomalousLogGroup> {
        public Builder logGroupName(String var1);

        public Builder impactStartTime(Instant var1);

        public Builder impactEndTime(Instant var1);

        public Builder numberOfLogLinesScanned(Integer var1);

        public Builder logAnomalyShowcases(Collection<LogAnomalyShowcase> var1);

        public Builder logAnomalyShowcases(LogAnomalyShowcase ... var1);

        public Builder logAnomalyShowcases(Consumer<LogAnomalyShowcase.Builder> ... var1);
    }
}

