/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.Problem;
import software.amazon.awssdk.services.devicefarm.model.ProblemsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UniqueProblem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UniqueProblem> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(UniqueProblem.getter(UniqueProblem::message)).setter(UniqueProblem.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<List<Problem>> PROBLEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("problems").getter(UniqueProblem.getter(UniqueProblem::problems)).setter(UniqueProblem.setter(Builder::problems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("problems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Problem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD, PROBLEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("message", MESSAGE_FIELD);
            this.put("problems", PROBLEMS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String message;
    private final List<Problem> problems;

    private UniqueProblem(BuilderImpl builder) {
        this.message = builder.message;
        this.problems = builder.problems;
    }

    public final String message() {
        return this.message;
    }

    public final boolean hasProblems() {
        return this.problems != null && !(this.problems instanceof SdkAutoConstructList);
    }

    public final List<Problem> problems() {
        return this.problems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProblems() ? this.problems() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UniqueProblem)) {
            return false;
        }
        UniqueProblem other = (UniqueProblem)obj;
        return Objects.equals(this.message(), other.message()) && this.hasProblems() == other.hasProblems() && Objects.equals(this.problems(), other.problems());
    }

    public final String toString() {
        return ToString.builder((String)"UniqueProblem").add("Message", (Object)this.message()).add("Problems", this.hasProblems() ? this.problems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "problems": {
                return Optional.ofNullable(clazz.cast(this.problems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UniqueProblem, T> g) {
        return obj -> g.apply((UniqueProblem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String message;
        private List<Problem> problems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UniqueProblem model) {
            this.message(model.message);
            this.problems(model.problems);
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final List<Problem.Builder> getProblems() {
            List<Problem.Builder> result = ProblemsCopier.copyToBuilder(this.problems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProblems(Collection<Problem.BuilderImpl> problems) {
            this.problems = ProblemsCopier.copyFromBuilder(problems);
        }

        @Override
        public final Builder problems(Collection<Problem> problems) {
            this.problems = ProblemsCopier.copy(problems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder problems(Problem ... problems) {
            this.problems(Arrays.asList(problems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder problems(Consumer<Problem.Builder> ... problems) {
            this.problems(Stream.of(problems).map(c -> (Problem)((Problem.Builder)Problem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public UniqueProblem build() {
            return new UniqueProblem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UniqueProblem> {
        public Builder message(String var1);

        public Builder problems(Collection<Problem> var1);

        public Builder problems(Problem ... var1);

        public Builder problems(Consumer<Problem.Builder> ... var1);
    }
}

