/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Reason {
    AWS_THREAT_INTELLIGENCE("AWS_THREAT_INTELLIGENCE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Reason> VALUE_MAP;
    private final String value;

    private Reason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Reason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Reason> knownValues() {
        EnumSet<Reason> knownValues = EnumSet.allOf(Reason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Reason.class, Reason::toString);
    }
}

