/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.detective.model.DetectiveRequest;
import software.amazon.awssdk.services.detective.model.IndicatorType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIndicatorsRequest
extends DetectiveRequest
implements ToCopyableBuilder<Builder, ListIndicatorsRequest> {
    private static final SdkField<String> GRAPH_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GraphArn").getter(ListIndicatorsRequest.getter(ListIndicatorsRequest::graphArn)).setter(ListIndicatorsRequest.setter(Builder::graphArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GraphArn").build()}).build();
    private static final SdkField<String> INVESTIGATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InvestigationId").getter(ListIndicatorsRequest.getter(ListIndicatorsRequest::investigationId)).setter(ListIndicatorsRequest.setter(Builder::investigationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvestigationId").build()}).build();
    private static final SdkField<String> INDICATOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndicatorType").getter(ListIndicatorsRequest.getter(ListIndicatorsRequest::indicatorTypeAsString)).setter(ListIndicatorsRequest.setter(Builder::indicatorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndicatorType").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListIndicatorsRequest.getter(ListIndicatorsRequest::nextToken)).setter(ListIndicatorsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListIndicatorsRequest.getter(ListIndicatorsRequest::maxResults)).setter(ListIndicatorsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_ARN_FIELD, INVESTIGATION_ID_FIELD, INDICATOR_TYPE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("GraphArn", GRAPH_ARN_FIELD);
            this.put("InvestigationId", INVESTIGATION_ID_FIELD);
            this.put("IndicatorType", INDICATOR_TYPE_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
        }
    });
    private final String graphArn;
    private final String investigationId;
    private final String indicatorType;
    private final String nextToken;
    private final Integer maxResults;

    private ListIndicatorsRequest(BuilderImpl builder) {
        super(builder);
        this.graphArn = builder.graphArn;
        this.investigationId = builder.investigationId;
        this.indicatorType = builder.indicatorType;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String graphArn() {
        return this.graphArn;
    }

    public final String investigationId() {
        return this.investigationId;
    }

    public final IndicatorType indicatorType() {
        return IndicatorType.fromValue(this.indicatorType);
    }

    public final String indicatorTypeAsString() {
        return this.indicatorType;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.graphArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.investigationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.indicatorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIndicatorsRequest)) {
            return false;
        }
        ListIndicatorsRequest other = (ListIndicatorsRequest)((Object)obj);
        return Objects.equals(this.graphArn(), other.graphArn()) && Objects.equals(this.investigationId(), other.investigationId()) && Objects.equals(this.indicatorTypeAsString(), other.indicatorTypeAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListIndicatorsRequest").add("GraphArn", (Object)this.graphArn()).add("InvestigationId", (Object)this.investigationId()).add("IndicatorType", (Object)this.indicatorTypeAsString()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GraphArn": {
                return Optional.ofNullable(clazz.cast(this.graphArn()));
            }
            case "InvestigationId": {
                return Optional.ofNullable(clazz.cast(this.investigationId()));
            }
            case "IndicatorType": {
                return Optional.ofNullable(clazz.cast(this.indicatorTypeAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListIndicatorsRequest, T> g) {
        return obj -> g.apply((ListIndicatorsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DetectiveRequest.BuilderImpl
    implements Builder {
        private String graphArn;
        private String investigationId;
        private String indicatorType;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIndicatorsRequest model) {
            super(model);
            this.graphArn(model.graphArn);
            this.investigationId(model.investigationId);
            this.indicatorType(model.indicatorType);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getGraphArn() {
            return this.graphArn;
        }

        public final void setGraphArn(String graphArn) {
            this.graphArn = graphArn;
        }

        @Override
        public final Builder graphArn(String graphArn) {
            this.graphArn = graphArn;
            return this;
        }

        public final String getInvestigationId() {
            return this.investigationId;
        }

        public final void setInvestigationId(String investigationId) {
            this.investigationId = investigationId;
        }

        @Override
        public final Builder investigationId(String investigationId) {
            this.investigationId = investigationId;
            return this;
        }

        public final String getIndicatorType() {
            return this.indicatorType;
        }

        public final void setIndicatorType(String indicatorType) {
            this.indicatorType = indicatorType;
        }

        @Override
        public final Builder indicatorType(String indicatorType) {
            this.indicatorType = indicatorType;
            return this;
        }

        @Override
        public final Builder indicatorType(IndicatorType indicatorType) {
            this.indicatorType(indicatorType == null ? null : indicatorType.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListIndicatorsRequest build() {
            return new ListIndicatorsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DetectiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIndicatorsRequest> {
        public Builder graphArn(String var1);

        public Builder investigationId(String var1);

        public Builder indicatorType(String var1);

        public Builder indicatorType(IndicatorType var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

