/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.dataexchange.DataExchangeClient;
import software.amazon.awssdk.services.dataexchange.internal.UserAgentUtils;
import software.amazon.awssdk.services.dataexchange.model.ListReceivedDataGrantsRequest;
import software.amazon.awssdk.services.dataexchange.model.ListReceivedDataGrantsResponse;
import software.amazon.awssdk.services.dataexchange.model.ReceivedDataGrantSummariesEntry;

public class ListReceivedDataGrantsIterable
implements SdkIterable<ListReceivedDataGrantsResponse> {
    private final DataExchangeClient client;
    private final ListReceivedDataGrantsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListReceivedDataGrantsIterable(DataExchangeClient client, ListReceivedDataGrantsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListReceivedDataGrantsResponseFetcher();
    }

    public Iterator<ListReceivedDataGrantsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReceivedDataGrantSummariesEntry> dataGrantSummaries() {
        Function<ListReceivedDataGrantsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataGrantSummaries() != null) {
                return response.dataGrantSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListReceivedDataGrantsResponseFetcher
    implements SyncPageFetcher<ListReceivedDataGrantsResponse> {
        private ListReceivedDataGrantsResponseFetcher() {
        }

        public boolean hasNextPage(ListReceivedDataGrantsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListReceivedDataGrantsResponse nextPage(ListReceivedDataGrantsResponse previousPage) {
            if (previousPage == null) {
                return ListReceivedDataGrantsIterable.this.client.listReceivedDataGrants(ListReceivedDataGrantsIterable.this.firstRequest);
            }
            return ListReceivedDataGrantsIterable.this.client.listReceivedDataGrants((ListReceivedDataGrantsRequest)((Object)ListReceivedDataGrantsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

