/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dataexchange.model.DataExchangeException;
import software.amazon.awssdk.services.dataexchange.model.LimitName;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceLimitExceededException
extends DataExchangeException
implements ToCopyableBuilder<Builder, ServiceLimitExceededException> {
    private static final SdkField<String> LIMIT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LimitName").getter(ServiceLimitExceededException.getter(ServiceLimitExceededException::limitNameAsString)).setter(ServiceLimitExceededException.setter(Builder::limitName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LimitName").build()}).build();
    private static final SdkField<Double> LIMIT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("LimitValue").getter(ServiceLimitExceededException.getter(ServiceLimitExceededException::limitValue)).setter(ServiceLimitExceededException.setter(Builder::limitValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LimitValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMIT_NAME_FIELD, LIMIT_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LimitName", LIMIT_NAME_FIELD);
            this.put("LimitValue", LIMIT_VALUE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String limitName;
    private final Double limitValue;

    private ServiceLimitExceededException(BuilderImpl builder) {
        super(builder);
        this.limitName = builder.limitName;
        this.limitValue = builder.limitValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public LimitName limitName() {
        return LimitName.fromValue(this.limitName);
    }

    public String limitNameAsString() {
        return this.limitName;
    }

    public Double limitValue() {
        return this.limitValue;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ServiceLimitExceededException, T> g) {
        return obj -> g.apply((ServiceLimitExceededException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataExchangeException.BuilderImpl
    implements Builder {
        private String limitName;
        private Double limitValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceLimitExceededException model) {
            super(model);
            this.limitName(model.limitName);
            this.limitValue(model.limitValue);
        }

        public final String getLimitName() {
            return this.limitName;
        }

        public final void setLimitName(String limitName) {
            this.limitName = limitName;
        }

        @Override
        public final Builder limitName(String limitName) {
            this.limitName = limitName;
            return this;
        }

        @Override
        public final Builder limitName(LimitName limitName) {
            this.limitName(limitName == null ? null : limitName.toString());
            return this;
        }

        public final Double getLimitValue() {
            return this.limitValue;
        }

        public final void setLimitValue(Double limitValue) {
            this.limitValue = limitValue;
        }

        @Override
        public final Builder limitValue(Double limitValue) {
            this.limitValue = limitValue;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public ServiceLimitExceededException build() {
            return new ServiceLimitExceededException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceLimitExceededException>,
    DataExchangeException.Builder {
        public Builder limitName(String var1);

        public Builder limitName(LimitName var1);

        public Builder limitValue(Double var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);

        @Override
        public Builder writableStackTrace(Boolean var1);
    }
}

