/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databrew.model.DataBrewRequest;
import software.amazon.awssdk.services.databrew.model.RecipeStep;
import software.amazon.awssdk.services.databrew.model.ViewFrame;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendProjectSessionActionRequest
extends DataBrewRequest
implements ToCopyableBuilder<Builder, SendProjectSessionActionRequest> {
    private static final SdkField<Boolean> PREVIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Preview").getter(SendProjectSessionActionRequest.getter(SendProjectSessionActionRequest::preview)).setter(SendProjectSessionActionRequest.setter(Builder::preview)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Preview").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(SendProjectSessionActionRequest.getter(SendProjectSessionActionRequest::name)).setter(SendProjectSessionActionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<RecipeStep> RECIPE_STEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RecipeStep").getter(SendProjectSessionActionRequest.getter(SendProjectSessionActionRequest::recipeStep)).setter(SendProjectSessionActionRequest.setter(Builder::recipeStep)).constructor(RecipeStep::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecipeStep").build()}).build();
    private static final SdkField<Integer> STEP_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StepIndex").getter(SendProjectSessionActionRequest.getter(SendProjectSessionActionRequest::stepIndex)).setter(SendProjectSessionActionRequest.setter(Builder::stepIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepIndex").build()}).build();
    private static final SdkField<String> CLIENT_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientSessionId").getter(SendProjectSessionActionRequest.getter(SendProjectSessionActionRequest::clientSessionId)).setter(SendProjectSessionActionRequest.setter(Builder::clientSessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientSessionId").build()}).build();
    private static final SdkField<ViewFrame> VIEW_FRAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ViewFrame").getter(SendProjectSessionActionRequest.getter(SendProjectSessionActionRequest::viewFrame)).setter(SendProjectSessionActionRequest.setter(Builder::viewFrame)).constructor(ViewFrame::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewFrame").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREVIEW_FIELD, NAME_FIELD, RECIPE_STEP_FIELD, STEP_INDEX_FIELD, CLIENT_SESSION_ID_FIELD, VIEW_FRAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Preview", PREVIEW_FIELD);
            this.put("name", NAME_FIELD);
            this.put("RecipeStep", RECIPE_STEP_FIELD);
            this.put("StepIndex", STEP_INDEX_FIELD);
            this.put("ClientSessionId", CLIENT_SESSION_ID_FIELD);
            this.put("ViewFrame", VIEW_FRAME_FIELD);
        }
    });
    private final Boolean preview;
    private final String name;
    private final RecipeStep recipeStep;
    private final Integer stepIndex;
    private final String clientSessionId;
    private final ViewFrame viewFrame;

    private SendProjectSessionActionRequest(BuilderImpl builder) {
        super(builder);
        this.preview = builder.preview;
        this.name = builder.name;
        this.recipeStep = builder.recipeStep;
        this.stepIndex = builder.stepIndex;
        this.clientSessionId = builder.clientSessionId;
        this.viewFrame = builder.viewFrame;
    }

    public final Boolean preview() {
        return this.preview;
    }

    public final String name() {
        return this.name;
    }

    public final RecipeStep recipeStep() {
        return this.recipeStep;
    }

    public final Integer stepIndex() {
        return this.stepIndex;
    }

    public final String clientSessionId() {
        return this.clientSessionId;
    }

    public final ViewFrame viewFrame() {
        return this.viewFrame;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.preview());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipeStep());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewFrame());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendProjectSessionActionRequest)) {
            return false;
        }
        SendProjectSessionActionRequest other = (SendProjectSessionActionRequest)((Object)obj);
        return Objects.equals(this.preview(), other.preview()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.recipeStep(), other.recipeStep()) && Objects.equals(this.stepIndex(), other.stepIndex()) && Objects.equals(this.clientSessionId(), other.clientSessionId()) && Objects.equals(this.viewFrame(), other.viewFrame());
    }

    public final String toString() {
        return ToString.builder((String)"SendProjectSessionActionRequest").add("Preview", (Object)this.preview()).add("Name", (Object)this.name()).add("RecipeStep", (Object)this.recipeStep()).add("StepIndex", (Object)this.stepIndex()).add("ClientSessionId", (Object)(this.clientSessionId() == null ? null : "*** Sensitive Data Redacted ***")).add("ViewFrame", (Object)this.viewFrame()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Preview": {
                return Optional.ofNullable(clazz.cast(this.preview()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RecipeStep": {
                return Optional.ofNullable(clazz.cast(this.recipeStep()));
            }
            case "StepIndex": {
                return Optional.ofNullable(clazz.cast(this.stepIndex()));
            }
            case "ClientSessionId": {
                return Optional.ofNullable(clazz.cast(this.clientSessionId()));
            }
            case "ViewFrame": {
                return Optional.ofNullable(clazz.cast(this.viewFrame()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SendProjectSessionActionRequest, T> g) {
        return obj -> g.apply((SendProjectSessionActionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataBrewRequest.BuilderImpl
    implements Builder {
        private Boolean preview;
        private String name;
        private RecipeStep recipeStep;
        private Integer stepIndex;
        private String clientSessionId;
        private ViewFrame viewFrame;

        private BuilderImpl() {
        }

        private BuilderImpl(SendProjectSessionActionRequest model) {
            super(model);
            this.preview(model.preview);
            this.name(model.name);
            this.recipeStep(model.recipeStep);
            this.stepIndex(model.stepIndex);
            this.clientSessionId(model.clientSessionId);
            this.viewFrame(model.viewFrame);
        }

        public final Boolean getPreview() {
            return this.preview;
        }

        public final void setPreview(Boolean preview) {
            this.preview = preview;
        }

        @Override
        public final Builder preview(Boolean preview) {
            this.preview = preview;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RecipeStep.Builder getRecipeStep() {
            return this.recipeStep != null ? this.recipeStep.toBuilder() : null;
        }

        public final void setRecipeStep(RecipeStep.BuilderImpl recipeStep) {
            this.recipeStep = recipeStep != null ? recipeStep.build() : null;
        }

        @Override
        public final Builder recipeStep(RecipeStep recipeStep) {
            this.recipeStep = recipeStep;
            return this;
        }

        public final Integer getStepIndex() {
            return this.stepIndex;
        }

        public final void setStepIndex(Integer stepIndex) {
            this.stepIndex = stepIndex;
        }

        @Override
        public final Builder stepIndex(Integer stepIndex) {
            this.stepIndex = stepIndex;
            return this;
        }

        public final String getClientSessionId() {
            return this.clientSessionId;
        }

        public final void setClientSessionId(String clientSessionId) {
            this.clientSessionId = clientSessionId;
        }

        @Override
        public final Builder clientSessionId(String clientSessionId) {
            this.clientSessionId = clientSessionId;
            return this;
        }

        public final ViewFrame.Builder getViewFrame() {
            return this.viewFrame != null ? this.viewFrame.toBuilder() : null;
        }

        public final void setViewFrame(ViewFrame.BuilderImpl viewFrame) {
            this.viewFrame = viewFrame != null ? viewFrame.build() : null;
        }

        @Override
        public final Builder viewFrame(ViewFrame viewFrame) {
            this.viewFrame = viewFrame;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendProjectSessionActionRequest build() {
            return new SendProjectSessionActionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataBrewRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendProjectSessionActionRequest> {
        public Builder preview(Boolean var1);

        public Builder name(String var1);

        public Builder recipeStep(RecipeStep var1);

        default public Builder recipeStep(Consumer<RecipeStep.Builder> recipeStep) {
            return this.recipeStep((RecipeStep)((RecipeStep.Builder)RecipeStep.builder().applyMutation(recipeStep)).build());
        }

        public Builder stepIndex(Integer var1);

        public Builder clientSessionId(String var1);

        public Builder viewFrame(ViewFrame var1);

        default public Builder viewFrame(Consumer<ViewFrame.Builder> viewFrame) {
            return this.viewFrame((ViewFrame)((ViewFrame.Builder)ViewFrame.builder().applyMutation(viewFrame)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

