/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatetimeOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatetimeOptions> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(DatetimeOptions.getter(DatetimeOptions::format)).setter(DatetimeOptions.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()}).build();
    private static final SdkField<String> TIMEZONE_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimezoneOffset").getter(DatetimeOptions.getter(DatetimeOptions::timezoneOffset)).setter(DatetimeOptions.setter(Builder::timezoneOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimezoneOffset").build()}).build();
    private static final SdkField<String> LOCALE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocaleCode").getter(DatetimeOptions.getter(DatetimeOptions::localeCode)).setter(DatetimeOptions.setter(Builder::localeCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocaleCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, TIMEZONE_OFFSET_FIELD, LOCALE_CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Format", FORMAT_FIELD);
            this.put("TimezoneOffset", TIMEZONE_OFFSET_FIELD);
            this.put("LocaleCode", LOCALE_CODE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String format;
    private final String timezoneOffset;
    private final String localeCode;

    private DatetimeOptions(BuilderImpl builder) {
        this.format = builder.format;
        this.timezoneOffset = builder.timezoneOffset;
        this.localeCode = builder.localeCode;
    }

    public final String format() {
        return this.format;
    }

    public final String timezoneOffset() {
        return this.timezoneOffset;
    }

    public final String localeCode() {
        return this.localeCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.format());
        hashCode = 31 * hashCode + Objects.hashCode(this.timezoneOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeCode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatetimeOptions)) {
            return false;
        }
        DatetimeOptions other = (DatetimeOptions)obj;
        return Objects.equals(this.format(), other.format()) && Objects.equals(this.timezoneOffset(), other.timezoneOffset()) && Objects.equals(this.localeCode(), other.localeCode());
    }

    public final String toString() {
        return ToString.builder((String)"DatetimeOptions").add("Format", (Object)this.format()).add("TimezoneOffset", (Object)this.timezoneOffset()).add("LocaleCode", (Object)this.localeCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.format()));
            }
            case "TimezoneOffset": {
                return Optional.ofNullable(clazz.cast(this.timezoneOffset()));
            }
            case "LocaleCode": {
                return Optional.ofNullable(clazz.cast(this.localeCode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DatetimeOptions, T> g) {
        return obj -> g.apply((DatetimeOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String format;
        private String timezoneOffset;
        private String localeCode;

        private BuilderImpl() {
        }

        private BuilderImpl(DatetimeOptions model) {
            this.format(model.format);
            this.timezoneOffset(model.timezoneOffset);
            this.localeCode(model.localeCode);
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final String getTimezoneOffset() {
            return this.timezoneOffset;
        }

        public final void setTimezoneOffset(String timezoneOffset) {
            this.timezoneOffset = timezoneOffset;
        }

        @Override
        public final Builder timezoneOffset(String timezoneOffset) {
            this.timezoneOffset = timezoneOffset;
            return this;
        }

        public final String getLocaleCode() {
            return this.localeCode;
        }

        public final void setLocaleCode(String localeCode) {
            this.localeCode = localeCode;
        }

        @Override
        public final Builder localeCode(String localeCode) {
            this.localeCode = localeCode;
            return this;
        }

        public DatetimeOptions build() {
            return new DatetimeOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatetimeOptions> {
        public Builder format(String var1);

        public Builder timezoneOffset(String var1);

        public Builder localeCode(String var1);
    }
}

