/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsResponse;

public class DescribeReplicationConfigsIterable
implements SdkIterable<DescribeReplicationConfigsResponse> {
    private final DatabaseMigrationClient client;
    private final DescribeReplicationConfigsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeReplicationConfigsIterable(DatabaseMigrationClient client, DescribeReplicationConfigsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeReplicationConfigsResponseFetcher();
    }

    public Iterator<DescribeReplicationConfigsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeReplicationConfigsResponseFetcher
    implements SyncPageFetcher<DescribeReplicationConfigsResponse> {
        private DescribeReplicationConfigsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReplicationConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeReplicationConfigsResponse nextPage(DescribeReplicationConfigsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReplicationConfigsIterable.this.client.describeReplicationConfigs(DescribeReplicationConfigsIterable.this.firstRequest);
            }
            return DescribeReplicationConfigsIterable.this.client.describeReplicationConfigs((DescribeReplicationConfigsRequest)((Object)DescribeReplicationConfigsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

