/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DataMigration;
import software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsResponse;

public class DescribeDataMigrationsIterable
implements SdkIterable<DescribeDataMigrationsResponse> {
    private final DatabaseMigrationClient client;
    private final DescribeDataMigrationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDataMigrationsIterable(DatabaseMigrationClient client, DescribeDataMigrationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeDataMigrationsResponseFetcher();
    }

    public Iterator<DescribeDataMigrationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataMigration> dataMigrations() {
        Function<DescribeDataMigrationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataMigrations() != null) {
                return response.dataMigrations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDataMigrationsResponseFetcher
    implements SyncPageFetcher<DescribeDataMigrationsResponse> {
        private DescribeDataMigrationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDataMigrationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeDataMigrationsResponse nextPage(DescribeDataMigrationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDataMigrationsIterable.this.client.describeDataMigrations(DescribeDataMigrationsIterable.this.firstRequest);
            }
            return DescribeDataMigrationsIterable.this.client.describeDataMigrations((DescribeDataMigrationsRequest)((Object)DescribeDataMigrationsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

