/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DataProviderDescriptor;
import software.amazon.awssdk.services.databasemigration.model.DataProviderDescriptorListCopier;
import software.amazon.awssdk.services.databasemigration.model.SCApplicationAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MigrationProject
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MigrationProject> {
    private static final SdkField<String> MIGRATION_PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MigrationProjectName").getter(MigrationProject.getter(MigrationProject::migrationProjectName)).setter(MigrationProject.setter(Builder::migrationProjectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationProjectName").build()}).build();
    private static final SdkField<String> MIGRATION_PROJECT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MigrationProjectArn").getter(MigrationProject.getter(MigrationProject::migrationProjectArn)).setter(MigrationProject.setter(Builder::migrationProjectArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationProjectArn").build()}).build();
    private static final SdkField<Instant> MIGRATION_PROJECT_CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("MigrationProjectCreationTime").getter(MigrationProject.getter(MigrationProject::migrationProjectCreationTime)).setter(MigrationProject.setter(Builder::migrationProjectCreationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationProjectCreationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<DataProviderDescriptor>> SOURCE_DATA_PROVIDER_DESCRIPTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourceDataProviderDescriptors").getter(MigrationProject.getter(MigrationProject::sourceDataProviderDescriptors)).setter(MigrationProject.setter(Builder::sourceDataProviderDescriptors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDataProviderDescriptors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataProviderDescriptor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataProviderDescriptor>> TARGET_DATA_PROVIDER_DESCRIPTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetDataProviderDescriptors").getter(MigrationProject.getter(MigrationProject::targetDataProviderDescriptors)).setter(MigrationProject.setter(Builder::targetDataProviderDescriptors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDataProviderDescriptors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataProviderDescriptor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INSTANCE_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceProfileArn").getter(MigrationProject.getter(MigrationProject::instanceProfileArn)).setter(MigrationProject.setter(Builder::instanceProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProfileArn").build()}).build();
    private static final SdkField<String> INSTANCE_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceProfileName").getter(MigrationProject.getter(MigrationProject::instanceProfileName)).setter(MigrationProject.setter(Builder::instanceProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProfileName").build()}).build();
    private static final SdkField<String> TRANSFORMATION_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransformationRules").getter(MigrationProject.getter(MigrationProject::transformationRules)).setter(MigrationProject.setter(Builder::transformationRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformationRules").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(MigrationProject.getter(MigrationProject::description)).setter(MigrationProject.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<SCApplicationAttributes> SCHEMA_CONVERSION_APPLICATION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SchemaConversionApplicationAttributes").getter(MigrationProject.getter(MigrationProject::schemaConversionApplicationAttributes)).setter(MigrationProject.setter(Builder::schemaConversionApplicationAttributes)).constructor(SCApplicationAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaConversionApplicationAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIGRATION_PROJECT_NAME_FIELD, MIGRATION_PROJECT_ARN_FIELD, MIGRATION_PROJECT_CREATION_TIME_FIELD, SOURCE_DATA_PROVIDER_DESCRIPTORS_FIELD, TARGET_DATA_PROVIDER_DESCRIPTORS_FIELD, INSTANCE_PROFILE_ARN_FIELD, INSTANCE_PROFILE_NAME_FIELD, TRANSFORMATION_RULES_FIELD, DESCRIPTION_FIELD, SCHEMA_CONVERSION_APPLICATION_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MigrationProjectName", MIGRATION_PROJECT_NAME_FIELD);
            this.put("MigrationProjectArn", MIGRATION_PROJECT_ARN_FIELD);
            this.put("MigrationProjectCreationTime", MIGRATION_PROJECT_CREATION_TIME_FIELD);
            this.put("SourceDataProviderDescriptors", SOURCE_DATA_PROVIDER_DESCRIPTORS_FIELD);
            this.put("TargetDataProviderDescriptors", TARGET_DATA_PROVIDER_DESCRIPTORS_FIELD);
            this.put("InstanceProfileArn", INSTANCE_PROFILE_ARN_FIELD);
            this.put("InstanceProfileName", INSTANCE_PROFILE_NAME_FIELD);
            this.put("TransformationRules", TRANSFORMATION_RULES_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("SchemaConversionApplicationAttributes", SCHEMA_CONVERSION_APPLICATION_ATTRIBUTES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String migrationProjectName;
    private final String migrationProjectArn;
    private final Instant migrationProjectCreationTime;
    private final List<DataProviderDescriptor> sourceDataProviderDescriptors;
    private final List<DataProviderDescriptor> targetDataProviderDescriptors;
    private final String instanceProfileArn;
    private final String instanceProfileName;
    private final String transformationRules;
    private final String description;
    private final SCApplicationAttributes schemaConversionApplicationAttributes;

    private MigrationProject(BuilderImpl builder) {
        this.migrationProjectName = builder.migrationProjectName;
        this.migrationProjectArn = builder.migrationProjectArn;
        this.migrationProjectCreationTime = builder.migrationProjectCreationTime;
        this.sourceDataProviderDescriptors = builder.sourceDataProviderDescriptors;
        this.targetDataProviderDescriptors = builder.targetDataProviderDescriptors;
        this.instanceProfileArn = builder.instanceProfileArn;
        this.instanceProfileName = builder.instanceProfileName;
        this.transformationRules = builder.transformationRules;
        this.description = builder.description;
        this.schemaConversionApplicationAttributes = builder.schemaConversionApplicationAttributes;
    }

    public final String migrationProjectName() {
        return this.migrationProjectName;
    }

    public final String migrationProjectArn() {
        return this.migrationProjectArn;
    }

    public final Instant migrationProjectCreationTime() {
        return this.migrationProjectCreationTime;
    }

    public final boolean hasSourceDataProviderDescriptors() {
        return this.sourceDataProviderDescriptors != null && !(this.sourceDataProviderDescriptors instanceof SdkAutoConstructList);
    }

    public final List<DataProviderDescriptor> sourceDataProviderDescriptors() {
        return this.sourceDataProviderDescriptors;
    }

    public final boolean hasTargetDataProviderDescriptors() {
        return this.targetDataProviderDescriptors != null && !(this.targetDataProviderDescriptors instanceof SdkAutoConstructList);
    }

    public final List<DataProviderDescriptor> targetDataProviderDescriptors() {
        return this.targetDataProviderDescriptors;
    }

    public final String instanceProfileArn() {
        return this.instanceProfileArn;
    }

    public final String instanceProfileName() {
        return this.instanceProfileName;
    }

    public final String transformationRules() {
        return this.transformationRules;
    }

    public final String description() {
        return this.description;
    }

    public final SCApplicationAttributes schemaConversionApplicationAttributes() {
        return this.schemaConversionApplicationAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationProjectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationProjectArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationProjectCreationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceDataProviderDescriptors() ? this.sourceDataProviderDescriptors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetDataProviderDescriptors() ? this.targetDataProviderDescriptors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformationRules());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaConversionApplicationAttributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MigrationProject)) {
            return false;
        }
        MigrationProject other = (MigrationProject)obj;
        return Objects.equals(this.migrationProjectName(), other.migrationProjectName()) && Objects.equals(this.migrationProjectArn(), other.migrationProjectArn()) && Objects.equals(this.migrationProjectCreationTime(), other.migrationProjectCreationTime()) && this.hasSourceDataProviderDescriptors() == other.hasSourceDataProviderDescriptors() && Objects.equals(this.sourceDataProviderDescriptors(), other.sourceDataProviderDescriptors()) && this.hasTargetDataProviderDescriptors() == other.hasTargetDataProviderDescriptors() && Objects.equals(this.targetDataProviderDescriptors(), other.targetDataProviderDescriptors()) && Objects.equals(this.instanceProfileArn(), other.instanceProfileArn()) && Objects.equals(this.instanceProfileName(), other.instanceProfileName()) && Objects.equals(this.transformationRules(), other.transformationRules()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.schemaConversionApplicationAttributes(), other.schemaConversionApplicationAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"MigrationProject").add("MigrationProjectName", (Object)this.migrationProjectName()).add("MigrationProjectArn", (Object)this.migrationProjectArn()).add("MigrationProjectCreationTime", (Object)this.migrationProjectCreationTime()).add("SourceDataProviderDescriptors", this.hasSourceDataProviderDescriptors() ? this.sourceDataProviderDescriptors() : null).add("TargetDataProviderDescriptors", this.hasTargetDataProviderDescriptors() ? this.targetDataProviderDescriptors() : null).add("InstanceProfileArn", (Object)this.instanceProfileArn()).add("InstanceProfileName", (Object)this.instanceProfileName()).add("TransformationRules", (Object)this.transformationRules()).add("Description", (Object)this.description()).add("SchemaConversionApplicationAttributes", (Object)this.schemaConversionApplicationAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MigrationProjectName": {
                return Optional.ofNullable(clazz.cast(this.migrationProjectName()));
            }
            case "MigrationProjectArn": {
                return Optional.ofNullable(clazz.cast(this.migrationProjectArn()));
            }
            case "MigrationProjectCreationTime": {
                return Optional.ofNullable(clazz.cast(this.migrationProjectCreationTime()));
            }
            case "SourceDataProviderDescriptors": {
                return Optional.ofNullable(clazz.cast(this.sourceDataProviderDescriptors()));
            }
            case "TargetDataProviderDescriptors": {
                return Optional.ofNullable(clazz.cast(this.targetDataProviderDescriptors()));
            }
            case "InstanceProfileArn": {
                return Optional.ofNullable(clazz.cast(this.instanceProfileArn()));
            }
            case "InstanceProfileName": {
                return Optional.ofNullable(clazz.cast(this.instanceProfileName()));
            }
            case "TransformationRules": {
                return Optional.ofNullable(clazz.cast(this.transformationRules()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "SchemaConversionApplicationAttributes": {
                return Optional.ofNullable(clazz.cast(this.schemaConversionApplicationAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MigrationProject, T> g) {
        return obj -> g.apply((MigrationProject)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String migrationProjectName;
        private String migrationProjectArn;
        private Instant migrationProjectCreationTime;
        private List<DataProviderDescriptor> sourceDataProviderDescriptors = DefaultSdkAutoConstructList.getInstance();
        private List<DataProviderDescriptor> targetDataProviderDescriptors = DefaultSdkAutoConstructList.getInstance();
        private String instanceProfileArn;
        private String instanceProfileName;
        private String transformationRules;
        private String description;
        private SCApplicationAttributes schemaConversionApplicationAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(MigrationProject model) {
            this.migrationProjectName(model.migrationProjectName);
            this.migrationProjectArn(model.migrationProjectArn);
            this.migrationProjectCreationTime(model.migrationProjectCreationTime);
            this.sourceDataProviderDescriptors(model.sourceDataProviderDescriptors);
            this.targetDataProviderDescriptors(model.targetDataProviderDescriptors);
            this.instanceProfileArn(model.instanceProfileArn);
            this.instanceProfileName(model.instanceProfileName);
            this.transformationRules(model.transformationRules);
            this.description(model.description);
            this.schemaConversionApplicationAttributes(model.schemaConversionApplicationAttributes);
        }

        public final String getMigrationProjectName() {
            return this.migrationProjectName;
        }

        public final void setMigrationProjectName(String migrationProjectName) {
            this.migrationProjectName = migrationProjectName;
        }

        @Override
        public final Builder migrationProjectName(String migrationProjectName) {
            this.migrationProjectName = migrationProjectName;
            return this;
        }

        public final String getMigrationProjectArn() {
            return this.migrationProjectArn;
        }

        public final void setMigrationProjectArn(String migrationProjectArn) {
            this.migrationProjectArn = migrationProjectArn;
        }

        @Override
        public final Builder migrationProjectArn(String migrationProjectArn) {
            this.migrationProjectArn = migrationProjectArn;
            return this;
        }

        public final Instant getMigrationProjectCreationTime() {
            return this.migrationProjectCreationTime;
        }

        public final void setMigrationProjectCreationTime(Instant migrationProjectCreationTime) {
            this.migrationProjectCreationTime = migrationProjectCreationTime;
        }

        @Override
        public final Builder migrationProjectCreationTime(Instant migrationProjectCreationTime) {
            this.migrationProjectCreationTime = migrationProjectCreationTime;
            return this;
        }

        public final List<DataProviderDescriptor.Builder> getSourceDataProviderDescriptors() {
            List<DataProviderDescriptor.Builder> result = DataProviderDescriptorListCopier.copyToBuilder(this.sourceDataProviderDescriptors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceDataProviderDescriptors(Collection<DataProviderDescriptor.BuilderImpl> sourceDataProviderDescriptors) {
            this.sourceDataProviderDescriptors = DataProviderDescriptorListCopier.copyFromBuilder(sourceDataProviderDescriptors);
        }

        @Override
        public final Builder sourceDataProviderDescriptors(Collection<DataProviderDescriptor> sourceDataProviderDescriptors) {
            this.sourceDataProviderDescriptors = DataProviderDescriptorListCopier.copy(sourceDataProviderDescriptors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceDataProviderDescriptors(DataProviderDescriptor ... sourceDataProviderDescriptors) {
            this.sourceDataProviderDescriptors(Arrays.asList(sourceDataProviderDescriptors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceDataProviderDescriptors(Consumer<DataProviderDescriptor.Builder> ... sourceDataProviderDescriptors) {
            this.sourceDataProviderDescriptors(Stream.of(sourceDataProviderDescriptors).map(c -> (DataProviderDescriptor)((DataProviderDescriptor.Builder)DataProviderDescriptor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataProviderDescriptor.Builder> getTargetDataProviderDescriptors() {
            List<DataProviderDescriptor.Builder> result = DataProviderDescriptorListCopier.copyToBuilder(this.targetDataProviderDescriptors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetDataProviderDescriptors(Collection<DataProviderDescriptor.BuilderImpl> targetDataProviderDescriptors) {
            this.targetDataProviderDescriptors = DataProviderDescriptorListCopier.copyFromBuilder(targetDataProviderDescriptors);
        }

        @Override
        public final Builder targetDataProviderDescriptors(Collection<DataProviderDescriptor> targetDataProviderDescriptors) {
            this.targetDataProviderDescriptors = DataProviderDescriptorListCopier.copy(targetDataProviderDescriptors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetDataProviderDescriptors(DataProviderDescriptor ... targetDataProviderDescriptors) {
            this.targetDataProviderDescriptors(Arrays.asList(targetDataProviderDescriptors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetDataProviderDescriptors(Consumer<DataProviderDescriptor.Builder> ... targetDataProviderDescriptors) {
            this.targetDataProviderDescriptors(Stream.of(targetDataProviderDescriptors).map(c -> (DataProviderDescriptor)((DataProviderDescriptor.Builder)DataProviderDescriptor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInstanceProfileArn() {
            return this.instanceProfileArn;
        }

        public final void setInstanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
        }

        @Override
        public final Builder instanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
            return this;
        }

        public final String getInstanceProfileName() {
            return this.instanceProfileName;
        }

        public final void setInstanceProfileName(String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
        }

        @Override
        public final Builder instanceProfileName(String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
            return this;
        }

        public final String getTransformationRules() {
            return this.transformationRules;
        }

        public final void setTransformationRules(String transformationRules) {
            this.transformationRules = transformationRules;
        }

        @Override
        public final Builder transformationRules(String transformationRules) {
            this.transformationRules = transformationRules;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final SCApplicationAttributes.Builder getSchemaConversionApplicationAttributes() {
            return this.schemaConversionApplicationAttributes != null ? this.schemaConversionApplicationAttributes.toBuilder() : null;
        }

        public final void setSchemaConversionApplicationAttributes(SCApplicationAttributes.BuilderImpl schemaConversionApplicationAttributes) {
            this.schemaConversionApplicationAttributes = schemaConversionApplicationAttributes != null ? schemaConversionApplicationAttributes.build() : null;
        }

        @Override
        public final Builder schemaConversionApplicationAttributes(SCApplicationAttributes schemaConversionApplicationAttributes) {
            this.schemaConversionApplicationAttributes = schemaConversionApplicationAttributes;
            return this;
        }

        public MigrationProject build() {
            return new MigrationProject(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MigrationProject> {
        public Builder migrationProjectName(String var1);

        public Builder migrationProjectArn(String var1);

        public Builder migrationProjectCreationTime(Instant var1);

        public Builder sourceDataProviderDescriptors(Collection<DataProviderDescriptor> var1);

        public Builder sourceDataProviderDescriptors(DataProviderDescriptor ... var1);

        public Builder sourceDataProviderDescriptors(Consumer<DataProviderDescriptor.Builder> ... var1);

        public Builder targetDataProviderDescriptors(Collection<DataProviderDescriptor> var1);

        public Builder targetDataProviderDescriptors(DataProviderDescriptor ... var1);

        public Builder targetDataProviderDescriptors(Consumer<DataProviderDescriptor.Builder> ... var1);

        public Builder instanceProfileArn(String var1);

        public Builder instanceProfileName(String var1);

        public Builder transformationRules(String var1);

        public Builder description(String var1);

        public Builder schemaConversionApplicationAttributes(SCApplicationAttributes var1);

        default public Builder schemaConversionApplicationAttributes(Consumer<SCApplicationAttributes.Builder> schemaConversionApplicationAttributes) {
            return this.schemaConversionApplicationAttributes((SCApplicationAttributes)((SCApplicationAttributes.Builder)SCApplicationAttributes.builder().applyMutation(schemaConversionApplicationAttributes)).build());
        }
    }
}

