/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.ExportingLocation;
import software.amazon.awssdk.services.customerprofiles.model.IdentityResolutionJobStatus;
import software.amazon.awssdk.services.customerprofiles.model.JobStats;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IdentityResolutionJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IdentityResolutionJob> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(IdentityResolutionJob.getter(IdentityResolutionJob::domainName)).setter(IdentityResolutionJob.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(IdentityResolutionJob.getter(IdentityResolutionJob::jobId)).setter(IdentityResolutionJob.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(IdentityResolutionJob.getter(IdentityResolutionJob::statusAsString)).setter(IdentityResolutionJob.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> JOB_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("JobStartTime").getter(IdentityResolutionJob.getter(IdentityResolutionJob::jobStartTime)).setter(IdentityResolutionJob.setter(Builder::jobStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStartTime").build()}).build();
    private static final SdkField<Instant> JOB_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("JobEndTime").getter(IdentityResolutionJob.getter(IdentityResolutionJob::jobEndTime)).setter(IdentityResolutionJob.setter(Builder::jobEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobEndTime").build()}).build();
    private static final SdkField<JobStats> JOB_STATS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JobStats").getter(IdentityResolutionJob.getter(IdentityResolutionJob::jobStats)).setter(IdentityResolutionJob.setter(Builder::jobStats)).constructor(JobStats::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStats").build()}).build();
    private static final SdkField<ExportingLocation> EXPORTING_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExportingLocation").getter(IdentityResolutionJob.getter(IdentityResolutionJob::exportingLocation)).setter(IdentityResolutionJob.setter(Builder::exportingLocation)).constructor(ExportingLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportingLocation").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(IdentityResolutionJob.getter(IdentityResolutionJob::message)).setter(IdentityResolutionJob.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, JOB_ID_FIELD, STATUS_FIELD, JOB_START_TIME_FIELD, JOB_END_TIME_FIELD, JOB_STATS_FIELD, EXPORTING_LOCATION_FIELD, MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DomainName", DOMAIN_NAME_FIELD);
            this.put("JobId", JOB_ID_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("JobStartTime", JOB_START_TIME_FIELD);
            this.put("JobEndTime", JOB_END_TIME_FIELD);
            this.put("JobStats", JOB_STATS_FIELD);
            this.put("ExportingLocation", EXPORTING_LOCATION_FIELD);
            this.put("Message", MESSAGE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String domainName;
    private final String jobId;
    private final String status;
    private final Instant jobStartTime;
    private final Instant jobEndTime;
    private final JobStats jobStats;
    private final ExportingLocation exportingLocation;
    private final String message;

    private IdentityResolutionJob(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.jobId = builder.jobId;
        this.status = builder.status;
        this.jobStartTime = builder.jobStartTime;
        this.jobEndTime = builder.jobEndTime;
        this.jobStats = builder.jobStats;
        this.exportingLocation = builder.exportingLocation;
        this.message = builder.message;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final IdentityResolutionJobStatus status() {
        return IdentityResolutionJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant jobStartTime() {
        return this.jobStartTime;
    }

    public final Instant jobEndTime() {
        return this.jobEndTime;
    }

    public final JobStats jobStats() {
        return this.jobStats;
    }

    public final ExportingLocation exportingLocation() {
        return this.exportingLocation;
    }

    public final String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStats());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportingLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityResolutionJob)) {
            return false;
        }
        IdentityResolutionJob other = (IdentityResolutionJob)obj;
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.jobStartTime(), other.jobStartTime()) && Objects.equals(this.jobEndTime(), other.jobEndTime()) && Objects.equals(this.jobStats(), other.jobStats()) && Objects.equals(this.exportingLocation(), other.exportingLocation()) && Objects.equals(this.message(), other.message());
    }

    public final String toString() {
        return ToString.builder((String)"IdentityResolutionJob").add("DomainName", (Object)this.domainName()).add("JobId", (Object)this.jobId()).add("Status", (Object)this.statusAsString()).add("JobStartTime", (Object)this.jobStartTime()).add("JobEndTime", (Object)this.jobEndTime()).add("JobStats", (Object)this.jobStats()).add("ExportingLocation", (Object)this.exportingLocation()).add("Message", (Object)this.message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "JobStartTime": {
                return Optional.ofNullable(clazz.cast(this.jobStartTime()));
            }
            case "JobEndTime": {
                return Optional.ofNullable(clazz.cast(this.jobEndTime()));
            }
            case "JobStats": {
                return Optional.ofNullable(clazz.cast(this.jobStats()));
            }
            case "ExportingLocation": {
                return Optional.ofNullable(clazz.cast(this.exportingLocation()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IdentityResolutionJob, T> g) {
        return obj -> g.apply((IdentityResolutionJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String jobId;
        private String status;
        private Instant jobStartTime;
        private Instant jobEndTime;
        private JobStats jobStats;
        private ExportingLocation exportingLocation;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityResolutionJob model) {
            this.domainName(model.domainName);
            this.jobId(model.jobId);
            this.status(model.status);
            this.jobStartTime(model.jobStartTime);
            this.jobEndTime(model.jobEndTime);
            this.jobStats(model.jobStats);
            this.exportingLocation(model.exportingLocation);
            this.message(model.message);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IdentityResolutionJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getJobStartTime() {
            return this.jobStartTime;
        }

        public final void setJobStartTime(Instant jobStartTime) {
            this.jobStartTime = jobStartTime;
        }

        @Override
        public final Builder jobStartTime(Instant jobStartTime) {
            this.jobStartTime = jobStartTime;
            return this;
        }

        public final Instant getJobEndTime() {
            return this.jobEndTime;
        }

        public final void setJobEndTime(Instant jobEndTime) {
            this.jobEndTime = jobEndTime;
        }

        @Override
        public final Builder jobEndTime(Instant jobEndTime) {
            this.jobEndTime = jobEndTime;
            return this;
        }

        public final JobStats.Builder getJobStats() {
            return this.jobStats != null ? this.jobStats.toBuilder() : null;
        }

        public final void setJobStats(JobStats.BuilderImpl jobStats) {
            this.jobStats = jobStats != null ? jobStats.build() : null;
        }

        @Override
        public final Builder jobStats(JobStats jobStats) {
            this.jobStats = jobStats;
            return this;
        }

        public final ExportingLocation.Builder getExportingLocation() {
            return this.exportingLocation != null ? this.exportingLocation.toBuilder() : null;
        }

        public final void setExportingLocation(ExportingLocation.BuilderImpl exportingLocation) {
            this.exportingLocation = exportingLocation != null ? exportingLocation.build() : null;
        }

        @Override
        public final Builder exportingLocation(ExportingLocation exportingLocation) {
            this.exportingLocation = exportingLocation;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public IdentityResolutionJob build() {
            return new IdentityResolutionJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IdentityResolutionJob> {
        public Builder domainName(String var1);

        public Builder jobId(String var1);

        public Builder status(String var1);

        public Builder status(IdentityResolutionJobStatus var1);

        public Builder jobStartTime(Instant var1);

        public Builder jobEndTime(Instant var1);

        public Builder jobStats(JobStats var1);

        default public Builder jobStats(Consumer<JobStats.Builder> jobStats) {
            return this.jobStats((JobStats)((JobStats.Builder)JobStats.builder().applyMutation(jobStats)).build());
        }

        public Builder exportingLocation(ExportingLocation var1);

        default public Builder exportingLocation(Consumer<ExportingLocation.Builder> exportingLocation) {
            return this.exportingLocation((ExportingLocation)((ExportingLocation.Builder)ExportingLocation.builder().applyMutation(exportingLocation)).build());
        }

        public Builder message(String var1);
    }
}

