/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSegmentEstimateResponse
extends CustomerProfilesResponse
implements ToCopyableBuilder<Builder, CreateSegmentEstimateResponse> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(CreateSegmentEstimateResponse.getter(CreateSegmentEstimateResponse::domainName)).setter(CreateSegmentEstimateResponse.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> ESTIMATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimateId").getter(CreateSegmentEstimateResponse.getter(CreateSegmentEstimateResponse::estimateId)).setter(CreateSegmentEstimateResponse.setter(Builder::estimateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimateId").build()}).build();
    private static final SdkField<Integer> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StatusCode").getter(CreateSegmentEstimateResponse.getter(CreateSegmentEstimateResponse::statusCode)).setter(CreateSegmentEstimateResponse.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("StatusCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, ESTIMATE_ID_FIELD, STATUS_CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DomainName", DOMAIN_NAME_FIELD);
            this.put("EstimateId", ESTIMATE_ID_FIELD);
            this.put("StatusCode", STATUS_CODE_FIELD);
        }
    });
    private final String domainName;
    private final String estimateId;
    private final Integer statusCode;

    private CreateSegmentEstimateResponse(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.estimateId = builder.estimateId;
        this.statusCode = builder.statusCode;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String estimateId() {
        return this.estimateId;
    }

    public final Integer statusCode() {
        return this.statusCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSegmentEstimateResponse)) {
            return false;
        }
        CreateSegmentEstimateResponse other = (CreateSegmentEstimateResponse)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.estimateId(), other.estimateId()) && Objects.equals(this.statusCode(), other.statusCode());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSegmentEstimateResponse").add("DomainName", (Object)this.domainName()).add("EstimateId", (Object)this.estimateId()).add("StatusCode", (Object)this.statusCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "EstimateId": {
                return Optional.ofNullable(clazz.cast(this.estimateId()));
            }
            case "StatusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateSegmentEstimateResponse, T> g) {
        return obj -> g.apply((CreateSegmentEstimateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesResponse.BuilderImpl
    implements Builder {
        private String domainName;
        private String estimateId;
        private Integer statusCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSegmentEstimateResponse model) {
            super(model);
            this.domainName(model.domainName);
            this.estimateId(model.estimateId);
            this.statusCode(model.statusCode);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getEstimateId() {
            return this.estimateId;
        }

        public final void setEstimateId(String estimateId) {
            this.estimateId = estimateId;
        }

        @Override
        public final Builder estimateId(String estimateId) {
            this.estimateId = estimateId;
            return this;
        }

        public final Integer getStatusCode() {
            return this.statusCode;
        }

        public final void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public CreateSegmentEstimateResponse build() {
            return new CreateSegmentEstimateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CustomerProfilesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSegmentEstimateResponse> {
        public Builder domainName(String var1);

        public Builder estimateId(String var1);

        public Builder statusCode(Integer var1);
    }
}

