/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.ApproximationDimension;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerRequest;
import software.amazon.awssdk.services.costexplorer.model.Granularity;
import software.amazon.awssdk.services.costexplorer.model.UsageServicesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetApproximateUsageRecordsRequest
extends CostExplorerRequest
implements ToCopyableBuilder<Builder, GetApproximateUsageRecordsRequest> {
    private static final SdkField<String> GRANULARITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Granularity").getter(GetApproximateUsageRecordsRequest.getter(GetApproximateUsageRecordsRequest::granularityAsString)).setter(GetApproximateUsageRecordsRequest.setter(Builder::granularity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Granularity").build()}).build();
    private static final SdkField<List<String>> SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Services").getter(GetApproximateUsageRecordsRequest.getter(GetApproximateUsageRecordsRequest::services)).setter(GetApproximateUsageRecordsRequest.setter(Builder::services)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Services").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> APPROXIMATION_DIMENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApproximationDimension").getter(GetApproximateUsageRecordsRequest.getter(GetApproximateUsageRecordsRequest::approximationDimensionAsString)).setter(GetApproximateUsageRecordsRequest.setter(Builder::approximationDimension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximationDimension").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRANULARITY_FIELD, SERVICES_FIELD, APPROXIMATION_DIMENSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Granularity", GRANULARITY_FIELD);
            this.put("Services", SERVICES_FIELD);
            this.put("ApproximationDimension", APPROXIMATION_DIMENSION_FIELD);
        }
    });
    private final String granularity;
    private final List<String> services;
    private final String approximationDimension;

    private GetApproximateUsageRecordsRequest(BuilderImpl builder) {
        super(builder);
        this.granularity = builder.granularity;
        this.services = builder.services;
        this.approximationDimension = builder.approximationDimension;
    }

    public final Granularity granularity() {
        return Granularity.fromValue(this.granularity);
    }

    public final String granularityAsString() {
        return this.granularity;
    }

    public final boolean hasServices() {
        return this.services != null && !(this.services instanceof SdkAutoConstructList);
    }

    public final List<String> services() {
        return this.services;
    }

    public final ApproximationDimension approximationDimension() {
        return ApproximationDimension.fromValue(this.approximationDimension);
    }

    public final String approximationDimensionAsString() {
        return this.approximationDimension;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.granularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServices() ? this.services() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.approximationDimensionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApproximateUsageRecordsRequest)) {
            return false;
        }
        GetApproximateUsageRecordsRequest other = (GetApproximateUsageRecordsRequest)((Object)obj);
        return Objects.equals(this.granularityAsString(), other.granularityAsString()) && this.hasServices() == other.hasServices() && Objects.equals(this.services(), other.services()) && Objects.equals(this.approximationDimensionAsString(), other.approximationDimensionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetApproximateUsageRecordsRequest").add("Granularity", (Object)this.granularityAsString()).add("Services", this.hasServices() ? this.services() : null).add("ApproximationDimension", (Object)this.approximationDimensionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Granularity": {
                return Optional.ofNullable(clazz.cast(this.granularityAsString()));
            }
            case "Services": {
                return Optional.ofNullable(clazz.cast(this.services()));
            }
            case "ApproximationDimension": {
                return Optional.ofNullable(clazz.cast(this.approximationDimensionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetApproximateUsageRecordsRequest, T> g) {
        return obj -> g.apply((GetApproximateUsageRecordsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerRequest.BuilderImpl
    implements Builder {
        private String granularity;
        private List<String> services = DefaultSdkAutoConstructList.getInstance();
        private String approximationDimension;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApproximateUsageRecordsRequest model) {
            super(model);
            this.granularity(model.granularity);
            this.services(model.services);
            this.approximationDimension(model.approximationDimension);
        }

        public final String getGranularity() {
            return this.granularity;
        }

        public final void setGranularity(String granularity) {
            this.granularity = granularity;
        }

        @Override
        public final Builder granularity(String granularity) {
            this.granularity = granularity;
            return this;
        }

        @Override
        public final Builder granularity(Granularity granularity) {
            this.granularity(granularity == null ? null : granularity.toString());
            return this;
        }

        public final Collection<String> getServices() {
            if (this.services instanceof SdkAutoConstructList) {
                return null;
            }
            return this.services;
        }

        public final void setServices(Collection<String> services) {
            this.services = UsageServicesCopier.copy(services);
        }

        @Override
        public final Builder services(Collection<String> services) {
            this.services = UsageServicesCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(String ... services) {
            this.services(Arrays.asList(services));
            return this;
        }

        public final String getApproximationDimension() {
            return this.approximationDimension;
        }

        public final void setApproximationDimension(String approximationDimension) {
            this.approximationDimension = approximationDimension;
        }

        @Override
        public final Builder approximationDimension(String approximationDimension) {
            this.approximationDimension = approximationDimension;
            return this;
        }

        @Override
        public final Builder approximationDimension(ApproximationDimension approximationDimension) {
            this.approximationDimension(approximationDimension == null ? null : approximationDimension.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetApproximateUsageRecordsRequest build() {
            return new GetApproximateUsageRecordsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CostExplorerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetApproximateUsageRecordsRequest> {
        public Builder granularity(String var1);

        public Builder granularity(Granularity var1);

        public Builder services(Collection<String> var1);

        public Builder services(String ... var1);

        public Builder approximationDimension(String var1);

        public Builder approximationDimension(ApproximationDimension var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

