/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.CostCategoryRule;
import software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleVersion;
import software.amazon.awssdk.services.costexplorer.model.CostCategoryRulesListCopier;
import software.amazon.awssdk.services.costexplorer.model.CostCategorySplitChargeRule;
import software.amazon.awssdk.services.costexplorer.model.CostCategorySplitChargeRulesListCopier;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerRequest;
import software.amazon.awssdk.services.costexplorer.model.ResourceTag;
import software.amazon.awssdk.services.costexplorer.model.ResourceTagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCostCategoryDefinitionRequest
extends CostExplorerRequest
implements ToCopyableBuilder<Builder, CreateCostCategoryDefinitionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateCostCategoryDefinitionRequest.getter(CreateCostCategoryDefinitionRequest::name)).setter(CreateCostCategoryDefinitionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> EFFECTIVE_START_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EffectiveStart").getter(CreateCostCategoryDefinitionRequest.getter(CreateCostCategoryDefinitionRequest::effectiveStart)).setter(CreateCostCategoryDefinitionRequest.setter(Builder::effectiveStart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveStart").build()}).build();
    private static final SdkField<String> RULE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleVersion").getter(CreateCostCategoryDefinitionRequest.getter(CreateCostCategoryDefinitionRequest::ruleVersionAsString)).setter(CreateCostCategoryDefinitionRequest.setter(Builder::ruleVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleVersion").build()}).build();
    private static final SdkField<List<CostCategoryRule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rules").getter(CreateCostCategoryDefinitionRequest.getter(CreateCostCategoryDefinitionRequest::rules)).setter(CreateCostCategoryDefinitionRequest.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CostCategoryRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultValue").getter(CreateCostCategoryDefinitionRequest.getter(CreateCostCategoryDefinitionRequest::defaultValue)).setter(CreateCostCategoryDefinitionRequest.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()}).build();
    private static final SdkField<List<CostCategorySplitChargeRule>> SPLIT_CHARGE_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SplitChargeRules").getter(CreateCostCategoryDefinitionRequest.getter(CreateCostCategoryDefinitionRequest::splitChargeRules)).setter(CreateCostCategoryDefinitionRequest.setter(Builder::splitChargeRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SplitChargeRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CostCategorySplitChargeRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourceTag>> RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTags").getter(CreateCostCategoryDefinitionRequest.getter(CreateCostCategoryDefinitionRequest::resourceTags)).setter(CreateCostCategoryDefinitionRequest.setter(Builder::resourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, EFFECTIVE_START_FIELD, RULE_VERSION_FIELD, RULES_FIELD, DEFAULT_VALUE_FIELD, SPLIT_CHARGE_RULES_FIELD, RESOURCE_TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("EffectiveStart", EFFECTIVE_START_FIELD);
            this.put("RuleVersion", RULE_VERSION_FIELD);
            this.put("Rules", RULES_FIELD);
            this.put("DefaultValue", DEFAULT_VALUE_FIELD);
            this.put("SplitChargeRules", SPLIT_CHARGE_RULES_FIELD);
            this.put("ResourceTags", RESOURCE_TAGS_FIELD);
        }
    });
    private final String name;
    private final String effectiveStart;
    private final String ruleVersion;
    private final List<CostCategoryRule> rules;
    private final String defaultValue;
    private final List<CostCategorySplitChargeRule> splitChargeRules;
    private final List<ResourceTag> resourceTags;

    private CreateCostCategoryDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.effectiveStart = builder.effectiveStart;
        this.ruleVersion = builder.ruleVersion;
        this.rules = builder.rules;
        this.defaultValue = builder.defaultValue;
        this.splitChargeRules = builder.splitChargeRules;
        this.resourceTags = builder.resourceTags;
    }

    public final String name() {
        return this.name;
    }

    public final String effectiveStart() {
        return this.effectiveStart;
    }

    public final CostCategoryRuleVersion ruleVersion() {
        return CostCategoryRuleVersion.fromValue(this.ruleVersion);
    }

    public final String ruleVersionAsString() {
        return this.ruleVersion;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<CostCategoryRule> rules() {
        return this.rules;
    }

    public final String defaultValue() {
        return this.defaultValue;
    }

    public final boolean hasSplitChargeRules() {
        return this.splitChargeRules != null && !(this.splitChargeRules instanceof SdkAutoConstructList);
    }

    public final List<CostCategorySplitChargeRule> splitChargeRules() {
        return this.splitChargeRules;
    }

    public final boolean hasResourceTags() {
        return this.resourceTags != null && !(this.resourceTags instanceof SdkAutoConstructList);
    }

    public final List<ResourceTag> resourceTags() {
        return this.resourceTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveStart());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSplitChargeRules() ? this.splitChargeRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTags() ? this.resourceTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCostCategoryDefinitionRequest)) {
            return false;
        }
        CreateCostCategoryDefinitionRequest other = (CreateCostCategoryDefinitionRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.effectiveStart(), other.effectiveStart()) && Objects.equals(this.ruleVersionAsString(), other.ruleVersionAsString()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules()) && Objects.equals(this.defaultValue(), other.defaultValue()) && this.hasSplitChargeRules() == other.hasSplitChargeRules() && Objects.equals(this.splitChargeRules(), other.splitChargeRules()) && this.hasResourceTags() == other.hasResourceTags() && Objects.equals(this.resourceTags(), other.resourceTags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCostCategoryDefinitionRequest").add("Name", (Object)this.name()).add("EffectiveStart", (Object)this.effectiveStart()).add("RuleVersion", (Object)this.ruleVersionAsString()).add("Rules", this.hasRules() ? this.rules() : null).add("DefaultValue", (Object)this.defaultValue()).add("SplitChargeRules", this.hasSplitChargeRules() ? this.splitChargeRules() : null).add("ResourceTags", this.hasResourceTags() ? this.resourceTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "EffectiveStart": {
                return Optional.ofNullable(clazz.cast(this.effectiveStart()));
            }
            case "RuleVersion": {
                return Optional.ofNullable(clazz.cast(this.ruleVersionAsString()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
            case "DefaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "SplitChargeRules": {
                return Optional.ofNullable(clazz.cast(this.splitChargeRules()));
            }
            case "ResourceTags": {
                return Optional.ofNullable(clazz.cast(this.resourceTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateCostCategoryDefinitionRequest, T> g) {
        return obj -> g.apply((CreateCostCategoryDefinitionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerRequest.BuilderImpl
    implements Builder {
        private String name;
        private String effectiveStart;
        private String ruleVersion;
        private List<CostCategoryRule> rules = DefaultSdkAutoConstructList.getInstance();
        private String defaultValue;
        private List<CostCategorySplitChargeRule> splitChargeRules = DefaultSdkAutoConstructList.getInstance();
        private List<ResourceTag> resourceTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCostCategoryDefinitionRequest model) {
            super(model);
            this.name(model.name);
            this.effectiveStart(model.effectiveStart);
            this.ruleVersion(model.ruleVersion);
            this.rules(model.rules);
            this.defaultValue(model.defaultValue);
            this.splitChargeRules(model.splitChargeRules);
            this.resourceTags(model.resourceTags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEffectiveStart() {
            return this.effectiveStart;
        }

        public final void setEffectiveStart(String effectiveStart) {
            this.effectiveStart = effectiveStart;
        }

        @Override
        public final Builder effectiveStart(String effectiveStart) {
            this.effectiveStart = effectiveStart;
            return this;
        }

        public final String getRuleVersion() {
            return this.ruleVersion;
        }

        public final void setRuleVersion(String ruleVersion) {
            this.ruleVersion = ruleVersion;
        }

        @Override
        public final Builder ruleVersion(String ruleVersion) {
            this.ruleVersion = ruleVersion;
            return this;
        }

        @Override
        public final Builder ruleVersion(CostCategoryRuleVersion ruleVersion) {
            this.ruleVersion(ruleVersion == null ? null : ruleVersion.toString());
            return this;
        }

        public final List<CostCategoryRule.Builder> getRules() {
            List<CostCategoryRule.Builder> result = CostCategoryRulesListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<CostCategoryRule.BuilderImpl> rules) {
            this.rules = CostCategoryRulesListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<CostCategoryRule> rules) {
            this.rules = CostCategoryRulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(CostCategoryRule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<CostCategoryRule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (CostCategoryRule)((CostCategoryRule.Builder)CostCategoryRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final List<CostCategorySplitChargeRule.Builder> getSplitChargeRules() {
            List<CostCategorySplitChargeRule.Builder> result = CostCategorySplitChargeRulesListCopier.copyToBuilder(this.splitChargeRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSplitChargeRules(Collection<CostCategorySplitChargeRule.BuilderImpl> splitChargeRules) {
            this.splitChargeRules = CostCategorySplitChargeRulesListCopier.copyFromBuilder(splitChargeRules);
        }

        @Override
        public final Builder splitChargeRules(Collection<CostCategorySplitChargeRule> splitChargeRules) {
            this.splitChargeRules = CostCategorySplitChargeRulesListCopier.copy(splitChargeRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder splitChargeRules(CostCategorySplitChargeRule ... splitChargeRules) {
            this.splitChargeRules(Arrays.asList(splitChargeRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder splitChargeRules(Consumer<CostCategorySplitChargeRule.Builder> ... splitChargeRules) {
            this.splitChargeRules(Stream.of(splitChargeRules).map(c -> (CostCategorySplitChargeRule)((CostCategorySplitChargeRule.Builder)CostCategorySplitChargeRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ResourceTag.Builder> getResourceTags() {
            List<ResourceTag.Builder> result = ResourceTagListCopier.copyToBuilder(this.resourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTags(Collection<ResourceTag.BuilderImpl> resourceTags) {
            this.resourceTags = ResourceTagListCopier.copyFromBuilder(resourceTags);
        }

        @Override
        public final Builder resourceTags(Collection<ResourceTag> resourceTags) {
            this.resourceTags = ResourceTagListCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(ResourceTag ... resourceTags) {
            this.resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<ResourceTag.Builder> ... resourceTags) {
            this.resourceTags(Stream.of(resourceTags).map(c -> (ResourceTag)((ResourceTag.Builder)ResourceTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCostCategoryDefinitionRequest build() {
            return new CreateCostCategoryDefinitionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CostExplorerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCostCategoryDefinitionRequest> {
        public Builder name(String var1);

        public Builder effectiveStart(String var1);

        public Builder ruleVersion(String var1);

        public Builder ruleVersion(CostCategoryRuleVersion var1);

        public Builder rules(Collection<CostCategoryRule> var1);

        public Builder rules(CostCategoryRule ... var1);

        public Builder rules(Consumer<CostCategoryRule.Builder> ... var1);

        public Builder defaultValue(String var1);

        public Builder splitChargeRules(Collection<CostCategorySplitChargeRule> var1);

        public Builder splitChargeRules(CostCategorySplitChargeRule ... var1);

        public Builder splitChargeRules(Consumer<CostCategorySplitChargeRule.Builder> ... var1);

        public Builder resourceTags(Collection<ResourceTag> var1);

        public Builder resourceTags(ResourceTag ... var1);

        public Builder resourceTags(Consumer<ResourceTag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

