/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.controltower.ControlTowerClient;
import software.amazon.awssdk.services.controltower.internal.UserAgentUtils;
import software.amazon.awssdk.services.controltower.model.EnabledBaselineSummary;
import software.amazon.awssdk.services.controltower.model.ListEnabledBaselinesRequest;
import software.amazon.awssdk.services.controltower.model.ListEnabledBaselinesResponse;

public class ListEnabledBaselinesIterable
implements SdkIterable<ListEnabledBaselinesResponse> {
    private final ControlTowerClient client;
    private final ListEnabledBaselinesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEnabledBaselinesIterable(ControlTowerClient client, ListEnabledBaselinesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEnabledBaselinesResponseFetcher();
    }

    public Iterator<ListEnabledBaselinesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EnabledBaselineSummary> enabledBaselines() {
        Function<ListEnabledBaselinesResponse, Iterator> getIterator = response -> {
            if (response != null && response.enabledBaselines() != null) {
                return response.enabledBaselines().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEnabledBaselinesResponseFetcher
    implements SyncPageFetcher<ListEnabledBaselinesResponse> {
        private ListEnabledBaselinesResponseFetcher() {
        }

        public boolean hasNextPage(ListEnabledBaselinesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEnabledBaselinesResponse nextPage(ListEnabledBaselinesResponse previousPage) {
            if (previousPage == null) {
                return ListEnabledBaselinesIterable.this.client.listEnabledBaselines(ListEnabledBaselinesIterable.this.firstRequest);
            }
            return ListEnabledBaselinesIterable.this.client.listEnabledBaselines((ListEnabledBaselinesRequest)((Object)ListEnabledBaselinesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

