/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.ContactFlowModule;
import software.amazon.awssdk.services.connect.model.ContactFlowModuleSearchSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchContactFlowModulesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, SearchContactFlowModulesResponse> {
    private static final SdkField<List<ContactFlowModule>> CONTACT_FLOW_MODULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContactFlowModules").getter(SearchContactFlowModulesResponse.getter(SearchContactFlowModulesResponse::contactFlowModules)).setter(SearchContactFlowModulesResponse.setter(Builder::contactFlowModules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowModules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContactFlowModule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchContactFlowModulesResponse.getter(SearchContactFlowModulesResponse::nextToken)).setter(SearchContactFlowModulesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Long> APPROXIMATE_TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ApproximateTotalCount").getter(SearchContactFlowModulesResponse.getter(SearchContactFlowModulesResponse::approximateTotalCount)).setter(SearchContactFlowModulesResponse.setter(Builder::approximateTotalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateTotalCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_FLOW_MODULES_FIELD, NEXT_TOKEN_FIELD, APPROXIMATE_TOTAL_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ContactFlowModules", CONTACT_FLOW_MODULES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("ApproximateTotalCount", APPROXIMATE_TOTAL_COUNT_FIELD);
        }
    });
    private final List<ContactFlowModule> contactFlowModules;
    private final String nextToken;
    private final Long approximateTotalCount;

    private SearchContactFlowModulesResponse(BuilderImpl builder) {
        super(builder);
        this.contactFlowModules = builder.contactFlowModules;
        this.nextToken = builder.nextToken;
        this.approximateTotalCount = builder.approximateTotalCount;
    }

    public final boolean hasContactFlowModules() {
        return this.contactFlowModules != null && !(this.contactFlowModules instanceof SdkAutoConstructList);
    }

    public final List<ContactFlowModule> contactFlowModules() {
        return this.contactFlowModules;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Long approximateTotalCount() {
        return this.approximateTotalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContactFlowModules() ? this.contactFlowModules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateTotalCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchContactFlowModulesResponse)) {
            return false;
        }
        SearchContactFlowModulesResponse other = (SearchContactFlowModulesResponse)((Object)obj);
        return this.hasContactFlowModules() == other.hasContactFlowModules() && Objects.equals(this.contactFlowModules(), other.contactFlowModules()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.approximateTotalCount(), other.approximateTotalCount());
    }

    public final String toString() {
        return ToString.builder((String)"SearchContactFlowModulesResponse").add("ContactFlowModules", this.hasContactFlowModules() ? this.contactFlowModules() : null).add("NextToken", (Object)this.nextToken()).add("ApproximateTotalCount", (Object)this.approximateTotalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactFlowModules": {
                return Optional.ofNullable(clazz.cast(this.contactFlowModules()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ApproximateTotalCount": {
                return Optional.ofNullable(clazz.cast(this.approximateTotalCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchContactFlowModulesResponse, T> g) {
        return obj -> g.apply((SearchContactFlowModulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<ContactFlowModule> contactFlowModules = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Long approximateTotalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchContactFlowModulesResponse model) {
            super(model);
            this.contactFlowModules(model.contactFlowModules);
            this.nextToken(model.nextToken);
            this.approximateTotalCount(model.approximateTotalCount);
        }

        public final List<ContactFlowModule.Builder> getContactFlowModules() {
            List<ContactFlowModule.Builder> result = ContactFlowModuleSearchSummaryListCopier.copyToBuilder(this.contactFlowModules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContactFlowModules(Collection<ContactFlowModule.BuilderImpl> contactFlowModules) {
            this.contactFlowModules = ContactFlowModuleSearchSummaryListCopier.copyFromBuilder(contactFlowModules);
        }

        @Override
        public final Builder contactFlowModules(Collection<ContactFlowModule> contactFlowModules) {
            this.contactFlowModules = ContactFlowModuleSearchSummaryListCopier.copy(contactFlowModules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactFlowModules(ContactFlowModule ... contactFlowModules) {
            this.contactFlowModules(Arrays.asList(contactFlowModules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactFlowModules(Consumer<ContactFlowModule.Builder> ... contactFlowModules) {
            this.contactFlowModules(Stream.of(contactFlowModules).map(c -> (ContactFlowModule)((ContactFlowModule.Builder)ContactFlowModule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Long getApproximateTotalCount() {
            return this.approximateTotalCount;
        }

        public final void setApproximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
        }

        @Override
        public final Builder approximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
            return this;
        }

        @Override
        public SearchContactFlowModulesResponse build() {
            return new SearchContactFlowModulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchContactFlowModulesResponse> {
        public Builder contactFlowModules(Collection<ContactFlowModule> var1);

        public Builder contactFlowModules(ContactFlowModule ... var1);

        public Builder contactFlowModules(Consumer<ContactFlowModule.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder approximateTotalCount(Long var1);
    }
}

