/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.EvaluationMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceEvaluation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceEvaluation> {
    private static final SdkField<String> RESOURCE_EVALUATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceEvaluationId").getter(ResourceEvaluation.getter(ResourceEvaluation::resourceEvaluationId)).setter(ResourceEvaluation.setter(Builder::resourceEvaluationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceEvaluationId").build()}).build();
    private static final SdkField<String> EVALUATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationMode").getter(ResourceEvaluation.getter(ResourceEvaluation::evaluationModeAsString)).setter(ResourceEvaluation.setter(Builder::evaluationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationMode").build()}).build();
    private static final SdkField<Instant> EVALUATION_START_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EvaluationStartTimestamp").getter(ResourceEvaluation.getter(ResourceEvaluation::evaluationStartTimestamp)).setter(ResourceEvaluation.setter(Builder::evaluationStartTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationStartTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_EVALUATION_ID_FIELD, EVALUATION_MODE_FIELD, EVALUATION_START_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ResourceEvaluationId", RESOURCE_EVALUATION_ID_FIELD);
            this.put("EvaluationMode", EVALUATION_MODE_FIELD);
            this.put("EvaluationStartTimestamp", EVALUATION_START_TIMESTAMP_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String resourceEvaluationId;
    private final String evaluationMode;
    private final Instant evaluationStartTimestamp;

    private ResourceEvaluation(BuilderImpl builder) {
        this.resourceEvaluationId = builder.resourceEvaluationId;
        this.evaluationMode = builder.evaluationMode;
        this.evaluationStartTimestamp = builder.evaluationStartTimestamp;
    }

    public final String resourceEvaluationId() {
        return this.resourceEvaluationId;
    }

    public final EvaluationMode evaluationMode() {
        return EvaluationMode.fromValue(this.evaluationMode);
    }

    public final String evaluationModeAsString() {
        return this.evaluationMode;
    }

    public final Instant evaluationStartTimestamp() {
        return this.evaluationStartTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceEvaluationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationStartTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceEvaluation)) {
            return false;
        }
        ResourceEvaluation other = (ResourceEvaluation)obj;
        return Objects.equals(this.resourceEvaluationId(), other.resourceEvaluationId()) && Objects.equals(this.evaluationModeAsString(), other.evaluationModeAsString()) && Objects.equals(this.evaluationStartTimestamp(), other.evaluationStartTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceEvaluation").add("ResourceEvaluationId", (Object)this.resourceEvaluationId()).add("EvaluationMode", (Object)this.evaluationModeAsString()).add("EvaluationStartTimestamp", (Object)this.evaluationStartTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceEvaluationId": {
                return Optional.ofNullable(clazz.cast(this.resourceEvaluationId()));
            }
            case "EvaluationMode": {
                return Optional.ofNullable(clazz.cast(this.evaluationModeAsString()));
            }
            case "EvaluationStartTimestamp": {
                return Optional.ofNullable(clazz.cast(this.evaluationStartTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResourceEvaluation, T> g) {
        return obj -> g.apply((ResourceEvaluation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceEvaluationId;
        private String evaluationMode;
        private Instant evaluationStartTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceEvaluation model) {
            this.resourceEvaluationId(model.resourceEvaluationId);
            this.evaluationMode(model.evaluationMode);
            this.evaluationStartTimestamp(model.evaluationStartTimestamp);
        }

        public final String getResourceEvaluationId() {
            return this.resourceEvaluationId;
        }

        public final void setResourceEvaluationId(String resourceEvaluationId) {
            this.resourceEvaluationId = resourceEvaluationId;
        }

        @Override
        public final Builder resourceEvaluationId(String resourceEvaluationId) {
            this.resourceEvaluationId = resourceEvaluationId;
            return this;
        }

        public final String getEvaluationMode() {
            return this.evaluationMode;
        }

        public final void setEvaluationMode(String evaluationMode) {
            this.evaluationMode = evaluationMode;
        }

        @Override
        public final Builder evaluationMode(String evaluationMode) {
            this.evaluationMode = evaluationMode;
            return this;
        }

        @Override
        public final Builder evaluationMode(EvaluationMode evaluationMode) {
            this.evaluationMode(evaluationMode == null ? null : evaluationMode.toString());
            return this;
        }

        public final Instant getEvaluationStartTimestamp() {
            return this.evaluationStartTimestamp;
        }

        public final void setEvaluationStartTimestamp(Instant evaluationStartTimestamp) {
            this.evaluationStartTimestamp = evaluationStartTimestamp;
        }

        @Override
        public final Builder evaluationStartTimestamp(Instant evaluationStartTimestamp) {
            this.evaluationStartTimestamp = evaluationStartTimestamp;
            return this;
        }

        public ResourceEvaluation build() {
            return new ResourceEvaluation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceEvaluation> {
        public Builder resourceEvaluationId(String var1);

        public Builder evaluationMode(String var1);

        public Builder evaluationMode(EvaluationMode var1);

        public Builder evaluationStartTimestamp(Instant var1);
    }
}

