/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.computeoptimizer.model.EstimatedMonthlySavings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SavingsOpportunity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SavingsOpportunity> {
    private static final SdkField<Double> SAVINGS_OPPORTUNITY_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("savingsOpportunityPercentage").getter(SavingsOpportunity.getter(SavingsOpportunity::savingsOpportunityPercentage)).setter(SavingsOpportunity.setter(Builder::savingsOpportunityPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsOpportunityPercentage").build()}).build();
    private static final SdkField<EstimatedMonthlySavings> ESTIMATED_MONTHLY_SAVINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("estimatedMonthlySavings").getter(SavingsOpportunity.getter(SavingsOpportunity::estimatedMonthlySavings)).setter(SavingsOpportunity.setter(Builder::estimatedMonthlySavings)).constructor(EstimatedMonthlySavings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedMonthlySavings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAVINGS_OPPORTUNITY_PERCENTAGE_FIELD, ESTIMATED_MONTHLY_SAVINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("savingsOpportunityPercentage", SAVINGS_OPPORTUNITY_PERCENTAGE_FIELD);
            this.put("estimatedMonthlySavings", ESTIMATED_MONTHLY_SAVINGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Double savingsOpportunityPercentage;
    private final EstimatedMonthlySavings estimatedMonthlySavings;

    private SavingsOpportunity(BuilderImpl builder) {
        this.savingsOpportunityPercentage = builder.savingsOpportunityPercentage;
        this.estimatedMonthlySavings = builder.estimatedMonthlySavings;
    }

    public final Double savingsOpportunityPercentage() {
        return this.savingsOpportunityPercentage;
    }

    public final EstimatedMonthlySavings estimatedMonthlySavings() {
        return this.estimatedMonthlySavings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsOpportunityPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedMonthlySavings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsOpportunity)) {
            return false;
        }
        SavingsOpportunity other = (SavingsOpportunity)obj;
        return Objects.equals(this.savingsOpportunityPercentage(), other.savingsOpportunityPercentage()) && Objects.equals(this.estimatedMonthlySavings(), other.estimatedMonthlySavings());
    }

    public final String toString() {
        return ToString.builder((String)"SavingsOpportunity").add("SavingsOpportunityPercentage", (Object)this.savingsOpportunityPercentage()).add("EstimatedMonthlySavings", (Object)this.estimatedMonthlySavings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "savingsOpportunityPercentage": {
                return Optional.ofNullable(clazz.cast(this.savingsOpportunityPercentage()));
            }
            case "estimatedMonthlySavings": {
                return Optional.ofNullable(clazz.cast(this.estimatedMonthlySavings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SavingsOpportunity, T> g) {
        return obj -> g.apply((SavingsOpportunity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double savingsOpportunityPercentage;
        private EstimatedMonthlySavings estimatedMonthlySavings;

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsOpportunity model) {
            this.savingsOpportunityPercentage(model.savingsOpportunityPercentage);
            this.estimatedMonthlySavings(model.estimatedMonthlySavings);
        }

        public final Double getSavingsOpportunityPercentage() {
            return this.savingsOpportunityPercentage;
        }

        public final void setSavingsOpportunityPercentage(Double savingsOpportunityPercentage) {
            this.savingsOpportunityPercentage = savingsOpportunityPercentage;
        }

        @Override
        public final Builder savingsOpportunityPercentage(Double savingsOpportunityPercentage) {
            this.savingsOpportunityPercentage = savingsOpportunityPercentage;
            return this;
        }

        public final EstimatedMonthlySavings.Builder getEstimatedMonthlySavings() {
            return this.estimatedMonthlySavings != null ? this.estimatedMonthlySavings.toBuilder() : null;
        }

        public final void setEstimatedMonthlySavings(EstimatedMonthlySavings.BuilderImpl estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings != null ? estimatedMonthlySavings.build() : null;
        }

        @Override
        public final Builder estimatedMonthlySavings(EstimatedMonthlySavings estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings;
            return this;
        }

        public SavingsOpportunity build() {
            return new SavingsOpportunity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SavingsOpportunity> {
        public Builder savingsOpportunityPercentage(Double var1);

        public Builder estimatedMonthlySavings(EstimatedMonthlySavings var1);

        default public Builder estimatedMonthlySavings(Consumer<EstimatedMonthlySavings.Builder> estimatedMonthlySavings) {
            return this.estimatedMonthlySavings((EstimatedMonthlySavings)((EstimatedMonthlySavings.Builder)EstimatedMonthlySavings.builder().applyMutation(estimatedMonthlySavings)).build());
        }
    }
}

