/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.RDSDBProjectedUtilizationMetricsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.RDSDBUtilizationMetric;
import software.amazon.awssdk.services.computeoptimizer.model.RDSInstanceSavingsOpportunityAfterDiscounts;
import software.amazon.awssdk.services.computeoptimizer.model.SavingsOpportunity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RDSDBInstanceRecommendationOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RDSDBInstanceRecommendationOption> {
    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbInstanceClass").getter(RDSDBInstanceRecommendationOption.getter(RDSDBInstanceRecommendationOption::dbInstanceClass)).setter(RDSDBInstanceRecommendationOption.setter(Builder::dbInstanceClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbInstanceClass").build()}).build();
    private static final SdkField<List<RDSDBUtilizationMetric>> PROJECTED_UTILIZATION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("projectedUtilizationMetrics").getter(RDSDBInstanceRecommendationOption.getter(RDSDBInstanceRecommendationOption::projectedUtilizationMetrics)).setter(RDSDBInstanceRecommendationOption.setter(Builder::projectedUtilizationMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectedUtilizationMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RDSDBUtilizationMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> PERFORMANCE_RISK_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("performanceRisk").getter(RDSDBInstanceRecommendationOption.getter(RDSDBInstanceRecommendationOption::performanceRisk)).setter(RDSDBInstanceRecommendationOption.setter(Builder::performanceRisk)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performanceRisk").build()}).build();
    private static final SdkField<Integer> RANK_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("rank").getter(RDSDBInstanceRecommendationOption.getter(RDSDBInstanceRecommendationOption::rank)).setter(RDSDBInstanceRecommendationOption.setter(Builder::rank)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rank").build()}).build();
    private static final SdkField<SavingsOpportunity> SAVINGS_OPPORTUNITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("savingsOpportunity").getter(RDSDBInstanceRecommendationOption.getter(RDSDBInstanceRecommendationOption::savingsOpportunity)).setter(RDSDBInstanceRecommendationOption.setter(Builder::savingsOpportunity)).constructor(SavingsOpportunity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsOpportunity").build()}).build();
    private static final SdkField<RDSInstanceSavingsOpportunityAfterDiscounts> SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("savingsOpportunityAfterDiscounts").getter(RDSDBInstanceRecommendationOption.getter(RDSDBInstanceRecommendationOption::savingsOpportunityAfterDiscounts)).setter(RDSDBInstanceRecommendationOption.setter(Builder::savingsOpportunityAfterDiscounts)).constructor(RDSInstanceSavingsOpportunityAfterDiscounts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsOpportunityAfterDiscounts").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_CLASS_FIELD, PROJECTED_UTILIZATION_METRICS_FIELD, PERFORMANCE_RISK_FIELD, RANK_FIELD, SAVINGS_OPPORTUNITY_FIELD, SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("dbInstanceClass", DB_INSTANCE_CLASS_FIELD);
            this.put("projectedUtilizationMetrics", PROJECTED_UTILIZATION_METRICS_FIELD);
            this.put("performanceRisk", PERFORMANCE_RISK_FIELD);
            this.put("rank", RANK_FIELD);
            this.put("savingsOpportunity", SAVINGS_OPPORTUNITY_FIELD);
            this.put("savingsOpportunityAfterDiscounts", SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String dbInstanceClass;
    private final List<RDSDBUtilizationMetric> projectedUtilizationMetrics;
    private final Double performanceRisk;
    private final Integer rank;
    private final SavingsOpportunity savingsOpportunity;
    private final RDSInstanceSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts;

    private RDSDBInstanceRecommendationOption(BuilderImpl builder) {
        this.dbInstanceClass = builder.dbInstanceClass;
        this.projectedUtilizationMetrics = builder.projectedUtilizationMetrics;
        this.performanceRisk = builder.performanceRisk;
        this.rank = builder.rank;
        this.savingsOpportunity = builder.savingsOpportunity;
        this.savingsOpportunityAfterDiscounts = builder.savingsOpportunityAfterDiscounts;
    }

    public final String dbInstanceClass() {
        return this.dbInstanceClass;
    }

    public final boolean hasProjectedUtilizationMetrics() {
        return this.projectedUtilizationMetrics != null && !(this.projectedUtilizationMetrics instanceof SdkAutoConstructList);
    }

    public final List<RDSDBUtilizationMetric> projectedUtilizationMetrics() {
        return this.projectedUtilizationMetrics;
    }

    public final Double performanceRisk() {
        return this.performanceRisk;
    }

    public final Integer rank() {
        return this.rank;
    }

    public final SavingsOpportunity savingsOpportunity() {
        return this.savingsOpportunity;
    }

    public final RDSInstanceSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts() {
        return this.savingsOpportunityAfterDiscounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProjectedUtilizationMetrics() ? this.projectedUtilizationMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceRisk());
        hashCode = 31 * hashCode + Objects.hashCode(this.rank());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsOpportunity());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsOpportunityAfterDiscounts());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDSDBInstanceRecommendationOption)) {
            return false;
        }
        RDSDBInstanceRecommendationOption other = (RDSDBInstanceRecommendationOption)obj;
        return Objects.equals(this.dbInstanceClass(), other.dbInstanceClass()) && this.hasProjectedUtilizationMetrics() == other.hasProjectedUtilizationMetrics() && Objects.equals(this.projectedUtilizationMetrics(), other.projectedUtilizationMetrics()) && Objects.equals(this.performanceRisk(), other.performanceRisk()) && Objects.equals(this.rank(), other.rank()) && Objects.equals(this.savingsOpportunity(), other.savingsOpportunity()) && Objects.equals(this.savingsOpportunityAfterDiscounts(), other.savingsOpportunityAfterDiscounts());
    }

    public final String toString() {
        return ToString.builder((String)"RDSDBInstanceRecommendationOption").add("DbInstanceClass", (Object)this.dbInstanceClass()).add("ProjectedUtilizationMetrics", this.hasProjectedUtilizationMetrics() ? this.projectedUtilizationMetrics() : null).add("PerformanceRisk", (Object)this.performanceRisk()).add("Rank", (Object)this.rank()).add("SavingsOpportunity", (Object)this.savingsOpportunity()).add("SavingsOpportunityAfterDiscounts", (Object)this.savingsOpportunityAfterDiscounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dbInstanceClass": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceClass()));
            }
            case "projectedUtilizationMetrics": {
                return Optional.ofNullable(clazz.cast(this.projectedUtilizationMetrics()));
            }
            case "performanceRisk": {
                return Optional.ofNullable(clazz.cast(this.performanceRisk()));
            }
            case "rank": {
                return Optional.ofNullable(clazz.cast(this.rank()));
            }
            case "savingsOpportunity": {
                return Optional.ofNullable(clazz.cast(this.savingsOpportunity()));
            }
            case "savingsOpportunityAfterDiscounts": {
                return Optional.ofNullable(clazz.cast(this.savingsOpportunityAfterDiscounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RDSDBInstanceRecommendationOption, T> g) {
        return obj -> g.apply((RDSDBInstanceRecommendationOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dbInstanceClass;
        private List<RDSDBUtilizationMetric> projectedUtilizationMetrics = DefaultSdkAutoConstructList.getInstance();
        private Double performanceRisk;
        private Integer rank;
        private SavingsOpportunity savingsOpportunity;
        private RDSInstanceSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts;

        private BuilderImpl() {
        }

        private BuilderImpl(RDSDBInstanceRecommendationOption model) {
            this.dbInstanceClass(model.dbInstanceClass);
            this.projectedUtilizationMetrics(model.projectedUtilizationMetrics);
            this.performanceRisk(model.performanceRisk);
            this.rank(model.rank);
            this.savingsOpportunity(model.savingsOpportunity);
            this.savingsOpportunityAfterDiscounts(model.savingsOpportunityAfterDiscounts);
        }

        public final String getDbInstanceClass() {
            return this.dbInstanceClass;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final List<RDSDBUtilizationMetric.Builder> getProjectedUtilizationMetrics() {
            List<RDSDBUtilizationMetric.Builder> result = RDSDBProjectedUtilizationMetricsCopier.copyToBuilder(this.projectedUtilizationMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProjectedUtilizationMetrics(Collection<RDSDBUtilizationMetric.BuilderImpl> projectedUtilizationMetrics) {
            this.projectedUtilizationMetrics = RDSDBProjectedUtilizationMetricsCopier.copyFromBuilder(projectedUtilizationMetrics);
        }

        @Override
        public final Builder projectedUtilizationMetrics(Collection<RDSDBUtilizationMetric> projectedUtilizationMetrics) {
            this.projectedUtilizationMetrics = RDSDBProjectedUtilizationMetricsCopier.copy(projectedUtilizationMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectedUtilizationMetrics(RDSDBUtilizationMetric ... projectedUtilizationMetrics) {
            this.projectedUtilizationMetrics(Arrays.asList(projectedUtilizationMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectedUtilizationMetrics(Consumer<RDSDBUtilizationMetric.Builder> ... projectedUtilizationMetrics) {
            this.projectedUtilizationMetrics(Stream.of(projectedUtilizationMetrics).map(c -> (RDSDBUtilizationMetric)((RDSDBUtilizationMetric.Builder)RDSDBUtilizationMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Double getPerformanceRisk() {
            return this.performanceRisk;
        }

        public final void setPerformanceRisk(Double performanceRisk) {
            this.performanceRisk = performanceRisk;
        }

        @Override
        public final Builder performanceRisk(Double performanceRisk) {
            this.performanceRisk = performanceRisk;
            return this;
        }

        public final Integer getRank() {
            return this.rank;
        }

        public final void setRank(Integer rank) {
            this.rank = rank;
        }

        @Override
        public final Builder rank(Integer rank) {
            this.rank = rank;
            return this;
        }

        public final SavingsOpportunity.Builder getSavingsOpportunity() {
            return this.savingsOpportunity != null ? this.savingsOpportunity.toBuilder() : null;
        }

        public final void setSavingsOpportunity(SavingsOpportunity.BuilderImpl savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity != null ? savingsOpportunity.build() : null;
        }

        @Override
        public final Builder savingsOpportunity(SavingsOpportunity savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity;
            return this;
        }

        public final RDSInstanceSavingsOpportunityAfterDiscounts.Builder getSavingsOpportunityAfterDiscounts() {
            return this.savingsOpportunityAfterDiscounts != null ? this.savingsOpportunityAfterDiscounts.toBuilder() : null;
        }

        public final void setSavingsOpportunityAfterDiscounts(RDSInstanceSavingsOpportunityAfterDiscounts.BuilderImpl savingsOpportunityAfterDiscounts) {
            this.savingsOpportunityAfterDiscounts = savingsOpportunityAfterDiscounts != null ? savingsOpportunityAfterDiscounts.build() : null;
        }

        @Override
        public final Builder savingsOpportunityAfterDiscounts(RDSInstanceSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts) {
            this.savingsOpportunityAfterDiscounts = savingsOpportunityAfterDiscounts;
            return this;
        }

        public RDSDBInstanceRecommendationOption build() {
            return new RDSDBInstanceRecommendationOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RDSDBInstanceRecommendationOption> {
        public Builder dbInstanceClass(String var1);

        public Builder projectedUtilizationMetrics(Collection<RDSDBUtilizationMetric> var1);

        public Builder projectedUtilizationMetrics(RDSDBUtilizationMetric ... var1);

        public Builder projectedUtilizationMetrics(Consumer<RDSDBUtilizationMetric.Builder> ... var1);

        public Builder performanceRisk(Double var1);

        public Builder rank(Integer var1);

        public Builder savingsOpportunity(SavingsOpportunity var1);

        default public Builder savingsOpportunity(Consumer<SavingsOpportunity.Builder> savingsOpportunity) {
            return this.savingsOpportunity((SavingsOpportunity)((SavingsOpportunity.Builder)SavingsOpportunity.builder().applyMutation(savingsOpportunity)).build());
        }

        public Builder savingsOpportunityAfterDiscounts(RDSInstanceSavingsOpportunityAfterDiscounts var1);

        default public Builder savingsOpportunityAfterDiscounts(Consumer<RDSInstanceSavingsOpportunityAfterDiscounts.Builder> savingsOpportunityAfterDiscounts) {
            return this.savingsOpportunityAfterDiscounts((RDSInstanceSavingsOpportunityAfterDiscounts)((RDSInstanceSavingsOpportunityAfterDiscounts.Builder)RDSInstanceSavingsOpportunityAfterDiscounts.builder().applyMutation(savingsOpportunityAfterDiscounts)).build());
        }
    }
}

