/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codepipeline.model.ErrorDetails;
import software.amazon.awssdk.services.codepipeline.model.RuleExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleExecution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleExecution> {
    private static final SdkField<String> RULE_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleExecutionId").getter(RuleExecution.getter(RuleExecution::ruleExecutionId)).setter(RuleExecution.setter(Builder::ruleExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleExecutionId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(RuleExecution.getter(RuleExecution::statusAsString)).setter(RuleExecution.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("summary").getter(RuleExecution.getter(RuleExecution::summary)).setter(RuleExecution.setter(Builder::summary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summary").build()}).build();
    private static final SdkField<Instant> LAST_STATUS_CHANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastStatusChange").getter(RuleExecution.getter(RuleExecution::lastStatusChange)).setter(RuleExecution.setter(Builder::lastStatusChange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatusChange").build()}).build();
    private static final SdkField<String> TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("token").getter(RuleExecution.getter(RuleExecution::token)).setter(RuleExecution.setter(Builder::token)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("token").build()}).build();
    private static final SdkField<String> LAST_UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastUpdatedBy").getter(RuleExecution.getter(RuleExecution::lastUpdatedBy)).setter(RuleExecution.setter(Builder::lastUpdatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedBy").build()}).build();
    private static final SdkField<String> EXTERNAL_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("externalExecutionId").getter(RuleExecution.getter(RuleExecution::externalExecutionId)).setter(RuleExecution.setter(Builder::externalExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalExecutionId").build()}).build();
    private static final SdkField<String> EXTERNAL_EXECUTION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("externalExecutionUrl").getter(RuleExecution.getter(RuleExecution::externalExecutionUrl)).setter(RuleExecution.setter(Builder::externalExecutionUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalExecutionUrl").build()}).build();
    private static final SdkField<ErrorDetails> ERROR_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("errorDetails").getter(RuleExecution.getter(RuleExecution::errorDetails)).setter(RuleExecution.setter(Builder::errorDetails)).constructor(ErrorDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_EXECUTION_ID_FIELD, STATUS_FIELD, SUMMARY_FIELD, LAST_STATUS_CHANGE_FIELD, TOKEN_FIELD, LAST_UPDATED_BY_FIELD, EXTERNAL_EXECUTION_ID_FIELD, EXTERNAL_EXECUTION_URL_FIELD, ERROR_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ruleExecutionId", RULE_EXECUTION_ID_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("summary", SUMMARY_FIELD);
            this.put("lastStatusChange", LAST_STATUS_CHANGE_FIELD);
            this.put("token", TOKEN_FIELD);
            this.put("lastUpdatedBy", LAST_UPDATED_BY_FIELD);
            this.put("externalExecutionId", EXTERNAL_EXECUTION_ID_FIELD);
            this.put("externalExecutionUrl", EXTERNAL_EXECUTION_URL_FIELD);
            this.put("errorDetails", ERROR_DETAILS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String ruleExecutionId;
    private final String status;
    private final String summary;
    private final Instant lastStatusChange;
    private final String token;
    private final String lastUpdatedBy;
    private final String externalExecutionId;
    private final String externalExecutionUrl;
    private final ErrorDetails errorDetails;

    private RuleExecution(BuilderImpl builder) {
        this.ruleExecutionId = builder.ruleExecutionId;
        this.status = builder.status;
        this.summary = builder.summary;
        this.lastStatusChange = builder.lastStatusChange;
        this.token = builder.token;
        this.lastUpdatedBy = builder.lastUpdatedBy;
        this.externalExecutionId = builder.externalExecutionId;
        this.externalExecutionUrl = builder.externalExecutionUrl;
        this.errorDetails = builder.errorDetails;
    }

    public final String ruleExecutionId() {
        return this.ruleExecutionId;
    }

    public final RuleExecutionStatus status() {
        return RuleExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String summary() {
        return this.summary;
    }

    public final Instant lastStatusChange() {
        return this.lastStatusChange;
    }

    public final String token() {
        return this.token;
    }

    public final String lastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public final String externalExecutionId() {
        return this.externalExecutionId;
    }

    public final String externalExecutionUrl() {
        return this.externalExecutionUrl;
    }

    public final ErrorDetails errorDetails() {
        return this.errorDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatusChange());
        hashCode = 31 * hashCode + Objects.hashCode(this.token());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalExecutionUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleExecution)) {
            return false;
        }
        RuleExecution other = (RuleExecution)obj;
        return Objects.equals(this.ruleExecutionId(), other.ruleExecutionId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.summary(), other.summary()) && Objects.equals(this.lastStatusChange(), other.lastStatusChange()) && Objects.equals(this.token(), other.token()) && Objects.equals(this.lastUpdatedBy(), other.lastUpdatedBy()) && Objects.equals(this.externalExecutionId(), other.externalExecutionId()) && Objects.equals(this.externalExecutionUrl(), other.externalExecutionUrl()) && Objects.equals(this.errorDetails(), other.errorDetails());
    }

    public final String toString() {
        return ToString.builder((String)"RuleExecution").add("RuleExecutionId", (Object)this.ruleExecutionId()).add("Status", (Object)this.statusAsString()).add("Summary", (Object)this.summary()).add("LastStatusChange", (Object)this.lastStatusChange()).add("Token", (Object)this.token()).add("LastUpdatedBy", (Object)this.lastUpdatedBy()).add("ExternalExecutionId", (Object)this.externalExecutionId()).add("ExternalExecutionUrl", (Object)this.externalExecutionUrl()).add("ErrorDetails", (Object)this.errorDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ruleExecutionId": {
                return Optional.ofNullable(clazz.cast(this.ruleExecutionId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "summary": {
                return Optional.ofNullable(clazz.cast(this.summary()));
            }
            case "lastStatusChange": {
                return Optional.ofNullable(clazz.cast(this.lastStatusChange()));
            }
            case "token": {
                return Optional.ofNullable(clazz.cast(this.token()));
            }
            case "lastUpdatedBy": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedBy()));
            }
            case "externalExecutionId": {
                return Optional.ofNullable(clazz.cast(this.externalExecutionId()));
            }
            case "externalExecutionUrl": {
                return Optional.ofNullable(clazz.cast(this.externalExecutionUrl()));
            }
            case "errorDetails": {
                return Optional.ofNullable(clazz.cast(this.errorDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RuleExecution, T> g) {
        return obj -> g.apply((RuleExecution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleExecutionId;
        private String status;
        private String summary;
        private Instant lastStatusChange;
        private String token;
        private String lastUpdatedBy;
        private String externalExecutionId;
        private String externalExecutionUrl;
        private ErrorDetails errorDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleExecution model) {
            this.ruleExecutionId(model.ruleExecutionId);
            this.status(model.status);
            this.summary(model.summary);
            this.lastStatusChange(model.lastStatusChange);
            this.token(model.token);
            this.lastUpdatedBy(model.lastUpdatedBy);
            this.externalExecutionId(model.externalExecutionId);
            this.externalExecutionUrl(model.externalExecutionUrl);
            this.errorDetails(model.errorDetails);
        }

        public final String getRuleExecutionId() {
            return this.ruleExecutionId;
        }

        public final void setRuleExecutionId(String ruleExecutionId) {
            this.ruleExecutionId = ruleExecutionId;
        }

        @Override
        public final Builder ruleExecutionId(String ruleExecutionId) {
            this.ruleExecutionId = ruleExecutionId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RuleExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSummary() {
            return this.summary;
        }

        public final void setSummary(String summary) {
            this.summary = summary;
        }

        @Override
        public final Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public final Instant getLastStatusChange() {
            return this.lastStatusChange;
        }

        public final void setLastStatusChange(Instant lastStatusChange) {
            this.lastStatusChange = lastStatusChange;
        }

        @Override
        public final Builder lastStatusChange(Instant lastStatusChange) {
            this.lastStatusChange = lastStatusChange;
            return this;
        }

        public final String getToken() {
            return this.token;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final String getLastUpdatedBy() {
            return this.lastUpdatedBy;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public final String getExternalExecutionId() {
            return this.externalExecutionId;
        }

        public final void setExternalExecutionId(String externalExecutionId) {
            this.externalExecutionId = externalExecutionId;
        }

        @Override
        public final Builder externalExecutionId(String externalExecutionId) {
            this.externalExecutionId = externalExecutionId;
            return this;
        }

        public final String getExternalExecutionUrl() {
            return this.externalExecutionUrl;
        }

        public final void setExternalExecutionUrl(String externalExecutionUrl) {
            this.externalExecutionUrl = externalExecutionUrl;
        }

        @Override
        public final Builder externalExecutionUrl(String externalExecutionUrl) {
            this.externalExecutionUrl = externalExecutionUrl;
            return this;
        }

        public final ErrorDetails.Builder getErrorDetails() {
            return this.errorDetails != null ? this.errorDetails.toBuilder() : null;
        }

        public final void setErrorDetails(ErrorDetails.BuilderImpl errorDetails) {
            this.errorDetails = errorDetails != null ? errorDetails.build() : null;
        }

        @Override
        public final Builder errorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public RuleExecution build() {
            return new RuleExecution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleExecution> {
        public Builder ruleExecutionId(String var1);

        public Builder status(String var1);

        public Builder status(RuleExecutionStatus var1);

        public Builder summary(String var1);

        public Builder lastStatusChange(Instant var1);

        public Builder token(String var1);

        public Builder lastUpdatedBy(String var1);

        public Builder externalExecutionId(String var1);

        public Builder externalExecutionUrl(String var1);

        public Builder errorDetails(ErrorDetails var1);

        default public Builder errorDetails(Consumer<ErrorDetails.Builder> errorDetails) {
            return this.errorDetails((ErrorDetails)((ErrorDetails.Builder)ErrorDetails.builder().applyMutation(errorDetails)).build());
        }
    }
}

