/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurusecurity.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codegurusecurity.model.DetectorTagsCopier;
import software.amazon.awssdk.services.codegurusecurity.model.Remediation;
import software.amazon.awssdk.services.codegurusecurity.model.Resource;
import software.amazon.awssdk.services.codegurusecurity.model.Severity;
import software.amazon.awssdk.services.codegurusecurity.model.Status;
import software.amazon.awssdk.services.codegurusecurity.model.Vulnerability;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Finding
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Finding> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Finding.getter(Finding::createdAt)).setter(Finding.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Finding.getter(Finding::description)).setter(Finding.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorId").getter(Finding.getter(Finding::detectorId)).setter(Finding.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()}).build();
    private static final SdkField<String> DETECTOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorName").getter(Finding.getter(Finding::detectorName)).setter(Finding.setter(Builder::detectorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorName").build()}).build();
    private static final SdkField<List<String>> DETECTOR_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("detectorTags").getter(Finding.getter(Finding::detectorTags)).setter(Finding.setter(Builder::detectorTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> GENERATOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("generatorId").getter(Finding.getter(Finding::generatorId)).setter(Finding.setter(Builder::generatorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatorId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Finding.getter(Finding::id)).setter(Finding.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Remediation> REMEDIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("remediation").getter(Finding.getter(Finding::remediation)).setter(Finding.setter(Builder::remediation)).constructor(Remediation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remediation").build()}).build();
    private static final SdkField<Resource> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resource").getter(Finding.getter(Finding::resource)).setter(Finding.setter(Builder::resource)).constructor(Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final SdkField<String> RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleId").getter(Finding.getter(Finding::ruleId)).setter(Finding.setter(Builder::ruleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleId").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("severity").getter(Finding.getter(Finding::severityAsString)).setter(Finding.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Finding.getter(Finding::statusAsString)).setter(Finding.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(Finding.getter(Finding::title)).setter(Finding.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Finding.getter(Finding::type)).setter(Finding.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(Finding.getter(Finding::updatedAt)).setter(Finding.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<Vulnerability> VULNERABILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vulnerability").getter(Finding.getter(Finding::vulnerability)).setter(Finding.setter(Builder::vulnerability)).constructor(Vulnerability::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vulnerability").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, DESCRIPTION_FIELD, DETECTOR_ID_FIELD, DETECTOR_NAME_FIELD, DETECTOR_TAGS_FIELD, GENERATOR_ID_FIELD, ID_FIELD, REMEDIATION_FIELD, RESOURCE_FIELD, RULE_ID_FIELD, SEVERITY_FIELD, STATUS_FIELD, TITLE_FIELD, TYPE_FIELD, UPDATED_AT_FIELD, VULNERABILITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("detectorId", DETECTOR_ID_FIELD);
            this.put("detectorName", DETECTOR_NAME_FIELD);
            this.put("detectorTags", DETECTOR_TAGS_FIELD);
            this.put("generatorId", GENERATOR_ID_FIELD);
            this.put("id", ID_FIELD);
            this.put("remediation", REMEDIATION_FIELD);
            this.put("resource", RESOURCE_FIELD);
            this.put("ruleId", RULE_ID_FIELD);
            this.put("severity", SEVERITY_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("title", TITLE_FIELD);
            this.put("type", TYPE_FIELD);
            this.put("updatedAt", UPDATED_AT_FIELD);
            this.put("vulnerability", VULNERABILITY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final String description;
    private final String detectorId;
    private final String detectorName;
    private final List<String> detectorTags;
    private final String generatorId;
    private final String id;
    private final Remediation remediation;
    private final Resource resource;
    private final String ruleId;
    private final String severity;
    private final String status;
    private final String title;
    private final String type;
    private final Instant updatedAt;
    private final Vulnerability vulnerability;

    private Finding(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.detectorId = builder.detectorId;
        this.detectorName = builder.detectorName;
        this.detectorTags = builder.detectorTags;
        this.generatorId = builder.generatorId;
        this.id = builder.id;
        this.remediation = builder.remediation;
        this.resource = builder.resource;
        this.ruleId = builder.ruleId;
        this.severity = builder.severity;
        this.status = builder.status;
        this.title = builder.title;
        this.type = builder.type;
        this.updatedAt = builder.updatedAt;
        this.vulnerability = builder.vulnerability;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String description() {
        return this.description;
    }

    public final String detectorId() {
        return this.detectorId;
    }

    public final String detectorName() {
        return this.detectorName;
    }

    public final boolean hasDetectorTags() {
        return this.detectorTags != null && !(this.detectorTags instanceof SdkAutoConstructList);
    }

    public final List<String> detectorTags() {
        return this.detectorTags;
    }

    public final String generatorId() {
        return this.generatorId;
    }

    public final String id() {
        return this.id;
    }

    public final Remediation remediation() {
        return this.remediation;
    }

    public final Resource resource() {
        return this.resource;
    }

    public final String ruleId() {
        return this.ruleId;
    }

    public final Severity severity() {
        return Severity.fromValue(this.severity);
    }

    public final String severityAsString() {
        return this.severity;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String title() {
        return this.title;
    }

    public final String type() {
        return this.type;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final Vulnerability vulnerability() {
        return this.vulnerability;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDetectorTags() ? this.detectorTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.generatorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.remediation());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.vulnerability());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Finding)) {
            return false;
        }
        Finding other = (Finding)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.detectorName(), other.detectorName()) && this.hasDetectorTags() == other.hasDetectorTags() && Objects.equals(this.detectorTags(), other.detectorTags()) && Objects.equals(this.generatorId(), other.generatorId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.remediation(), other.remediation()) && Objects.equals(this.resource(), other.resource()) && Objects.equals(this.ruleId(), other.ruleId()) && Objects.equals(this.severityAsString(), other.severityAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.vulnerability(), other.vulnerability());
    }

    public final String toString() {
        return ToString.builder((String)"Finding").add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)this.description()).add("DetectorId", (Object)this.detectorId()).add("DetectorName", (Object)this.detectorName()).add("DetectorTags", this.hasDetectorTags() ? this.detectorTags() : null).add("GeneratorId", (Object)this.generatorId()).add("Id", (Object)this.id()).add("Remediation", (Object)this.remediation()).add("Resource", (Object)this.resource()).add("RuleId", (Object)this.ruleId()).add("Severity", (Object)this.severityAsString()).add("Status", (Object)this.statusAsString()).add("Title", (Object)this.title()).add("Type", (Object)this.type()).add("UpdatedAt", (Object)this.updatedAt()).add("Vulnerability", (Object)this.vulnerability()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "detectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "detectorName": {
                return Optional.ofNullable(clazz.cast(this.detectorName()));
            }
            case "detectorTags": {
                return Optional.ofNullable(clazz.cast(this.detectorTags()));
            }
            case "generatorId": {
                return Optional.ofNullable(clazz.cast(this.generatorId()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "remediation": {
                return Optional.ofNullable(clazz.cast(this.remediation()));
            }
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "ruleId": {
                return Optional.ofNullable(clazz.cast(this.ruleId()));
            }
            case "severity": {
                return Optional.ofNullable(clazz.cast(this.severityAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "vulnerability": {
                return Optional.ofNullable(clazz.cast(this.vulnerability()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Finding, T> g) {
        return obj -> g.apply((Finding)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String description;
        private String detectorId;
        private String detectorName;
        private List<String> detectorTags = DefaultSdkAutoConstructList.getInstance();
        private String generatorId;
        private String id;
        private Remediation remediation;
        private Resource resource;
        private String ruleId;
        private String severity;
        private String status;
        private String title;
        private String type;
        private Instant updatedAt;
        private Vulnerability vulnerability;

        private BuilderImpl() {
        }

        private BuilderImpl(Finding model) {
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.detectorId(model.detectorId);
            this.detectorName(model.detectorName);
            this.detectorTags(model.detectorTags);
            this.generatorId(model.generatorId);
            this.id(model.id);
            this.remediation(model.remediation);
            this.resource(model.resource);
            this.ruleId(model.ruleId);
            this.severity(model.severity);
            this.status(model.status);
            this.title(model.title);
            this.type(model.type);
            this.updatedAt(model.updatedAt);
            this.vulnerability(model.vulnerability);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getDetectorName() {
            return this.detectorName;
        }

        public final void setDetectorName(String detectorName) {
            this.detectorName = detectorName;
        }

        @Override
        public final Builder detectorName(String detectorName) {
            this.detectorName = detectorName;
            return this;
        }

        public final Collection<String> getDetectorTags() {
            if (this.detectorTags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.detectorTags;
        }

        public final void setDetectorTags(Collection<String> detectorTags) {
            this.detectorTags = DetectorTagsCopier.copy(detectorTags);
        }

        @Override
        public final Builder detectorTags(Collection<String> detectorTags) {
            this.detectorTags = DetectorTagsCopier.copy(detectorTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectorTags(String ... detectorTags) {
            this.detectorTags(Arrays.asList(detectorTags));
            return this;
        }

        public final String getGeneratorId() {
            return this.generatorId;
        }

        public final void setGeneratorId(String generatorId) {
            this.generatorId = generatorId;
        }

        @Override
        public final Builder generatorId(String generatorId) {
            this.generatorId = generatorId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Remediation.Builder getRemediation() {
            return this.remediation != null ? this.remediation.toBuilder() : null;
        }

        public final void setRemediation(Remediation.BuilderImpl remediation) {
            this.remediation = remediation != null ? remediation.build() : null;
        }

        @Override
        public final Builder remediation(Remediation remediation) {
            this.remediation = remediation;
            return this;
        }

        public final Resource.Builder getResource() {
            return this.resource != null ? this.resource.toBuilder() : null;
        }

        public final void setResource(Resource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final String getSeverity() {
            return this.severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(Severity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Vulnerability.Builder getVulnerability() {
            return this.vulnerability != null ? this.vulnerability.toBuilder() : null;
        }

        public final void setVulnerability(Vulnerability.BuilderImpl vulnerability) {
            this.vulnerability = vulnerability != null ? vulnerability.build() : null;
        }

        @Override
        public final Builder vulnerability(Vulnerability vulnerability) {
            this.vulnerability = vulnerability;
            return this;
        }

        public Finding build() {
            return new Finding(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Finding> {
        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder detectorId(String var1);

        public Builder detectorName(String var1);

        public Builder detectorTags(Collection<String> var1);

        public Builder detectorTags(String ... var1);

        public Builder generatorId(String var1);

        public Builder id(String var1);

        public Builder remediation(Remediation var1);

        default public Builder remediation(Consumer<Remediation.Builder> remediation) {
            return this.remediation((Remediation)((Remediation.Builder)Remediation.builder().applyMutation(remediation)).build());
        }

        public Builder resource(Resource var1);

        default public Builder resource(Consumer<Resource.Builder> resource) {
            return this.resource((Resource)((Resource.Builder)Resource.builder().applyMutation(resource)).build());
        }

        public Builder ruleId(String var1);

        public Builder severity(String var1);

        public Builder severity(Severity var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder title(String var1);

        public Builder type(String var1);

        public Builder updatedAt(Instant var1);

        public Builder vulnerability(Vulnerability var1);

        default public Builder vulnerability(Consumer<Vulnerability.Builder> vulnerability) {
            return this.vulnerability((Vulnerability)((Vulnerability.Builder)Vulnerability.builder().applyMutation(vulnerability)).build());
        }
    }
}

