/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Reaction {
    THUMBS_UP("ThumbsUp"),
    THUMBS_DOWN("ThumbsDown"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Reaction> VALUE_MAP;
    private final String value;

    private Reaction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Reaction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Reaction> knownValues() {
        EnumSet<Reaction> knownValues = EnumSet.allOf(Reaction.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Reaction.class, Reaction::toString);
    }
}

