/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.endpoints.internal;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codecatalyst.endpoints.CodeCatalystEndpointParams;
import software.amazon.awssdk.services.codecatalyst.endpoints.CodeCatalystEndpointProvider;
import software.amazon.awssdk.services.codecatalyst.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.codecatalyst.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.codecatalyst.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultCodeCatalystEndpointProvider
implements CodeCatalystEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(CodeCatalystEndpointParams params) {
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            RuleResult result = DefaultCodeCatalystEndpointProvider.endpointRule0(params, new LocalState(params.region()));
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(CodeCatalystEndpointParams params, LocalState locals) {
        RuleResult result = DefaultCodeCatalystEndpointProvider.endpointRule1(params, locals);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultCodeCatalystEndpointProvider.endpointRule2(params, locals);
        if (result.isResolved()) {
            return result;
        }
        return DefaultCodeCatalystEndpointProvider.endpointRule7(params, locals);
    }

    private static RuleResult endpointRule1(CodeCatalystEndpointParams params, LocalState locals) {
        if (params.endpoint() != null) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule2(CodeCatalystEndpointParams params, LocalState locals) {
        if (locals.region() == null) {
            RulePartition partitionResult = null;
            partitionResult = RulesFunctions.awsPartition("us-west-2");
            if (partitionResult != null) {
                RuleResult result = DefaultCodeCatalystEndpointProvider.endpointRule3(params, locals = locals.toBuilder().partitionResult(partitionResult).build());
                if (result.isResolved()) {
                    return result;
                }
                return DefaultCodeCatalystEndpointProvider.endpointRule6(params, locals);
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(CodeCatalystEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultCodeCatalystEndpointProvider.endpointRule4(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultCodeCatalystEndpointProvider.endpointRule5(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule4(CodeCatalystEndpointParams params, LocalState locals) {
        if (!locals.partitionResult().supportsFIPS()) {
            return RuleResult.error("Partition does not support FIPS.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule5(CodeCatalystEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://codecatalyst-fips.global." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule6(CodeCatalystEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://codecatalyst.global." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule7(CodeCatalystEndpointParams params, LocalState locals) {
        if (locals.region() != null) {
            RulePartition partitionResult = null;
            partitionResult = RulesFunctions.awsPartition(locals.region());
            if (partitionResult != null) {
                RuleResult result = DefaultCodeCatalystEndpointProvider.endpointRule8(params, locals = locals.toBuilder().partitionResult(partitionResult).build());
                if (result.isResolved()) {
                    return result;
                }
                return DefaultCodeCatalystEndpointProvider.endpointRule11(params, locals);
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(CodeCatalystEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultCodeCatalystEndpointProvider.endpointRule9(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultCodeCatalystEndpointProvider.endpointRule10(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule9(CodeCatalystEndpointParams params, LocalState locals) {
        if (!locals.partitionResult().supportsFIPS()) {
            return RuleResult.error("Partition does not support FIPS.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule10(CodeCatalystEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://codecatalyst-fips.global." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule11(CodeCatalystEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://codecatalyst.global." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private static final class LocalStateBuilder {
        private String region;
        private RulePartition partitionResult;

        LocalStateBuilder() {
            this.region = null;
            this.partitionResult = null;
        }

        LocalStateBuilder(LocalState locals) {
            this.region = locals.region;
            this.partitionResult = locals.partitionResult;
        }

        public LocalStateBuilder region(String value) {
            this.region = value;
            return this;
        }

        public LocalStateBuilder partitionResult(RulePartition value) {
            this.partitionResult = value;
            return this;
        }

        LocalState build() {
            return new LocalState(this);
        }
    }

    private static final class LocalState {
        private final String region;
        private final RulePartition partitionResult;

        LocalState() {
            this.region = null;
            this.partitionResult = null;
        }

        LocalState(Region region) {
            this.region = region != null ? region.id() : null;
            this.partitionResult = null;
        }

        LocalState(LocalStateBuilder builder) {
            this.region = builder.region;
            this.partitionResult = builder.partitionResult;
        }

        public String region() {
            return this.region;
        }

        public RulePartition partitionResult() {
            return this.partitionResult;
        }

        public LocalStateBuilder toBuilder() {
            return new LocalStateBuilder(this);
        }
    }
}

