/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cloudwatchlogs.model.DimensionsCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.StandardUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricTransformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricTransformation> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricName").getter(MetricTransformation.getter(MetricTransformation::metricName)).setter(MetricTransformation.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()}).build();
    private static final SdkField<String> METRIC_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricNamespace").getter(MetricTransformation.getter(MetricTransformation::metricNamespace)).setter(MetricTransformation.setter(Builder::metricNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricNamespace").build()}).build();
    private static final SdkField<String> METRIC_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricValue").getter(MetricTransformation.getter(MetricTransformation::metricValue)).setter(MetricTransformation.setter(Builder::metricValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricValue").build()}).build();
    private static final SdkField<Double> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("defaultValue").getter(MetricTransformation.getter(MetricTransformation::defaultValue)).setter(MetricTransformation.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()}).build();
    private static final SdkField<Map<String, String>> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("dimensions").getter(MetricTransformation.getter(MetricTransformation::dimensions)).setter(MetricTransformation.setter(Builder::dimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dimensions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("unit").getter(MetricTransformation.getter(MetricTransformation::unitAsString)).setter(MetricTransformation.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD, METRIC_NAMESPACE_FIELD, METRIC_VALUE_FIELD, DEFAULT_VALUE_FIELD, DIMENSIONS_FIELD, UNIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("metricName", METRIC_NAME_FIELD);
            this.put("metricNamespace", METRIC_NAMESPACE_FIELD);
            this.put("metricValue", METRIC_VALUE_FIELD);
            this.put("defaultValue", DEFAULT_VALUE_FIELD);
            this.put("dimensions", DIMENSIONS_FIELD);
            this.put("unit", UNIT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String metricName;
    private final String metricNamespace;
    private final String metricValue;
    private final Double defaultValue;
    private final Map<String, String> dimensions;
    private final String unit;

    private MetricTransformation(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.metricNamespace = builder.metricNamespace;
        this.metricValue = builder.metricValue;
        this.defaultValue = builder.defaultValue;
        this.dimensions = builder.dimensions;
        this.unit = builder.unit;
    }

    public final String metricName() {
        return this.metricName;
    }

    public final String metricNamespace() {
        return this.metricNamespace;
    }

    public final String metricValue() {
        return this.metricValue;
    }

    public final Double defaultValue() {
        return this.defaultValue;
    }

    public final boolean hasDimensions() {
        return this.dimensions != null && !(this.dimensions instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> dimensions() {
        return this.dimensions;
    }

    public final StandardUnit unit() {
        return StandardUnit.fromValue(this.unit);
    }

    public final String unitAsString() {
        return this.unit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensions() ? this.dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricTransformation)) {
            return false;
        }
        MetricTransformation other = (MetricTransformation)obj;
        return Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.metricNamespace(), other.metricNamespace()) && Objects.equals(this.metricValue(), other.metricValue()) && Objects.equals(this.defaultValue(), other.defaultValue()) && this.hasDimensions() == other.hasDimensions() && Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.unitAsString(), other.unitAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MetricTransformation").add("MetricName", (Object)this.metricName()).add("MetricNamespace", (Object)this.metricNamespace()).add("MetricValue", (Object)this.metricValue()).add("DefaultValue", (Object)this.defaultValue()).add("Dimensions", this.hasDimensions() ? this.dimensions() : null).add("Unit", (Object)this.unitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "metricNamespace": {
                return Optional.ofNullable(clazz.cast(this.metricNamespace()));
            }
            case "metricValue": {
                return Optional.ofNullable(clazz.cast(this.metricValue()));
            }
            case "defaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MetricTransformation, T> g) {
        return obj -> g.apply((MetricTransformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metricName;
        private String metricNamespace;
        private String metricValue;
        private Double defaultValue;
        private Map<String, String> dimensions = DefaultSdkAutoConstructMap.getInstance();
        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricTransformation model) {
            this.metricName(model.metricName);
            this.metricNamespace(model.metricNamespace);
            this.metricValue(model.metricValue);
            this.defaultValue(model.defaultValue);
            this.dimensions(model.dimensions);
            this.unit(model.unit);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getMetricNamespace() {
            return this.metricNamespace;
        }

        public final void setMetricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
        }

        @Override
        public final Builder metricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
            return this;
        }

        public final String getMetricValue() {
            return this.metricValue;
        }

        public final void setMetricValue(String metricValue) {
            this.metricValue = metricValue;
        }

        @Override
        public final Builder metricValue(String metricValue) {
            this.metricValue = metricValue;
            return this;
        }

        public final Double getDefaultValue() {
            return this.defaultValue;
        }

        public final void setDefaultValue(Double defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(Double defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final Map<String, String> getDimensions() {
            if (this.dimensions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.dimensions;
        }

        public final void setDimensions(Map<String, String> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
        }

        @Override
        public final Builder dimensions(Map<String, String> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(StandardUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public MetricTransformation build() {
            return new MetricTransformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricTransformation> {
        public Builder metricName(String var1);

        public Builder metricNamespace(String var1);

        public Builder metricValue(String var1);

        public Builder defaultValue(Double var1);

        public Builder dimensions(Map<String, String> var1);

        public Builder unit(String var1);

        public Builder unit(StandardUnit var1);
    }
}

