/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchevents.model.EventSourceState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PartnerEventSourceAccount
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PartnerEventSourceAccount> {
    private static final SdkField<String> ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Account").getter(PartnerEventSourceAccount.getter(PartnerEventSourceAccount::account)).setter(PartnerEventSourceAccount.setter(Builder::account)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Account").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(PartnerEventSourceAccount.getter(PartnerEventSourceAccount::creationTime)).setter(PartnerEventSourceAccount.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> EXPIRATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpirationTime").getter(PartnerEventSourceAccount.getter(PartnerEventSourceAccount::expirationTime)).setter(PartnerEventSourceAccount.setter(Builder::expirationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationTime").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(PartnerEventSourceAccount.getter(PartnerEventSourceAccount::stateAsString)).setter(PartnerEventSourceAccount.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_FIELD, CREATION_TIME_FIELD, EXPIRATION_TIME_FIELD, STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Account", ACCOUNT_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("ExpirationTime", EXPIRATION_TIME_FIELD);
            this.put("State", STATE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String account;
    private final Instant creationTime;
    private final Instant expirationTime;
    private final String state;

    private PartnerEventSourceAccount(BuilderImpl builder) {
        this.account = builder.account;
        this.creationTime = builder.creationTime;
        this.expirationTime = builder.expirationTime;
        this.state = builder.state;
    }

    public final String account() {
        return this.account;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant expirationTime() {
        return this.expirationTime;
    }

    public final EventSourceState state() {
        return EventSourceState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.account());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartnerEventSourceAccount)) {
            return false;
        }
        PartnerEventSourceAccount other = (PartnerEventSourceAccount)obj;
        return Objects.equals(this.account(), other.account()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.expirationTime(), other.expirationTime()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PartnerEventSourceAccount").add("Account", (Object)this.account()).add("CreationTime", (Object)this.creationTime()).add("ExpirationTime", (Object)this.expirationTime()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Account": {
                return Optional.ofNullable(clazz.cast(this.account()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "ExpirationTime": {
                return Optional.ofNullable(clazz.cast(this.expirationTime()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PartnerEventSourceAccount, T> g) {
        return obj -> g.apply((PartnerEventSourceAccount)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String account;
        private Instant creationTime;
        private Instant expirationTime;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(PartnerEventSourceAccount model) {
            this.account(model.account);
            this.creationTime(model.creationTime);
            this.expirationTime(model.expirationTime);
            this.state(model.state);
        }

        public final String getAccount() {
            return this.account;
        }

        public final void setAccount(String account) {
            this.account = account;
        }

        @Override
        public final Builder account(String account) {
            this.account = account;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getExpirationTime() {
            return this.expirationTime;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(EventSourceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public PartnerEventSourceAccount build() {
            return new PartnerEventSourceAccount(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PartnerEventSourceAccount> {
        public Builder account(String var1);

        public Builder creationTime(Instant var1);

        public Builder expirationTime(Instant var1);

        public Builder state(String var1);

        public Builder state(EventSourceState var1);
    }
}

