/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchRequest;
import software.amazon.awssdk.services.cloudwatch.model.EntityMetricData;
import software.amazon.awssdk.services.cloudwatch.model.EntityMetricDataListCopier;
import software.amazon.awssdk.services.cloudwatch.model.MetricDataCopier;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutMetricDataRequest
extends CloudWatchRequest
implements ToCopyableBuilder<Builder, PutMetricDataRequest> {
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(PutMetricDataRequest.getter(PutMetricDataRequest::namespace)).setter(PutMetricDataRequest.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()}).build();
    private static final SdkField<List<MetricDatum>> METRIC_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricData").getter(PutMetricDataRequest.getter(PutMetricDataRequest::metricData)).setter(PutMetricDataRequest.setter(Builder::metricData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricData").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricDatum::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EntityMetricData>> ENTITY_METRIC_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EntityMetricData").getter(PutMetricDataRequest.getter(PutMetricDataRequest::entityMetricData)).setter(PutMetricDataRequest.setter(Builder::entityMetricData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityMetricData").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EntityMetricData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> STRICT_ENTITY_VALIDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("StrictEntityValidation").getter(PutMetricDataRequest.getter(PutMetricDataRequest::strictEntityValidation)).setter(PutMetricDataRequest.setter(Builder::strictEntityValidation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StrictEntityValidation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD, METRIC_DATA_FIELD, ENTITY_METRIC_DATA_FIELD, STRICT_ENTITY_VALIDATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Namespace", NAMESPACE_FIELD);
            this.put("MetricData", METRIC_DATA_FIELD);
            this.put("EntityMetricData", ENTITY_METRIC_DATA_FIELD);
            this.put("StrictEntityValidation", STRICT_ENTITY_VALIDATION_FIELD);
        }
    });
    private final String namespace;
    private final List<MetricDatum> metricData;
    private final List<EntityMetricData> entityMetricData;
    private final Boolean strictEntityValidation;

    private PutMetricDataRequest(BuilderImpl builder) {
        super(builder);
        this.namespace = builder.namespace;
        this.metricData = builder.metricData;
        this.entityMetricData = builder.entityMetricData;
        this.strictEntityValidation = builder.strictEntityValidation;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final boolean hasMetricData() {
        return this.metricData != null && !(this.metricData instanceof SdkAutoConstructList);
    }

    public final List<MetricDatum> metricData() {
        return this.metricData;
    }

    public final boolean hasEntityMetricData() {
        return this.entityMetricData != null && !(this.entityMetricData instanceof SdkAutoConstructList);
    }

    public final List<EntityMetricData> entityMetricData() {
        return this.entityMetricData;
    }

    public final Boolean strictEntityValidation() {
        return this.strictEntityValidation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricData() ? this.metricData() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntityMetricData() ? this.entityMetricData() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.strictEntityValidation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMetricDataRequest)) {
            return false;
        }
        PutMetricDataRequest other = (PutMetricDataRequest)((Object)obj);
        return Objects.equals(this.namespace(), other.namespace()) && this.hasMetricData() == other.hasMetricData() && Objects.equals(this.metricData(), other.metricData()) && this.hasEntityMetricData() == other.hasEntityMetricData() && Objects.equals(this.entityMetricData(), other.entityMetricData()) && Objects.equals(this.strictEntityValidation(), other.strictEntityValidation());
    }

    public final String toString() {
        return ToString.builder((String)"PutMetricDataRequest").add("Namespace", (Object)this.namespace()).add("MetricData", this.hasMetricData() ? this.metricData() : null).add("EntityMetricData", this.hasEntityMetricData() ? this.entityMetricData() : null).add("StrictEntityValidation", (Object)this.strictEntityValidation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "MetricData": {
                return Optional.ofNullable(clazz.cast(this.metricData()));
            }
            case "EntityMetricData": {
                return Optional.ofNullable(clazz.cast(this.entityMetricData()));
            }
            case "StrictEntityValidation": {
                return Optional.ofNullable(clazz.cast(this.strictEntityValidation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutMetricDataRequest, T> g) {
        return obj -> g.apply((PutMetricDataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchRequest.BuilderImpl
    implements Builder {
        private String namespace;
        private List<MetricDatum> metricData = DefaultSdkAutoConstructList.getInstance();
        private List<EntityMetricData> entityMetricData = DefaultSdkAutoConstructList.getInstance();
        private Boolean strictEntityValidation;

        private BuilderImpl() {
        }

        private BuilderImpl(PutMetricDataRequest model) {
            super(model);
            this.namespace(model.namespace);
            this.metricData(model.metricData);
            this.entityMetricData(model.entityMetricData);
            this.strictEntityValidation(model.strictEntityValidation);
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final List<MetricDatum.Builder> getMetricData() {
            List<MetricDatum.Builder> result = MetricDataCopier.copyToBuilder(this.metricData);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricData(Collection<MetricDatum.BuilderImpl> metricData) {
            this.metricData = MetricDataCopier.copyFromBuilder(metricData);
        }

        @Override
        public final Builder metricData(Collection<MetricDatum> metricData) {
            this.metricData = MetricDataCopier.copy(metricData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricData(MetricDatum ... metricData) {
            this.metricData(Arrays.asList(metricData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricData(Consumer<MetricDatum.Builder> ... metricData) {
            this.metricData(Stream.of(metricData).map(c -> (MetricDatum)((MetricDatum.Builder)MetricDatum.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EntityMetricData.Builder> getEntityMetricData() {
            List<EntityMetricData.Builder> result = EntityMetricDataListCopier.copyToBuilder(this.entityMetricData);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntityMetricData(Collection<EntityMetricData.BuilderImpl> entityMetricData) {
            this.entityMetricData = EntityMetricDataListCopier.copyFromBuilder(entityMetricData);
        }

        @Override
        public final Builder entityMetricData(Collection<EntityMetricData> entityMetricData) {
            this.entityMetricData = EntityMetricDataListCopier.copy(entityMetricData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityMetricData(EntityMetricData ... entityMetricData) {
            this.entityMetricData(Arrays.asList(entityMetricData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityMetricData(Consumer<EntityMetricData.Builder> ... entityMetricData) {
            this.entityMetricData(Stream.of(entityMetricData).map(c -> (EntityMetricData)((EntityMetricData.Builder)EntityMetricData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getStrictEntityValidation() {
            return this.strictEntityValidation;
        }

        public final void setStrictEntityValidation(Boolean strictEntityValidation) {
            this.strictEntityValidation = strictEntityValidation;
        }

        @Override
        public final Builder strictEntityValidation(Boolean strictEntityValidation) {
            this.strictEntityValidation = strictEntityValidation;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutMetricDataRequest build() {
            return new PutMetricDataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudWatchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutMetricDataRequest> {
        public Builder namespace(String var1);

        public Builder metricData(Collection<MetricDatum> var1);

        public Builder metricData(MetricDatum ... var1);

        public Builder metricData(Consumer<MetricDatum.Builder> ... var1);

        public Builder entityMetricData(Collection<EntityMetricData> var1);

        public Builder entityMetricData(EntityMetricData ... var1);

        public Builder entityMetricData(Consumer<EntityMetricData.Builder> ... var1);

        public Builder strictEntityValidation(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

