/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InsightRuleContributorDatapoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InsightRuleContributorDatapoint> {
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(InsightRuleContributorDatapoint.getter(InsightRuleContributorDatapoint::timestamp)).setter(InsightRuleContributorDatapoint.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<Double> APPROXIMATE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ApproximateValue").getter(InsightRuleContributorDatapoint.getter(InsightRuleContributorDatapoint::approximateValue)).setter(InsightRuleContributorDatapoint.setter(Builder::approximateValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, APPROXIMATE_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Timestamp", TIMESTAMP_FIELD);
            this.put("ApproximateValue", APPROXIMATE_VALUE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Instant timestamp;
    private final Double approximateValue;

    private InsightRuleContributorDatapoint(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.approximateValue = builder.approximateValue;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final Double approximateValue() {
        return this.approximateValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightRuleContributorDatapoint)) {
            return false;
        }
        InsightRuleContributorDatapoint other = (InsightRuleContributorDatapoint)obj;
        return Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.approximateValue(), other.approximateValue());
    }

    public final String toString() {
        return ToString.builder((String)"InsightRuleContributorDatapoint").add("Timestamp", (Object)this.timestamp()).add("ApproximateValue", (Object)this.approximateValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "ApproximateValue": {
                return Optional.ofNullable(clazz.cast(this.approximateValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InsightRuleContributorDatapoint, T> g) {
        return obj -> g.apply((InsightRuleContributorDatapoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant timestamp;
        private Double approximateValue;

        private BuilderImpl() {
        }

        private BuilderImpl(InsightRuleContributorDatapoint model) {
            this.timestamp(model.timestamp);
            this.approximateValue(model.approximateValue);
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final Double getApproximateValue() {
            return this.approximateValue;
        }

        public final void setApproximateValue(Double approximateValue) {
            this.approximateValue = approximateValue;
        }

        @Override
        public final Builder approximateValue(Double approximateValue) {
            this.approximateValue = approximateValue;
            return this;
        }

        public InsightRuleContributorDatapoint build() {
            return new InsightRuleContributorDatapoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InsightRuleContributorDatapoint> {
        public Builder timestamp(Instant var1);

        public Builder approximateValue(Double var1);
    }
}

