/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateOriginRequestPolicyRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, UpdateOriginRequestPolicyRequest> {
    private static final SdkField<OriginRequestPolicyConfig> ORIGIN_REQUEST_POLICY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OriginRequestPolicyConfig").getter(UpdateOriginRequestPolicyRequest.getter(UpdateOriginRequestPolicyRequest::originRequestPolicyConfig)).setter(UpdateOriginRequestPolicyRequest.setter(Builder::originRequestPolicyConfig)).constructor(OriginRequestPolicyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginRequestPolicyConfig").unmarshallLocationName("OriginRequestPolicyConfig").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(UpdateOriginRequestPolicyRequest.getter(UpdateOriginRequestPolicyRequest::id)).setter(UpdateOriginRequestPolicyRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<String> IF_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IfMatch").getter(UpdateOriginRequestPolicyRequest.getter(UpdateOriginRequestPolicyRequest::ifMatch)).setter(UpdateOriginRequestPolicyRequest.setter(Builder::ifMatch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match").unmarshallLocationName("If-Match").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGIN_REQUEST_POLICY_CONFIG_FIELD, ID_FIELD, IF_MATCH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("OriginRequestPolicyConfig", ORIGIN_REQUEST_POLICY_CONFIG_FIELD);
            this.put("Id", ID_FIELD);
            this.put("If-Match", IF_MATCH_FIELD);
        }
    });
    private final OriginRequestPolicyConfig originRequestPolicyConfig;
    private final String id;
    private final String ifMatch;

    private UpdateOriginRequestPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.originRequestPolicyConfig = builder.originRequestPolicyConfig;
        this.id = builder.id;
        this.ifMatch = builder.ifMatch;
    }

    public final OriginRequestPolicyConfig originRequestPolicyConfig() {
        return this.originRequestPolicyConfig;
    }

    public final String id() {
        return this.id;
    }

    public final String ifMatch() {
        return this.ifMatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.originRequestPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.ifMatch());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOriginRequestPolicyRequest)) {
            return false;
        }
        UpdateOriginRequestPolicyRequest other = (UpdateOriginRequestPolicyRequest)((Object)obj);
        return Objects.equals(this.originRequestPolicyConfig(), other.originRequestPolicyConfig()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.ifMatch(), other.ifMatch());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateOriginRequestPolicyRequest").add("OriginRequestPolicyConfig", (Object)this.originRequestPolicyConfig()).add("Id", (Object)this.id()).add("IfMatch", (Object)this.ifMatch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OriginRequestPolicyConfig": {
                return Optional.ofNullable(clazz.cast(this.originRequestPolicyConfig()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "IfMatch": {
                return Optional.ofNullable(clazz.cast(this.ifMatch()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateOriginRequestPolicyRequest, T> g) {
        return obj -> g.apply((UpdateOriginRequestPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private OriginRequestPolicyConfig originRequestPolicyConfig;
        private String id;
        private String ifMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOriginRequestPolicyRequest model) {
            super(model);
            this.originRequestPolicyConfig(model.originRequestPolicyConfig);
            this.id(model.id);
            this.ifMatch(model.ifMatch);
        }

        public final OriginRequestPolicyConfig.Builder getOriginRequestPolicyConfig() {
            return this.originRequestPolicyConfig != null ? this.originRequestPolicyConfig.toBuilder() : null;
        }

        public final void setOriginRequestPolicyConfig(OriginRequestPolicyConfig.BuilderImpl originRequestPolicyConfig) {
            this.originRequestPolicyConfig = originRequestPolicyConfig != null ? originRequestPolicyConfig.build() : null;
        }

        @Override
        public final Builder originRequestPolicyConfig(OriginRequestPolicyConfig originRequestPolicyConfig) {
            this.originRequestPolicyConfig = originRequestPolicyConfig;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getIfMatch() {
            return this.ifMatch;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateOriginRequestPolicyRequest build() {
            return new UpdateOriginRequestPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateOriginRequestPolicyRequest> {
        public Builder originRequestPolicyConfig(OriginRequestPolicyConfig var1);

        default public Builder originRequestPolicyConfig(Consumer<OriginRequestPolicyConfig.Builder> originRequestPolicyConfig) {
            return this.originRequestPolicyConfig((OriginRequestPolicyConfig)((OriginRequestPolicyConfig.Builder)OriginRequestPolicyConfig.builder().applyMutation(originRequestPolicyConfig)).build());
        }

        public Builder id(String var1);

        public Builder ifMatch(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

